/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap;

import com.thevoxelbox.voxelmap.MapSettingsManager;
import com.thevoxelbox.voxelmap.interfaces.IVoxelMap;
import com.thevoxelbox.voxelmap.interfaces.IWaypointManager;
import com.thevoxelbox.voxelmap.util.ChatUtils;
import com.thevoxelbox.voxelmap.util.EntityWaypointContainer;
import com.thevoxelbox.voxelmap.util.FilesystemUtils;
import com.thevoxelbox.voxelmap.util.GameVariableAccessShim;
import com.thevoxelbox.voxelmap.util.Waypoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;

public class WaypointManager
implements IWaypointManager {
    IVoxelMap master;
    public MapSettingsManager options = null;
    private ArrayList<Waypoint> wayPts = new ArrayList();
    private ArrayList<Waypoint> old2dWayPts = new ArrayList();
    private ArrayList<Waypoint> updatedPts;
    private String currentSubWorldName = "";
    private String currentSubWorldHash = "";
    private String currentSubWorldDescriptor = "";
    private EntityWaypointContainer entityWaypointContainer = null;
    private File settingsFile;
    private Object lock = new Object();

    public WaypointManager(IVoxelMap master) {
        this.master = master;
        this.options = master.getMapOptions();
    }

    @Override
    public ArrayList<Waypoint> getWaypoints() {
        return this.wayPts;
    }

    @Override
    public void handleDeath() {
        TreeSet<Integer> toDel = new TreeSet<Integer>();
        for (Waypoint pt : this.wayPts) {
            if (pt.name.equals("Latest Death")) {
                pt.name = "Previous Death";
            }
            if (!pt.name.startsWith("Previous Death")) continue;
            if (this.options.deathpoints > 1) {
                int num = 0;
                try {
                    if (pt.name.length() > 15) {
                        num = Integer.parseInt(pt.name.substring(15));
                    }
                }
                catch (Exception e) {
                    num = 0;
                }
                pt.red -= (pt.red - 0.5f) / 8.0f;
                pt.green -= (pt.green - 0.5f) / 8.0f;
                pt.blue -= (pt.blue - 0.5f) / 8.0f;
                pt.name = "Previous Death " + (num + 1);
                continue;
            }
            toDel.add(this.wayPts.indexOf(pt));
        }
        if (this.options.deathpoints < 2 && toDel.size() > 0) {
            TreeSet toDelReverse = (TreeSet)toDel.descendingSet();
            for (Integer index : toDelReverse) {
                this.deleteWaypoint(index);
            }
        }
        if (this.options.deathpoints > 0) {
            bje thePlayer = azd.A().h;
            TreeSet<Integer> dimensions = new TreeSet<Integer>();
            dimensions.add(azd.A().h.aq);
            this.addWaypoint(new Waypoint("Latest Death", thePlayer.aq != -1 ? GameVariableAccessShim.xCoord() : GameVariableAccessShim.xCoord() * 8, thePlayer.aq != -1 ? GameVariableAccessShim.zCoord() : GameVariableAccessShim.zCoord() * 8, GameVariableAccessShim.yCoord() - 1, true, 1.0f, 1.0f, 1.0f, "skull", this.currentSubWorldName, dimensions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newWorld(int dimension) {
        Object object = this.lock;
        synchronized (object) {
            for (Waypoint pt : this.wayPts) {
                if (pt.dimensions.size() == 0 || pt.dimensions.contains(dimension)) {
                    pt.inDimension = true;
                    continue;
                }
                pt.inDimension = false;
            }
            this.injectWaypointEntity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSubWorldDescriptor(String descriptor) {
        this.currentSubWorldDescriptor = descriptor;
        Object object = this.lock;
        synchronized (object) {
            String currentSubWorldDescriptorScrubbed = this.scrubName(descriptor);
            for (Waypoint pt : this.wayPts) {
                if (currentSubWorldDescriptorScrubbed == "" || pt.world == "" || currentSubWorldDescriptorScrubbed.equals(pt.world)) {
                    pt.inWorld = true;
                    continue;
                }
                pt.inWorld = false;
            }
        }
    }

    @Override
    public void newSubWorldName(String name) {
        this.currentSubWorldName = name;
        this.newSubWorldDescriptor(this.currentSubWorldName);
    }

    @Override
    public void newSubWorldHash(String hash) {
        this.currentSubWorldHash = hash;
        if (this.currentSubWorldName.equals("")) {
            this.newSubWorldDescriptor(this.currentSubWorldHash);
        }
    }

    @Override
    public String getCurrentSubworldDescriptor() {
        return this.currentSubWorldDescriptor;
    }

    @Override
    public void saveWaypoints() {
        File mcDir;
        int portSepLoc;
        String worldNameSave = this.master.getMap().getCurrentWorldName();
        if (worldNameSave.endsWith(":25565") && (portSepLoc = worldNameSave.lastIndexOf(":")) != -1) {
            worldNameSave = worldNameSave.substring(0, portSepLoc);
        }
        worldNameSave = this.scrubFileName(worldNameSave);
        File homeDir = FilesystemUtils.getAppDir("minecraft", true).getAbsoluteFile();
        if (!homeDir.equals(mcDir = azd.A().w.getAbsoluteFile())) {
            String localDirName = "";
            if (azd.A().E()) {
                localDirName = mcDir.getName();
                if ((localDirName.equalsIgnoreCase("minecraft") || localDirName.equalsIgnoreCase(".")) && mcDir.getParentFile() != null) {
                    localDirName = mcDir.getParentFile().getName();
                }
                localDirName = "~" + localDirName;
            }
            this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/VoxelMods/voxelMap", true), worldNameSave + localDirName + ".points");
            this.saveWaypointsTo(this.settingsFile);
            homeDir = new File(azd.A().w, "/mods/VoxelMods/voxelMap/");
            if (!homeDir.exists()) {
                homeDir.mkdirs();
            }
            this.settingsFile = new File(azd.A().w, "/mods/VoxelMods/voxelMap/" + worldNameSave + ".points");
            this.saveWaypointsTo(this.settingsFile);
        } else {
            this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/VoxelMods/voxelMap", true), worldNameSave + ".points");
            this.saveWaypointsTo(this.settingsFile);
        }
    }

    public void saveWaypointsTo(File settingsFile) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
            Date now = new Date();
            String timestamp = new SimpleDateFormat("yyyyMMddHHmm").format(now);
            out.println("filetimestamp:" + timestamp);
            for (Waypoint pt : this.wayPts) {
                if (pt.name.startsWith("^")) continue;
                String dimensionsString = "";
                for (Integer dimension : pt.dimensions) {
                    dimensionsString = dimensionsString + "" + dimension + "#";
                }
                if (dimensionsString.equals("")) {
                    dimensionsString = "-1#0#";
                }
                out.println("name:" + this.scrubName(pt.name) + ",x:" + pt.x + ",z:" + pt.z + ",y:" + pt.y + ",enabled:" + Boolean.toString(pt.enabled) + ",red:" + pt.red + ",green:" + pt.green + ",blue:" + pt.blue + ",suffix:" + pt.imageSuffix + ",world:" + this.scrubName(pt.world) + ",dimensions:" + dimensionsString);
            }
            out.close();
        }
        catch (Exception local) {
            ChatUtils.chatInfo("\u00a7EError Saving Waypoints");
        }
    }

    public String scrubName(String input) {
        input = input.replace(":", "~colon~");
        input = input.replace(",", "~comma~");
        return input;
    }

    private String descrubName(String input) {
        input = input.replace("~colon~", ":");
        input = input.replace("~comma~", ",");
        return input;
    }

    public String scrubFileName(String input) {
        input = input.replace("<", "~less~");
        input = input.replace(">", "~greater~");
        input = input.replace(":", "~colon~");
        input = input.replace("\"", "~quote~");
        input = input.replace("/", "~slash~");
        input = input.replace("\\", "~backslash~");
        input = input.replace("|", "~pipe~");
        input = input.replace("?", "~question~");
        input = input.replace("*", "~star~");
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadWaypoints() {
        Object object = this.lock;
        synchronized (object) {
            int portSepLoc;
            boolean loaded = false;
            this.wayPts = new ArrayList();
            String worldNameStandard = this.master.getMap().getCurrentWorldName();
            if (worldNameStandard.endsWith(":25565") && (portSepLoc = worldNameStandard.lastIndexOf(":")) != -1) {
                worldNameStandard = worldNameStandard.substring(0, portSepLoc);
            }
            worldNameStandard = this.scrubFileName(worldNameStandard);
            String worldNameWithPort = this.scrubFileName(this.master.getMap().getCurrentWorldName());
            String worldNameWithoutPort = this.master.getMap().getCurrentWorldName();
            int portSepLoc2 = worldNameWithoutPort.lastIndexOf(":");
            if (portSepLoc2 != -1) {
                worldNameWithoutPort = worldNameWithoutPort.substring(0, portSepLoc2);
            }
            worldNameWithoutPort = this.scrubFileName(worldNameWithoutPort);
            String worldNameWithDefaultPort = this.scrubFileName(worldNameWithoutPort + "~colon~25565");
            loaded = this.loadWaypointsExtensible(worldNameStandard);
            if (!loaded) {
                loaded = this.loadOldWaypoints(worldNameWithoutPort, worldNameWithDefaultPort, worldNameWithPort);
            }
            if (!loaded) {
                loaded = this.findReiWaypoints(worldNameWithoutPort);
            }
            if (!loaded) {
                ChatUtils.chatInfo("\u00a7ENo waypoints exist for this world/server.");
            } else {
                this.populateOld2dWaypoints();
            }
        }
        this.newSubWorldDescriptor(this.currentSubWorldDescriptor);
    }

    private boolean loadWaypointsExtensible(String worldNameStandard) {
        File mcDir;
        File homeDir = FilesystemUtils.getAppDir("minecraft", false).getAbsoluteFile();
        if (!homeDir.equals(mcDir = azd.A().w.getAbsoluteFile())) {
            long homeDate = -1L;
            long localDate = -1L;
            String localDirName = "";
            if (azd.A().E()) {
                localDirName = mcDir.getName();
                if ((localDirName.equalsIgnoreCase("minecraft") || localDirName.equalsIgnoreCase(".")) && mcDir.getParentFile() != null) {
                    localDirName = mcDir.getParentFile().getName();
                }
                localDirName = "~" + localDirName;
            }
            File settingsFileLocal = new File(azd.A().w, "/mods/VoxelMods/voxelMap/" + worldNameStandard + ".points");
            localDate = this.getDateFromSave(settingsFileLocal);
            File settingsFileHome = new File(FilesystemUtils.getAppDir("minecraft/mods/VoxelMods/voxelMap", false), worldNameStandard + localDirName + ".points");
            if (!settingsFileHome.exists() && !settingsFileLocal.exists()) {
                settingsFileHome = new File(FilesystemUtils.getAppDir("minecraft/mods/VoxelMods/voxelMap", false), worldNameStandard + ".points");
            }
            homeDate = this.getDateFromSave(settingsFileHome);
            if (!settingsFileHome.exists() && !settingsFileLocal.exists()) {
                return false;
            }
            this.settingsFile = !settingsFileHome.exists() ? settingsFileLocal : (!settingsFileLocal.exists() ? settingsFileHome : (homeDate > localDate ? settingsFileHome : settingsFileLocal));
        } else {
            this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/VoxelMods/voxelMap", false), worldNameStandard + ".points");
        }
        if (this.settingsFile.exists()) {
            try {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new FileReader(this.settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    if (sCurrentLine.startsWith("filetimestamp")) continue;
                    String[] curLine = sCurrentLine.split(",");
                    String name = "";
                    int x = 0;
                    int z = 0;
                    int y2 = -1;
                    boolean enabled = false;
                    float red = 0.5f;
                    float green = 0.0f;
                    float blue = 0.0f;
                    String suffix = "";
                    String world = "";
                    TreeSet<Integer> dimensions = new TreeSet<Integer>();
                    for (int t = 0; t < curLine.length; ++t) {
                        String[] keyValuePair = curLine[t].split(":");
                        if (keyValuePair.length != 2) continue;
                        String key = keyValuePair[0];
                        String value = keyValuePair[1];
                        if (key.equals("name")) {
                            name = this.descrubName(value);
                            continue;
                        }
                        if (key.equals("x")) {
                            x = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals("z")) {
                            z = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals("y")) {
                            y2 = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals("enabled")) {
                            enabled = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (key.equals("red")) {
                            red = Float.parseFloat(value);
                            continue;
                        }
                        if (key.equals("green")) {
                            green = Float.parseFloat(value);
                            continue;
                        }
                        if (key.equals("blue")) {
                            blue = Float.parseFloat(value);
                            continue;
                        }
                        if (key.equals("suffix")) {
                            suffix = value;
                            continue;
                        }
                        if (key.equals("world")) {
                            world = this.descrubName(value);
                            continue;
                        }
                        if (!key.equals("dimensions")) continue;
                        String[] dimensionStrings = value.split("#");
                        for (int s = 0; s < dimensionStrings.length; ++s) {
                            dimensions.add(Integer.parseInt(dimensionStrings[s]));
                        }
                        if (dimensions.size() != 0) continue;
                        dimensions.add(0);
                        dimensions.add(-1);
                    }
                    if (name.equals("")) continue;
                    this.loadWaypoint(name, x, z, y2, enabled, red, green, blue, suffix, world, dimensions);
                }
                in.close();
            }
            catch (Exception local) {
                ChatUtils.chatInfo("\u00a7EError Loading Waypoints");
                System.err.println("waypoint load error: " + local.getLocalizedMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    private long getDateFromSave(File settingsFile) {
        if (settingsFile.exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(settingsFile));
                String sCurrentLine = in.readLine();
                String[] curLine = sCurrentLine.split(":");
                in.close();
                if (curLine[0].equals("filetimestamp")) {
                    return Long.parseLong(curLine[1]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1L;
    }

    private boolean loadOldWaypoints(String worldNameWithPort, String worldNameWithDefaultPort, String worldNameWithoutPort) {
        try {
            this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/zan", false), worldNameWithPort + ".points");
            if (!this.settingsFile.exists()) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/zan", false), worldNameWithDefaultPort + ".points");
            }
            if (!this.settingsFile.exists()) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/zan", false), worldNameWithoutPort + ".points");
            }
            if (!this.settingsFile.exists()) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft", false), worldNameWithoutPort + ".points");
            }
            if (this.settingsFile.exists()) {
                String sCurrentLine;
                TreeSet<Integer> dimensions = new TreeSet<Integer>();
                dimensions.add(-1);
                dimensions.add(0);
                BufferedReader in = new BufferedReader(new FileReader(this.settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] curLine = sCurrentLine.split(":");
                    if (curLine.length == 4) {
                        this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), -1, Boolean.parseBoolean(curLine[3]), 0.0f, 1.0f, 0.0f, "", "", dimensions);
                        continue;
                    }
                    if (curLine.length == 7) {
                        this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), -1, Boolean.parseBoolean(curLine[3]), Float.parseFloat(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), "", "", dimensions);
                        continue;
                    }
                    if (curLine.length == 8) {
                        if (curLine[3].contains("true") || curLine[3].contains("false")) {
                            this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), -1, Boolean.parseBoolean(curLine[3]), Float.parseFloat(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), curLine[7], "", dimensions);
                            continue;
                        }
                        this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), Integer.parseInt(curLine[3]), Boolean.parseBoolean(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), Float.parseFloat(curLine[7]), "", "", dimensions);
                        continue;
                    }
                    if (curLine.length != 9) continue;
                    this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), Integer.parseInt(curLine[3]), Boolean.parseBoolean(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), Float.parseFloat(curLine[7]), curLine[8], "", dimensions);
                }
                in.close();
                return true;
            }
            return false;
        }
        catch (Exception local) {
            ChatUtils.chatInfo("\u00a7EError Loading Waypoints");
            System.err.println("waypoint load error: " + local.getLocalizedMessage());
            return false;
        }
    }

    private boolean findReiWaypoints(String worldNameWithoutPort) {
        boolean foundSome = false;
        this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/rei_minimap", false), worldNameWithoutPort + ".points");
        if (!this.settingsFile.exists()) {
            this.settingsFile = new File(azd.A().w, "/mods/rei_minimap/" + worldNameWithoutPort + ".points");
        }
        if (this.settingsFile.exists()) {
            this.loadReiWaypoints(this.settingsFile, 0);
            foundSome = true;
        } else {
            for (int t = -25; t < 25; ++t) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/rei_minimap", false), worldNameWithoutPort + ".DIM" + t + ".points");
                if (!this.settingsFile.exists()) {
                    this.settingsFile = new File(azd.A().w, "/mods/rei_minimap/" + worldNameWithoutPort + ".DIM" + t + ".points");
                }
                if (!this.settingsFile.exists()) continue;
                foundSome = true;
                this.loadReiWaypoints(this.settingsFile, t);
            }
        }
        return foundSome;
    }

    private void loadReiWaypoints(File settingsFile, int dimension) {
        try {
            if (settingsFile.exists()) {
                String sCurrentLine;
                TreeSet<Integer> dimensions = new TreeSet<Integer>();
                dimensions.add(dimension);
                BufferedReader in = new BufferedReader(new FileReader(settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] curLine = sCurrentLine.split(":");
                    if (curLine.length != 6) continue;
                    int color = Integer.parseInt(curLine[5], 16);
                    float red = (float)(color >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color >> 0 & 0xFF) / 255.0f;
                    int x = Integer.parseInt(curLine[1]);
                    int z = Integer.parseInt(curLine[3]);
                    if (dimension == -1) {
                        x *= 8;
                        z *= 8;
                    }
                    this.loadWaypoint(curLine[0], x, z, Integer.parseInt(curLine[2]), Boolean.parseBoolean(curLine[4]), red, green, blue, "", "", dimensions);
                }
                in.close();
            }
        }
        catch (Exception e) {
            ChatUtils.chatInfo("\u00a7EError Loading Old Rei Waypoints");
            System.err.println("waypoint load error: " + e.getLocalizedMessage());
        }
    }

    public void loadWaypoint(String name, int x, int z, int y2, boolean enabled, float red, float green, float blue, String suffix, String world, TreeSet<Integer> dimensions) {
        Waypoint newWaypoint = new Waypoint(name, x, z, y2, enabled, red, green, blue, suffix, world, dimensions);
        this.wayPts.add(newWaypoint);
    }

    public void populateOld2dWaypoints() {
        this.old2dWayPts = new ArrayList();
        for (Waypoint wpt : this.wayPts) {
            if (wpt.getY() > 0) continue;
            this.old2dWayPts.add(wpt);
        }
    }

    @Override
    public void check2dWaypoints() {
        if (azd.A().h.aq == 0 && this.old2dWayPts.size() > 0) {
            this.updatedPts = new ArrayList();
            for (Waypoint pt : this.old2dWayPts) {
                if (Math.abs(pt.getX() - GameVariableAccessShim.xCoord()) >= 400 || Math.abs(pt.getZ() - GameVariableAccessShim.zCoord()) >= 400 || !azd.A().h.p.d((int)pt.getX(), (int)pt.getZ()).d) continue;
                pt.setY(azd.A().h.p.f(pt.getX(), pt.getZ()));
                this.updatedPts.add(pt);
                this.saveWaypoints();
            }
            this.old2dWayPts.removeAll(this.updatedPts);
            System.out.println("remaining old 2d waypoints: " + this.old2dWayPts.size());
        }
    }

    private void deleteWaypoint(int i) {
        this.old2dWayPts.remove(this.wayPts.get(i));
        this.entityWaypointContainer.removeWaypoint(this.wayPts.get(i));
        this.wayPts.remove(i);
        this.saveWaypoints();
    }

    @Override
    public void deleteWaypoint(Waypoint point) {
        this.old2dWayPts.remove(point);
        this.entityWaypointContainer.removeWaypoint(point);
        this.wayPts.remove(point);
        this.saveWaypoints();
    }

    @Override
    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
        this.entityWaypointContainer.addWaypoint(newWaypoint);
        this.saveWaypoints();
    }

    private void purgeWaypointEntity() {
        List entities = azd.A().f.C();
        for (int t = 0; t < entities.size(); ++t) {
            qn entity = (qn)entities.get(t);
            if (!(entity instanceof EntityWaypointContainer)) continue;
            entity.B();
        }
    }

    public void injectWaypointEntity() {
        this.entityWaypointContainer = new EntityWaypointContainer((afn)azd.A().f);
        for (Waypoint wpt : this.wayPts) {
            this.entityWaypointContainer.addWaypoint(wpt);
        }
        azd.A().f.d((qn)this.entityWaypointContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveWaypointEntityToBack() {
        List entities;
        List list = entities = azd.A().f.C();
        synchronized (list) {
            int t = entities.indexOf((Object)this.entityWaypointContainer);
            if (t == -1) {
                this.purgeWaypointEntity();
                this.injectWaypointEntity();
                return;
            }
            if (t != entities.size() - 1) {
                Collections.swap(entities, t, entities.size() - 1);
            }
        }
    }
}

