/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.gui;

import com.thevoxelbox.voxelmap.MapSettingsManager;
import com.thevoxelbox.voxelmap.gui.GuiScreenAddWaypoint;
import com.thevoxelbox.voxelmap.gui.GuiSlotWaypoints;
import com.thevoxelbox.voxelmap.gui.GuiWaypointsOptions;
import com.thevoxelbox.voxelmap.gui.overridden.GuiScreenMinimap;
import com.thevoxelbox.voxelmap.interfaces.IVoxelMap;
import com.thevoxelbox.voxelmap.interfaces.IWaypointManager;
import com.thevoxelbox.voxelmap.util.GameVariableAccessShim;
import com.thevoxelbox.voxelmap.util.I18nUtils;
import com.thevoxelbox.voxelmap.util.Waypoint;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.server.MinecraftServer;

public class GuiWaypoints
extends GuiScreenMinimap {
    private final bcd parentScreen;
    private IVoxelMap master;
    protected final MapSettingsManager options;
    protected final IWaypointManager waypointManager;
    protected String screenTitle = "Waypoints";
    private GuiSlotWaypoints waypointList;
    private ban buttonEdit;
    protected boolean editClicked = false;
    private ban buttonDelete;
    private boolean deleteClicked = false;
    private ban buttonTeleport;
    private ban buttonSortName;
    private ban buttonSortCreated;
    private ban buttonSortDistance;
    private ban buttonSortColor;
    private boolean addClicked = false;
    private String tooltip = null;
    protected Waypoint selectedWaypoint = null;
    protected Waypoint newWaypoint = null;
    private Random generator = new Random();
    private boolean changedSort = false;

    public GuiWaypoints(bcd parentScreen, IVoxelMap master) {
        this.master = master;
        this.parentScreen = parentScreen;
        this.options = master.getMapOptions();
        this.waypointManager = master.getWaypointManager();
    }

    public void r_() {
        boolean isSomethingSelected;
        boolean var2 = false;
        this.screenTitle = I18nUtils.getString("minimap.waypoints.title");
        this.waypointList = new GuiSlotWaypoints(this);
        this.waypointList.d(7, 8);
        this.buttonSortName = new ban(this.options.SORT_NAME, this.getWidth() / 2 - 154, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbyname"));
        this.getButtonList().add(this.buttonSortName);
        this.buttonSortDistance = new ban(this.options.SORT_DISTANCE, this.getWidth() / 2 - 77, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbydistance"));
        this.getButtonList().add(this.buttonSortDistance);
        this.buttonSortCreated = new ban(this.options.SORT_DATE, this.getWidth() / 2, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbycreated"));
        this.getButtonList().add(this.buttonSortCreated);
        this.buttonSortColor = new ban(this.options.SORT_COLOR, this.getWidth() / 2 + 77, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbycolor"));
        this.getButtonList().add(this.buttonSortColor);
        this.buttonEdit = new ban(-1, this.getWidth() / 2 - 154, this.getHeight() - 52, 100, 20, I18nUtils.getString("selectServer.edit"));
        this.getButtonList().add(this.buttonEdit);
        this.buttonDelete = new ban(-2, this.getWidth() / 2 - 50, this.getHeight() - 52, 100, 20, I18nUtils.getString("selectServer.delete"));
        this.getButtonList().add(this.buttonDelete);
        this.buttonTeleport = new ban(-3, this.getWidth() / 2 + 4 + 50, this.getHeight() - 52, 100, 20, I18nUtils.getString("minimap.waypoints.teleportto"));
        this.getButtonList().add(this.buttonTeleport);
        this.getButtonList().add(new ban(-4, this.getWidth() / 2 - 154, this.getHeight() - 28, 100, 20, I18nUtils.getString("minimap.waypoints.newwaypoint")));
        this.getButtonList().add(new ban(-5, this.getWidth() / 2 - 50, this.getHeight() - 28, 100, 20, I18nUtils.getString("menu.options")));
        this.getButtonList().add(new ban(-200, this.getWidth() / 2 + 4 + 50, this.getHeight() - 28, 100, 20, I18nUtils.getString("gui.done")));
        this.buttonEdit.l = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.l = isSomethingSelected;
        this.buttonTeleport.l = isSomethingSelected && this.canTeleport();
        this.sort();
    }

    private void sort() {
        int sortKey = Math.abs(this.options.sort);
        boolean ascending = this.options.sort > 0;
        this.waypointList.sortBy(sortKey, ascending);
        String arrow = ascending ? "\u2191" : "\u2193";
        this.buttonSortName.j = sortKey == this.options.SORT_NAME ? arrow + " " + I18nUtils.getString("mco.configure.world.name") + " " + arrow : I18nUtils.getString("mco.configure.world.name");
        this.buttonSortDistance.j = sortKey == this.options.SORT_DISTANCE ? arrow + " " + I18nUtils.getString("minimap.waypoints.sortbydistance") + " " + arrow : I18nUtils.getString("minimap.waypoints.sortbydistance");
        this.buttonSortCreated.j = sortKey == this.options.SORT_DATE ? arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycreated") + " " + arrow : I18nUtils.getString("minimap.waypoints.sortbycreated");
        this.buttonSortColor.j = sortKey == this.options.SORT_COLOR ? arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycolor") + " " + arrow : I18nUtils.getString("minimap.waypoints.sortbycolor");
    }

    protected void a(ban par1GuiButton) {
        if (par1GuiButton.l) {
            String var2;
            if (par1GuiButton.k > 0) {
                this.options.setSort(par1GuiButton.k);
                this.changedSort = true;
                this.sort();
            }
            if (par1GuiButton.k == -1) {
                this.editWaypoint(this.selectedWaypoint);
            }
            if (par1GuiButton.k == -2 && (var2 = this.selectedWaypoint.name) != null) {
                this.deleteClicked = true;
                String var4 = I18nUtils.getString("minimap.waypoints.deleteconfirm");
                String var5 = "'" + var2 + "' " + I18nUtils.getString("selectServer.deleteWarning");
                String var6 = I18nUtils.getString("selectServer.deleteButton");
                String var7 = I18nUtils.getString("gui.cancel");
                bbd var8 = new bbd((bcd)this, var4, var5, var6, var7, this.waypointManager.getWaypoints().indexOf(this.selectedWaypoint));
                this.getMinecraft().a((bcd)var8);
            }
            if (par1GuiButton.k == -3) {
                if (this.options.game.E()) {
                    this.options.game.h.a("/ztp " + this.selectedWaypoint.name);
                    this.getMinecraft().a((bcd)null);
                } else {
                    if (this.selectedWaypoint.getY() > 0) {
                        this.options.game.h.a("/tp " + this.options.game.h.b_() + " " + this.selectedWaypoint.getX() + " " + this.selectedWaypoint.getY() + " " + this.selectedWaypoint.getZ());
                        this.options.game.h.a("/tppos " + this.selectedWaypoint.getX() + " " + this.selectedWaypoint.getY() + " " + this.selectedWaypoint.getZ());
                    } else {
                        this.options.game.h.a("/tp " + this.options.game.h.b_() + " " + this.selectedWaypoint.getX() + " " + (this.options.game.h.aq != -1 ? "128" : "64") + " " + this.selectedWaypoint.getZ());
                        this.options.game.h.a("/tppos " + this.selectedWaypoint.getX() + " " + (this.options.game.h.aq != -1 ? "256" : "64") + " " + this.selectedWaypoint.getZ());
                    }
                    this.getMinecraft().a((bcd)null);
                }
            }
            if (par1GuiButton.k == -4) {
                this.addWaypoint();
            }
            if (par1GuiButton.k == -5) {
                this.getMinecraft().a((bcd)new GuiWaypointsOptions(this, this.options));
            }
            if (par1GuiButton.k == -200) {
                this.getMinecraft().a(this.parentScreen);
            }
        }
    }

    public void a(boolean par1, int par2) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
            this.getMinecraft().a((bcd)this);
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (par1) {
                this.waypointManager.saveWaypoints();
            }
            this.getMinecraft().a((bcd)this);
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (par1) {
                this.waypointManager.addWaypoint(this.newWaypoint);
                this.setSelectedWaypoint(this.newWaypoint);
            }
            this.getMinecraft().a((bcd)this);
        }
    }

    protected void setSelectedWaypoint(Waypoint waypoint) {
        boolean isSomethingSelected;
        this.selectedWaypoint = waypoint;
        this.buttonEdit.l = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.l = isSomethingSelected;
        this.buttonTeleport.l = isSomethingSelected && this.canTeleport();
    }

    protected void editWaypoint(Waypoint waypoint) {
        this.editClicked = true;
        this.getMinecraft().a((bcd)new GuiScreenAddWaypoint(this.master, this, waypoint));
    }

    protected void addWaypoint() {
        float b;
        float g;
        float r;
        this.addClicked = true;
        if (this.waypointManager.getWaypoints().size() == 0) {
            r = 0.0f;
            g = 1.0f;
            b = 0.0f;
        } else {
            r = this.generator.nextFloat();
            g = this.generator.nextFloat();
            b = this.generator.nextFloat();
        }
        TreeSet<Integer> dimensions = new TreeSet<Integer>();
        dimensions.add(this.options.game.h.aq);
        this.newWaypoint = new Waypoint("", this.options.game.h.aq != -1 ? GameVariableAccessShim.xCoord() : GameVariableAccessShim.xCoord() * 8, this.options.game.h.aq != -1 ? GameVariableAccessShim.zCoord() : GameVariableAccessShim.zCoord() * 8, GameVariableAccessShim.yCoord() - 1, true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(), dimensions);
        this.getMinecraft().a((bcd)new GuiScreenAddWaypoint(this.master, this, this.newWaypoint));
    }

    protected void toggleWaypointVisibility() {
        this.selectedWaypoint.enabled = !this.selectedWaypoint.enabled;
        this.waypointManager.saveWaypoints();
    }

    public void a(int par1, int par2, float par3) {
        super.drawMap();
        this.tooltip = null;
        this.waypointList.a(par1, par2, par3);
        this.a(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.a(par1, par2, par3);
        if (this.tooltip != null) {
            this.drawTooltip(this.tooltip, par1, par2);
        }
    }

    protected void drawTooltip(String par1Str, int par2, int par3) {
        if (par1Str != null) {
            int var4 = par2 + 12;
            int var5 = par3 - 12;
            int var6 = this.getFontRenderer().a(par1Str);
            this.a(var4 - 3, var5 - 3, var4 + var6 + 3, var5 + 8 + 3, -1073741824, -1073741824);
            this.getFontRenderer().a(par1Str, var4, var5, -1);
        }
    }

    static String setTooltip(GuiWaypoints par0GuiWaypoints, String par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }

    public boolean canTeleport() {
        boolean notInNether = this.options.game.h.aq != -1;
        boolean singlePlayer = this.options.game.E();
        if (singlePlayer) {
            return MinecraftServer.G().af().d(this.options.game.h.b_());
        }
        return notInNether;
    }

    static ban getButtonEdit(GuiWaypoints par0GuiWaypoints) {
        return par0GuiWaypoints.buttonEdit;
    }

    static ban getButtonDelete(GuiWaypoints par0GuiWaypoints) {
        return par0GuiWaypoints.buttonDelete;
    }

    static ban getButtonTeleport(GuiWaypoints par0GuiWaypoints) {
        return par0GuiWaypoints.buttonTeleport;
    }

    @Override
    public void b() {
        if (this.changedSort) {
            super.b();
        }
    }
}

