/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import com.thevoxelbox.voxelmap.MapSettingsManager;
import com.thevoxelbox.voxelmap.VoxelMap;
import com.thevoxelbox.voxelmap.util.GLUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.opengl.GL11;

public class GLBufferedImage
extends BufferedImage {
    private ByteBuffer buffer;
    public byte[] bytes;
    public int index = 0;
    private Object bufferLock = new Object();

    public GLBufferedImage(int width, int height, int imageType) {
        super(width, height, imageType);
        this.bytes = ((DataBufferByte)this.getRaster().getDataBuffer()).getData();
        this.buffer = ByteBuffer.allocateDirect(this.bytes.length).order(ByteOrder.nativeOrder());
    }

    public void baleet() {
        if (this.index != 0) {
            GL11.glDeleteTextures((int)this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        if (this.index != 0) {
            GL11.glDeleteTextures((int)this.index);
        } else {
            this.index = GL11.glGenTextures();
        }
        this.buffer.clear();
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.put(this.bytes);
        }
        this.buffer.position(0).limit(this.bytes.length);
        if (!GLUtils.hasAlphaBits && !GLUtils.fboEnabled) {
            if (MapSettingsManager.instance.squareMap) {
                for (int t = 0; t < this.getWidth(); ++t) {
                    this.buffer.put(t * 4 + 3, (byte)0);
                    this.buffer.put(t * this.getWidth() * 4 + 3, (byte)0);
                }
            }
            if (MapSettingsManager.instance.squareMap && (MapSettingsManager.instance.zoom > 0 || VoxelMap.instance.getMap().getPercentX() > 1.0f)) {
                for (int t = 0; t < this.getWidth(); ++t) {
                    this.buffer.put(t * this.getWidth() * 4 + 7, (byte)0);
                }
            }
            if (MapSettingsManager.instance.squareMap && (MapSettingsManager.instance.zoom > 0 || VoxelMap.instance.getMap().getPercentY() > 1.0f)) {
                for (int t = 0; t < this.getWidth(); ++t) {
                    this.buffer.put(t * 4 + 3 + this.getWidth() * 4, (byte)0);
                }
            }
        }
        GL11.glBindTexture((int)3553, (int)this.index);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)32993, (int)5121, (ByteBuffer)this.buffer);
    }

    public void blank() {
        for (int t = 0; t < this.bytes.length; ++t) {
            this.bytes[t] = 0;
        }
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRGB(int x, int y2, int color24) {
        int index = (x + y2 * this.getWidth()) * 4;
        Object object = this.bufferLock;
        synchronized (object) {
            int alpha = color24 >> 24 & 0xFF;
            this.bytes[index] = (byte)((color24 >> 0 & 0xFF) * alpha / 255);
            this.bytes[index + 1] = (byte)((color24 >> 8 & 0xFF) * alpha / 255);
            this.bytes[index + 2] = (byte)((color24 >> 16 & 0xFF) * alpha / 255);
            this.bytes[index + 3] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveX(int offset) {
        Object object = this.bufferLock;
        synchronized (object) {
            if (offset > 0) {
                System.arraycopy(this.bytes, offset * 4, this.bytes, 0, this.bytes.length - offset * 4);
            } else if (offset < 0) {
                System.arraycopy(this.bytes, 0, this.bytes, -offset * 4, this.bytes.length + offset * 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveY(int offset) {
        Object object = this.bufferLock;
        synchronized (object) {
            if (offset > 0) {
                System.arraycopy(this.bytes, offset * this.getWidth() * 4, this.bytes, 0, this.bytes.length - offset * this.getWidth() * 4);
            } else if (offset < 0) {
                System.arraycopy(this.bytes, 0, this.bytes, -offset * this.getWidth() * 4, this.bytes.length + offset * this.getWidth() * 4);
            }
        }
    }
}

