/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.entity.GarageDoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GarageDoor
extends Block
implements ITileEntityProvider {
    private IIcon topBlockIcon;

    public GarageDoor() {
        super(Material.field_151575_d);
        this.func_149663_c("garage_door");
        this.func_149647_a(MalisisDoors.tab);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149766_f);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("malisisdoors:" + this.func_149739_a().substring(5));
        this.topBlockIcon = iconRegister.func_94245_a("malisisdoors:" + this.func_149739_a().substring(5) + "_top");
    }

    public IIcon func_149691_a(int side, int metadata) {
        if ((metadata & 8) != 0 && (side == 4 || side == 5)) {
            return this.topBlockIcon;
        }
        return this.field_149761_L;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int metadata = MathHelper.func_76128_c((double)(player.field_70177_z * 4.0f / 360.0f - 0.5f)) & 3;
        Block block = world.func_147439_a(x, y + 1, z);
        if (block instanceof GarageDoor) {
            metadata = world.func_72805_g(x, y + 1, z) & 3;
        } else {
            block = world.func_147439_a(x, y - 1, z);
            if (block instanceof GarageDoor) {
                metadata = world.func_72805_g(x, y - 1, z) & 3;
            }
        }
        world.func_72921_c(x, y, z, metadata, 2);
        this.func_149719_a((IBlockAccess)world, x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        ((GarageDoorTileEntity)te).add();
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity te;
        if ((world.func_72864_z(x, y, z) || block.func_149744_f()) && block != this && (te = world.func_147438_o(x, y, z)) != null) {
            ((GarageDoorTileEntity)te).changeState();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof GarageDoorTileEntity)) {
            return;
        }
        ((GarageDoorTileEntity)te).remove();
        world.func_147475_p(x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float w = 0.09375f;
        if ((metadata & 4) != 0) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (GarageDoor.isEastOrWest(metadata)) {
            this.func_149676_a(0.5f - w, 0.0f, 0.0f, 0.5f + w, 1.0f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.5f - w, 1.0f, 1.0f, 0.5f + w);
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 src, Vec3 dest) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149731_a(world, x, y, z, src, dest);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if ((metadata & 4) != 0) {
            return null;
        }
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new GarageDoorTileEntity();
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public static boolean isEastOrWest(int metadata) {
        return (metadata & 3) == 2 || (metadata & 3) == 0;
    }
}

