/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.malisis.doors.door.CustomDoorItem;
import net.malisis.doors.door.Door;
import net.malisis.doors.door.tileentity.CustomDoorTileEntity;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CustomDoor
extends Door {
    public CustomDoor() {
        this.func_149711_c(3.0f);
        this.func_149672_a(field_149766_f);
    }

    @Override
    public void func_149651_a(IIconRegister register) {
    }

    @Override
    public IIcon func_149691_a(int side, int metadata) {
        return null;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (!(te instanceof CustomDoorTileEntity)) {
            return;
        }
        ((CustomDoorTileEntity)te).onBlockPlaced(itemStack);
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        if ((metadata & 8) != 0) {
            return null;
        }
        return new CustomDoorTileEntity();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (!(te instanceof CustomDoorTileEntity)) {
            return null;
        }
        return CustomDoorItem.fromTileEntity((CustomDoorTileEntity)te);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75098_d) {
            DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
            if (!(te instanceof CustomDoorTileEntity)) {
                return true;
            }
            if (!te.isTopBlock(x, y, z)) {
                this.func_149642_a(world, x, y, z, CustomDoorItem.fromTileEntity((CustomDoorTileEntity)te));
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    @Override
    protected ItemStack getDoorItemStack(IBlockAccess world, int x, int y, int z) {
        DoorTileEntity te = Door.getDoor(world, x, y, z);
        if (!(te instanceof CustomDoorTileEntity)) {
            return null;
        }
        return CustomDoorItem.fromTileEntity((CustomDoorTileEntity)te);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        CustomDoorTileEntity te = (CustomDoorTileEntity)Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null) {
            return true;
        }
        Block[] blocks = new Block[]{te.getFrame(), te.getTopMaterial(), te.getBottomMaterial()};
        int[] metadata = new int[]{te.getFrameMetadata(), te.getTopMaterialMetadata(), te.getBottomMaterialMetadata()};
        ForgeDirection side = ForgeDirection.getOrientation((int)target.field_72310_e);
        double fxX = (double)x + world.field_73012_v.nextDouble();
        double fxY = (double)y + world.field_73012_v.nextDouble();
        double fxZ = (double)z + world.field_73012_v.nextDouble();
        switch (side) {
            case DOWN: {
                fxY = (double)y + this.func_149665_z() - (double)0.1f;
                break;
            }
            case UP: {
                fxY = (double)y + this.func_149669_A() + (double)0.1f;
                break;
            }
            case NORTH: {
                fxZ = (double)z + this.func_149706_B() - (double)0.1f;
                break;
            }
            case SOUTH: {
                fxZ = (double)z + this.func_149669_A() + (double)0.1f;
                break;
            }
            case EAST: {
                fxX = (double)x + this.func_149753_y() + (double)0.1f;
                break;
            }
            case WEST: {
                fxX = (double)x + this.func_149704_x() + (double)0.1f;
                break;
            }
        }
        int i = world.field_73012_v.nextInt(blocks.length);
        EntityDiggingFX fx = new EntityDiggingFX(world, fxX, fxY, fxZ, 0.0, 0.0, 0.0, blocks[i], metadata[i]);
        fx.func_70543_e(0.2f).func_70541_f(0.6f);
        effectRenderer.func_78873_a((EntityFX)fx);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        int nb = 4;
        CustomDoorTileEntity te = (CustomDoorTileEntity)Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null) {
            return true;
        }
        Block[] blocks = new Block[]{te.getFrame(), te.getTopMaterial(), te.getBottomMaterial()};
        int[] metadata = new int[]{te.getFrameMetadata(), te.getTopMaterialMetadata(), te.getBottomMaterialMetadata()};
        for (int i = 0; i < nb; ++i) {
            for (int j = 0; j < nb; ++j) {
                for (int k = 0; k < nb; ++k) {
                    double fxX = (double)x + ((double)i + 0.5) / (double)nb;
                    double fxY = (double)y + ((double)j + 0.5) / (double)nb;
                    double fxZ = (double)z + ((double)k + 0.5) / (double)nb;
                    int l = (i + j + k) % 2;
                    EntityDiggingFX fx = new EntityDiggingFX(world, fxX, fxY, fxZ, fxX - (double)x - 0.5, fxY - (double)y - 0.5, fxZ - (double)z - 0.5, blocks[l], metadata[l]);
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }
}

