/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.gui;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UIInventory;
import net.malisis.core.client.gui.component.container.UIPlayerInventory;
import net.malisis.core.client.gui.component.container.UIWindow;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UICheckBox;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.entity.VanishingDiamondTileEntity;
import net.malisis.doors.network.VanishingDiamondFrameMessage;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class VanishingDiamondGui
extends MalisisGui {
    protected VanishingDiamondTileEntity tileEntity;
    protected UITextField duration;
    protected HashMap<ForgeDirection, UIComponent[]> configs = new HashMap();

    public VanishingDiamondGui(VanishingDiamondTileEntity te, MalisisInventoryContainer container) {
        this.setInventoryContainer(container);
        this.tileEntity = te;
        UIWindow window = new UIWindow("tile.vanishing_block_diamond.name", 200, 220);
        window.add(new UILabel("Direction").setPosition(0, 20));
        window.add(new UILabel("Delay").setPosition(55, 20));
        window.add(new UILabel("Inversed").setPosition(90, 20));
        int i = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            VanishingDiamondTileEntity.DirectionState state = te.getDirectionState(dir);
            int y = i * 14 + 30;
            UICheckBox cb = new UICheckBox(dir.name());
            ((UICheckBox)cb.setPosition(2, y)).setChecked(state.shouldPropagate).register((Object)this);
            UIContainer cbCont = new UIContainer(70, 12);
            cbCont.setPosition(55, y);
            UITextField textField = (UITextField)((UITextField)((UITextField)new UITextField(27, "" + state.delay).setPosition(0, 0)).setDisabled(!state.shouldPropagate)).setFilter("\\d+").register((Object)this);
            UICheckBox invCb = (UICheckBox)((UICheckBox)((UICheckBox)new UICheckBox().setPosition(50, 0)).setDisabled(!state.shouldPropagate)).setChecked(state.inversed).register((Object)this);
            cbCont.add((UIComponent)textField);
            cbCont.add((UIComponent)invCb);
            window.add((UIComponent)cb);
            window.add((UIComponent)cbCont);
            this.configs.put(dir, new UIComponent[]{cb, textField, invCb});
            ++i;
        }
        UIContainer cont = (UIContainer)new UIContainer(50, 60).setPosition(0, 40, Anchor.RIGHT);
        this.duration = (UITextField)((UITextField)new UITextField(30).setPosition(0, 10, Anchor.CENTER)).setFilter("\\d+").register((Object)this);
        cont.add(new UILabel("Duration").setPosition(0, 0, Anchor.CENTER));
        cont.add((UIComponent)this.duration);
        UIInventory inv = new UIInventory(container.getContainerInventory());
        inv.setPosition(0, 40, Anchor.CENTER);
        cont.add(new UILabel("Block").setPosition(0, 30, Anchor.CENTER));
        cont.add((UIComponent)inv);
        window.add((UIComponent)cont);
        UIPlayerInventory playerInv = new UIPlayerInventory(container.getPlayerInventory());
        window.add((UIComponent)playerInv);
        this.addToScreen((UIContainer)window);
        TileEntityUtils.linkTileEntityToGui((TileEntity)this.tileEntity, (MalisisGui)this);
    }

    @Subscribe
    public void onChecked(ComponentEvent.ValueChanged<UICheckBox, Boolean> event) {
        for (Map.Entry<ForgeDirection, UIComponent[]> entry : this.configs.entrySet()) {
            if (entry.getValue()[0] != event.getComponent()) continue;
            entry.getValue()[1].setDisabled((Boolean)event.getNewValue() == false);
            entry.getValue()[2].setDisabled((Boolean)event.getNewValue() == false);
        }
        this.updateConfig();
    }

    @Subscribe
    public void onTextChanged(ComponentEvent.ValueChanged<UITextField, String> event) {
        this.updateConfig();
    }

    public void updateConfig() {
        VanishingDiamondFrameMessage.sendConfiguration(this.tileEntity, Integer.parseInt(this.duration.getText()), this.configs);
    }

    public void updateGui() {
        if (!this.duration.isFocused()) {
            this.duration.setText("" + this.tileEntity.getDuration());
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            VanishingDiamondTileEntity.DirectionState state = this.tileEntity.getDirectionState(dir);
            ((UICheckBox)this.configs.get(dir)[0]).setChecked(state.shouldPropagate);
            UITextField tf = (UITextField)this.configs.get(dir)[1];
            tf.setDisabled(!state.shouldPropagate);
            if (!tf.isFocused()) {
                tf.setText("" + state.delay);
            }
            ((UICheckBox)((UICheckBox)this.configs.get(dir)[2]).setDisabled(!state.shouldPropagate)).setChecked(state.inversed);
        }
    }
}

