/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.interaction.UICheckBox;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.doors.entity.VanishingDiamondTileEntity;
import net.malisis.doors.network.NetworkHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class VanishingDiamondFrameMessage
implements IMessageHandler<Packet, IMessage> {
    public IMessage onMessage(Packet message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        TileEntity te = world.func_147438_o(message.x, message.y, message.z);
        if (te == null || !(te instanceof VanishingDiamondTileEntity)) {
            return null;
        }
        ((VanishingDiamondTileEntity)te).setDuration(message.duration);
        for (int i = 0; i < 6; ++i) {
            ((VanishingDiamondTileEntity)te).getDirectionState(ForgeDirection.getOrientation((int)i)).update(message.shouldPropagate[i], message.delays[i], message.inverses[i]);
        }
        world.func_147471_g(message.x, message.y, message.z);
        return null;
    }

    public static void sendConfiguration(VanishingDiamondTileEntity te, int duration, HashMap<ForgeDirection, UIComponent[]> config) {
        Packet packet = new Packet(te.field_145851_c, te.field_145848_d, te.field_145849_e, duration);
        for (Map.Entry<ForgeDirection, UIComponent[]> entry : config.entrySet()) {
            boolean shouldPropagate = ((UICheckBox)entry.getValue()[0]).isChecked();
            int delay = Integer.valueOf(((UITextField)entry.getValue()[1]).getText());
            boolean inversed = ((UICheckBox)entry.getValue()[2]).isChecked();
            packet.setConfig(entry.getKey().ordinal(), shouldPropagate, delay, inversed);
        }
        NetworkHandler.network.sendToServer((IMessage)packet);
    }

    public static class Packet
    implements IMessage {
        protected int x;
        protected int y;
        protected int z;
        protected int duration;
        protected boolean[] shouldPropagate = new boolean[6];
        protected int[] delays = new int[6];
        protected boolean[] inverses = new boolean[6];

        public Packet() {
        }

        public Packet(int x, int y, int z, int duration) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.duration = duration;
        }

        public void setConfig(int dir, boolean shouldPropagate, int delay, boolean inversed) {
            this.shouldPropagate[dir] = shouldPropagate;
            this.delays[dir] = delay;
            this.inverses[dir] = inversed;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            this.duration = buf.readInt();
            for (int i = 0; i < 6; ++i) {
                this.shouldPropagate[i] = buf.readBoolean();
                this.delays[i] = buf.readInt();
                this.inverses[i] = buf.readBoolean();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
            buf.writeInt(this.duration);
            for (int i = 0; i < 6; ++i) {
                buf.writeBoolean(this.shouldPropagate[i]);
                buf.writeInt(this.delays[i]);
                buf.writeBoolean(this.inverses[i]);
            }
        }
    }
}

