/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import net.malisis.core.client.gui.component.container.UIContainer;

public class ClipArea {
    public boolean noClip = false;
    public int x;
    public int y;
    public int X;
    public int Y;
    public int clipPadding;

    public ClipArea(UIContainer container) {
        this(container, 0, true);
    }

    public ClipArea(UIContainer container, int clipPadding) {
        this(container, clipPadding, true);
    }

    public ClipArea(UIContainer container, int clipPadding, boolean intersect) {
        if (!container.clipContent) {
            this.noClip = true;
        } else {
            this.x = container.screenX() + clipPadding;
            this.y = container.screenY() + clipPadding;
            this.X = this.x + container.getWidth() - clipPadding * 2;
            this.Y = this.y + container.getHeight() - clipPadding * 2;
            this.clipPadding = clipPadding;
        }
        if (intersect && container.getParent() != null) {
            this.intersect(container.getParent().getClipArea());
        }
    }

    public void intersect(ClipArea area) {
        if (this.noClip) {
            this.x = area.x;
            this.y = area.y;
            this.X = area.X;
            this.Y = area.Y;
            this.clipPadding = area.clipPadding;
        } else if (!area.noClip) {
            this.x = Math.max(this.x, area.x);
            this.y = Math.max(this.y, area.y);
            this.X = Math.min(this.X, area.X);
            this.Y = Math.min(this.Y, area.Y);
        }
    }

    public int width() {
        return this.X - this.x;
    }

    public int height() {
        return this.Y - this.y;
    }

    public String toString() {
        return this.x + "->" + this.X + " , " + this.y + "->" + this.Y + " (" + this.width() + "," + this.height() + ")";
    }
}

