/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UITooltip;
import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiRenderer
extends BaseRenderer {
    private final ResourceLocation GUI_TEXTURE = new ResourceLocation("malisiscore", "textures/gui/gui.png");
    public static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public static RenderItem itemRenderer = new RenderItem();
    public static int FONT_HEIGHT = GuiRenderer.fontRenderer.field_78288_b;
    public UIComponent currentComponent;
    private int displayWidth;
    private int displayHeight;
    private int scaleFactor;
    public int mouseX;
    public int mouseY;
    private boolean defaultTexture = true;

    public GuiRenderer() {
        this.updateGuiScale();
    }

    public void updateGuiScale() {
        Minecraft mc = Minecraft.func_71410_x();
        this.displayWidth = mc.field_71443_c;
        this.displayHeight = mc.field_71440_d;
        this.calcScaleFactor(mc.field_71474_y.field_74335_Z);
    }

    public void set(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTick = partialTicks;
    }

    public void drawScreen(UIContainer container, int mouseX, int mouseY, float partialTick) {
        this.set(mouseX, mouseY, partialTick);
        if (container != null) {
            this.setDefaultTexture();
            this.startDrawing();
            container.draw(this, mouseX, mouseY, partialTick);
            this.draw();
        }
    }

    public void drawTooltip(UITooltip tooltip) {
        if (tooltip != null) {
            this.t.func_78382_b();
            tooltip.draw(this, this.mouseX, this.mouseY, this.partialTick);
            this.t.func_78381_a();
        }
    }

    @Override
    public void drawShape(Shape s, RenderParameters rp) {
        this.drawShape(s, rp, new IIcon[]{null});
    }

    public void drawShape(Shape s, IIcon ... icons) {
        this.drawShape(s, (RenderParameters)null, icons);
    }

    public void drawShape(Shape s, RenderParameters rp, IIcon ... icons) {
        if (s == null) {
            return;
        }
        this.shape = s;
        this.shape.translate(this.currentComponent.screenX(), this.currentComponent.screenY(), this.currentComponent.getZIndex());
        this.shapeParams = rp != null ? rp : new RenderParameters();
        s.applyMatrix();
        if (this.shapeParams.applyTexture.get().booleanValue()) {
            this.applyTexture(s, this.shapeParams);
        }
        Face[] faces = s.getFaces();
        for (int i = 0; i < faces.length; ++i) {
            if (icons != null && i < icons.length && icons[i] != null) {
                faces[i].setTexture(icons[i], false, false, false);
            }
            this.drawFace(faces[i], rp);
        }
    }

    public String clipString(String text, int width) {
        text = StatCollector.func_74838_a((String)text);
        StringBuilder ret = new StringBuilder();
        int strWidth = 0;
        for (int index = 0; index < text.length(); ++index) {
            char c = text.charAt(index);
            if ((strWidth += GuiRenderer.getCharWidth(c)) >= width) {
                return ret.toString();
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        int lineWidth = 0;
        int wordWidth = 0;
        for (int index = 0; index < text.length(); ++index) {
            char c = text.charAt(index);
            int w = GuiRenderer.getCharWidth(c);
            lineWidth += w;
            wordWidth += w;
            word.append(c);
            if (c == ' ' || c == '-' || c == '.') {
                line.append((CharSequence)word);
                word.setLength(0);
                wordWidth = 0;
            }
            if (lineWidth < maxWidth) continue;
            if (line.length() == 0) {
                line.append((CharSequence)word);
                word.setLength(0);
                wordWidth = 0;
            }
            lines.add(line.toString());
            line.setLength(0);
            lineWidth = wordWidth;
        }
        line.append((CharSequence)word);
        lines.add(line.toString());
        return lines;
    }

    public void drawText(String text) {
        this.drawText(text, 0, 0, 0, 0xFFFFFF, false);
    }

    public void drawText(String text, int color, boolean shadow) {
        this.drawText(text, 0, 0, 0, color, shadow);
    }

    public void drawText(String text, int x, int y, int color, boolean shadow) {
        this.drawText(text, x, y, 0, color, shadow);
    }

    public void drawText(String text, int x, int y, int zIndex, int color, boolean shadow) {
        this.drawString(text, this.currentComponent.screenX() + x, this.currentComponent.screenY() + y, this.currentComponent.getZIndex() + zIndex, color, shadow);
    }

    public void drawString(String text, int x, int y, int z, int color, boolean shadow) {
        if (fontRenderer == null) {
            return;
        }
        text = StatCollector.func_74838_a((String)text);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)z);
        GL11.glDisable((int)32826);
        fontRenderer.func_85187_a(text, x, y, color, shadow);
        GL11.glPopMatrix();
        GL11.glEnable((int)32826);
        this.setDefaultTexture();
    }

    public void drawItemStack(ItemStack itemStack, int x, int y) {
        this.drawItemStack(itemStack, x, y, null);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, EnumChatFormatting format) {
        if (itemStack == null) {
            return;
        }
        FontRenderer fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = GuiRenderer.fontRenderer;
        }
        String s = null;
        if (format != null) {
            s = format + Integer.toString(itemStack.field_77994_a);
        }
        this.t.func_78381_a();
        RenderHelper.func_74520_c();
        itemRenderer.func_82406_b(fontRenderer, Minecraft.func_71410_x().func_110434_K(), itemStack, x, y);
        itemRenderer.func_94148_a(fontRenderer, Minecraft.func_71410_x().func_110434_K(), itemStack, x, y, s);
        RenderHelper.func_74518_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.setDefaultTexture();
        this.t.func_78382_b();
    }

    public void startClipping(ClipArea area) {
        if (area.noClip || area.width() <= 0 || area.height() <= 0) {
            return;
        }
        GL11.glPushAttrib((int)524288);
        GL11.glEnable((int)3089);
        int x = area.x * this.scaleFactor;
        int y = this.displayHeight - (area.y + area.height()) * this.scaleFactor;
        int w = area.width() * this.scaleFactor;
        int h = area.height() * this.scaleFactor;
        GL11.glScissor((int)x, (int)y, (int)w, (int)h);
    }

    public void endClipping(ClipArea area) {
        if (area.noClip || area.width() <= 0 || area.height() <= 0) {
            return;
        }
        GL11.glDisable((int)3089);
        GL11.glPopAttrib();
    }

    private void calcScaleFactor(int guiScale) {
        this.scaleFactor = 1;
        if (guiScale == 0) {
            guiScale = 1000;
        }
        while (this.scaleFactor < guiScale && this.displayWidth / (this.scaleFactor + 1) >= 320 && this.displayHeight / (this.scaleFactor + 1) >= 240) {
            ++this.scaleFactor;
        }
    }

    public void renderPickedItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        GuiRenderer.itemRenderer.field_77023_b = 100.0f;
        this.t.func_78382_b();
        this.drawItemStack(itemStack, this.mouseX - 8, this.mouseY - 8, (EnumChatFormatting)(itemStack.field_77994_a == 0 ? EnumChatFormatting.YELLOW : null));
        this.t.func_78381_a();
        GuiRenderer.itemRenderer.field_77023_b = 0.0f;
    }

    public static int getStringWidth(String str) {
        str = StatCollector.func_74838_a((String)str);
        return fontRenderer.func_78256_a(str);
    }

    public static int getMaxStringWidth(List<String> strings) {
        int width = 0;
        for (String str : strings) {
            width = Math.max(width, GuiRenderer.getStringWidth(str));
        }
        return width;
    }

    public static int getMaxStringWidth(String[] strings) {
        return GuiRenderer.getMaxStringWidth(Arrays.asList(strings));
    }

    public static int getCharWidth(char c) {
        return fontRenderer.func_78263_a(c);
    }

    public void func_147499_a(ResourceLocation rl) {
        if (rl == null) {
            return;
        }
        this.defaultTexture = false;
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(rl);
    }

    public void setDefaultTexture() {
        this.func_147499_a(this.GUI_TEXTURE);
        this.defaultTexture = true;
    }

    @Override
    public void next() {
        super.next();
        if (!this.defaultTexture) {
            this.setDefaultTexture();
        }
    }
}

