/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import com.google.common.eventbus.Subscribe;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.interaction.IScrollable;
import net.malisis.core.client.gui.component.interaction.UIScrollBar;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.IIcon;

public class UIPanel
extends UIContainer<UIPanel>
implements IScrollable {
    public static GuiIcon[] icons = new GuiIcon[]{new GuiIcon(200, 15, 5, 5), new GuiIcon(205, 15, 5, 5), new GuiIcon(210, 15, 5, 5), new GuiIcon(200, 20, 5, 5), new GuiIcon(205, 20, 5, 5), new GuiIcon(210, 20, 5, 5), new GuiIcon(200, 25, 5, 5), new GuiIcon(205, 25, 5, 5), new GuiIcon(210, 25, 5, 5)};
    protected boolean allowVerticalScroll = false;
    protected boolean allowHorizontalScroll = false;
    protected UIScrollBar horizontalScroll;
    protected UIScrollBar verticalScroll;
    protected int contentWidth;
    protected int contentHeight;
    protected int xOffset;
    protected int yOffset;
    protected int color = -1;

    public UIPanel(int width, int height) {
        super(width, height);
        this.setPadding(3, 3);
        this.horizontalScroll = new UIScrollBar(this, width, 1);
        this.verticalScroll = new UIScrollBar(this, height, 0);
        this.setScrollBarsPosition();
        this.calculateContentSize();
    }

    @Override
    public boolean fireMouseEvent(MouseEvent event) {
        if (this.allowVerticalScroll && (this.verticalScroll.isInsideBounds(event.getX(), event.getY()) || this.verticalScroll.isFocused() && event instanceof MouseEvent.Drag)) {
            return this.verticalScroll.fireMouseEvent(event);
        }
        if (this.allowHorizontalScroll && (this.horizontalScroll.isInsideBounds(event.getX(), event.getY()) || this.horizontalScroll.isFocused() && event instanceof MouseEvent.Drag)) {
            return this.horizontalScroll.fireMouseEvent(event);
        }
        if (this.isInsideBounds(event.getX(), event.getY())) {
            return super.fireMouseEvent(event);
        }
        return false;
    }

    public boolean isInsideBounds(int x, int y, boolean scrolls) {
        if (scrolls && this.allowVerticalScroll && this.verticalScroll.isInsideBounds(x, y)) {
            return true;
        }
        if (scrolls && this.allowHorizontalScroll && this.horizontalScroll.isInsideBounds(x, y)) {
            return true;
        }
        return super.isInsideBounds(x, y);
    }

    public UIPanel setHorizontalScroll(boolean allow) {
        int shift = allow ? -10 : 10;
        this.verticalScroll.setLength(this.verticalScroll.getLength() + shift);
        this.allowHorizontalScroll = allow;
        return this;
    }

    public boolean getHorizontalScroll() {
        return this.allowHorizontalScroll;
    }

    public UIPanel setVerticalScroll(boolean allow) {
        int shift = allow ? -10 : 10;
        this.horizontalScroll.setLength(this.horizontalScroll.getLength() + shift);
        this.allowVerticalScroll = allow;
        return this;
    }

    public boolean getVerticalScroll() {
        return this.allowVerticalScroll;
    }

    public void setScrollBarsPosition() {
        this.verticalScroll.setPosition(this.horizontalPadding - this.xOffset, -this.verticalPadding - this.yOffset, Anchor.RIGHT);
        this.horizontalScroll.setPosition(-this.verticalPadding - this.xOffset, this.horizontalPadding - this.yOffset, Anchor.BOTTOM);
    }

    @Override
    public void setOffsetX(int offset) {
        this.xOffset = -offset;
        this.setScrollBarsPosition();
    }

    @Override
    public void setOffsetY(int offset) {
        this.yOffset = -offset;
        this.setScrollBarsPosition();
    }

    @Override
    public int getOffsetX() {
        return this.xOffset;
    }

    @Override
    public int getOffsetY() {
        return this.yOffset;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public void add(UIComponent component) {
        super.add(component);
        this.calculateContentSize();
    }

    @Override
    public void onContentUpdate() {
        this.calculateContentSize();
    }

    public void calculateContentSize() {
        int w = this.width - (this.allowVerticalScroll ? 11 : 0);
        int h = this.height - (this.allowHorizontalScroll ? 11 : 0);
        int contentWidth = w - this.horizontalPadding;
        int contentHeight = h - this.verticalPadding;
        for (UIComponent c : this.components) {
            if (!c.isVisible()) continue;
            contentWidth = Math.max(contentWidth, c.containerX() + c.getWidth());
            contentHeight = Math.max(contentHeight, c.containerY() + c.getHeight());
        }
        this.contentHeight = contentHeight + this.verticalPadding;
        if (this.verticalScroll != null) {
            this.verticalScroll.setScrollableLength(this.contentHeight);
            if (this.contentHeight == h) {
                this.verticalScroll.scrollTo(0.0f);
            }
        }
        this.contentWidth = contentWidth + this.horizontalPadding;
        if (this.horizontalScroll != null) {
            this.horizontalScroll.setScrollableLength(this.contentWidth);
            if (this.contentWidth == w) {
                this.horizontalScroll.scrollTo(0.0f);
            }
        }
    }

    @Subscribe
    public void onScrollWheel(MouseEvent.ScrollWheel event) {
        UIScrollBar sb;
        UIScrollBar uIScrollBar = sb = GuiScreen.func_146272_n() ? this.horizontalScroll : this.verticalScroll;
        if (GuiScreen.func_146272_n() ? this.allowHorizontalScroll : this.allowVerticalScroll) {
            sb.scrollBy(event.getDelta() * (GuiScreen.func_146271_m() ? 15 : 5));
        }
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        super.drawForeground(renderer, mouseX, mouseY, partialTick);
        if (this.allowVerticalScroll) {
            this.verticalScroll.draw(renderer, mouseX, mouseY, partialTick);
        }
        if (this.allowHorizontalScroll) {
            this.horizontalScroll.draw(renderer, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = ShapePreset.GuiXYResizable(this.width, this.height);
        RenderParameters rp = new RenderParameters();
        if (this.color != -1) {
            rp.colorMultiplier.set(this.color);
        }
        renderer.drawShape(shape, rp, (IIcon[])icons);
    }

    @Override
    public ClipArea getClipArea() {
        ClipArea area = new ClipArea(this, 1);
        if (this.allowVerticalScroll) {
            area.X -= 9;
        }
        if (this.allowHorizontalScroll) {
            area.Y -= 9;
        }
        return area;
    }
}

