/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.KeyboardEvent;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.core.util.MouseButton;
import org.lwjgl.opengl.GL11;

public class UISelect
extends UIComponent<UISelect> {
    public static GuiIcon[] iconsSelect = new GuiIcon[]{new GuiIcon(200, 30, 3, 12), new GuiIcon(203, 30, 3, 12), new GuiIcon(206, 30, 3, 12)};
    public static GuiIcon[] iconsSelectDisabled = new GuiIcon[]{iconsSelect[0].offsetCopy(0, 12), iconsSelect[1].offsetCopy(0, 12), iconsSelect[2].offsetCopy(0, 12)};
    public GuiIcon[] iconsExpanded = new GuiIcon[]{new GuiIcon(200, 30, 3, 3), new GuiIcon(203, 30, 3, 3), new GuiIcon(206, 30, 3, 3), new GuiIcon(200, 33, 3, 3), new GuiIcon(203, 33, 3, 3), new GuiIcon(206, 33, 3, 3), new GuiIcon(200, 39, 3, 3), new GuiIcon(203, 39, 3, 3), new GuiIcon(206, 39, 3, 3)};
    public static GuiIcon arrowIcon = new GuiIcon(209, 48, 7, 4);
    protected OptionsContainer optionsContainer;
    protected int selectedOption = -1;
    protected int maxExpandedWidth = -1;
    protected int maxDisplayedOptions = -1;
    protected boolean expanded = false;
    protected String labelPattern;

    public UISelect(int width, HashMap<Integer, Option> options) {
        this.width = width;
        this.height = 12;
        this.optionsContainer = new OptionsContainer();
        this.setOptions(options);
    }

    public UISelect(int width) {
        this(width, null);
    }

    @Override
    public void setParent(UIContainer parent) {
        super.setParent(parent);
        this.optionsContainer.setParent(parent);
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused && this.expanded) {
            this.expanded = false;
        }
    }

    public UISelect setLabelPattern(String labelPattern) {
        this.labelPattern = labelPattern;
        for (Option option : this.optionsContainer.options.values()) {
            this.optionsContainer.optionsLabel.get(option.getIndex()).setText(String.format(labelPattern, option.label));
        }
        this.optionsContainer.calcExpandedSize();
        return this;
    }

    public UISelect maxExpandedWidth(int width) {
        this.maxExpandedWidth = width;
        this.optionsContainer.calcExpandedSize();
        return this;
    }

    public UISelect maxDisplayedOptions(int nb) {
        this.maxDisplayedOptions = nb;
        this.optionsContainer.calcExpandedSize();
        return this;
    }

    public UISelect setOptions(HashMap<Integer, Option> options) {
        this.optionsContainer.setOptions(options);
        return this;
    }

    public void setSelectedOption(int index) {
        this.selectedOption = index;
    }

    public void setSelectedOption(Object obj) {
        Option opt = this.getOption(obj);
        this.setSelectedOption(opt != null ? opt.index : -1);
    }

    public Option getOption(int index) {
        return this.optionsContainer.getOption(index);
    }

    public Option getOption(Object obj) {
        return this.optionsContainer.getOption(obj);
    }

    public Option getSelectedOption() {
        return this.optionsContainer.getOption(this.selectedOption);
    }

    public Option select(int index) {
        Option oldValue = this.getOption(this.selectedOption);
        Option newValue = this.getOption(index);
        int n = this.selectedOption = newValue != null ? newValue.index : -1;
        if (!this.fireEvent(new ComponentEvent.ValueChanged<UISelect, Option>(this, oldValue, newValue))) {
            this.selectedOption = oldValue.index;
            return oldValue;
        }
        return newValue;
    }

    public Option select(Object obj) {
        Option opt = this.getOption(obj);
        return this.select(opt != null ? opt.index : -1);
    }

    @Override
    public boolean isInsideBounds(int x, int y) {
        return super.isInsideBounds(x, y) || this.optionsContainer.isInsideBounds(x, y);
    }

    @Override
    public UIComponent getComponentAt(int x, int y) {
        if (super.isInsideBounds(x, y)) {
            return this;
        }
        if (this.optionsContainer.isInsideBounds(x, y)) {
            return this.optionsContainer.getComponentAt(x, y);
        }
        return null;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = ShapePreset.GuiXResizable(this.width, 12, 3);
        renderer.drawShape(shape, this.isDisabled() ? iconsSelectDisabled : iconsSelect);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        String text;
        Shape shape = ShapePreset.GuiElement(7, 4);
        shape.translate(this.width - 9, 4.0f, 0.0f);
        RenderParameters rp = new RenderParameters();
        if (this.isHovered() || this.expanded) {
            rp.colorMultiplier.set(12503295);
        }
        renderer.drawShape(shape, rp, arrowIcon);
        if (this.selectedOption != -1 && (text = this.getOption(this.selectedOption).getLabel(this.labelPattern)) != null && text.length() != 0) {
            renderer.drawText(renderer.clipString(text, this.width - 15), 2, 2, 0xFFFFFF, true);
        }
        renderer.next();
        ClipArea area = this.optionsContainer.getClipArea();
        renderer.startClipping(area);
        this.optionsContainer.draw(renderer, mouseX, mouseY, partialTick);
        renderer.endClipping(area);
    }

    @Subscribe
    public void onClick(MouseEvent.Release event) {
        if (event.getButton() != MouseButton.LEFT) {
            return;
        }
        if (super.isInsideBounds(event.getX(), event.getY())) {
            if (!this.expanded) {
                this.optionsContainer.setFocused(true);
            }
            this.expanded = !this.expanded;
        } else if (this.expanded) {
            int selected = (this.optionsContainer.componentY(event.getY()) - 1) / 10;
            this.select(selected);
            this.expanded = false;
            this.setFocused(true);
        }
    }

    @Subscribe
    public void onScrollWheel(MouseEvent.ScrollWheel event) {
        if (this.isFocused() && this.isHovered()) {
            int selected = this.selectedOption + event.getDelta() * -1;
            selected = Math.max(0, Math.min(this.optionsContainer.optionsLabel.size() - 1, selected));
            this.select(selected);
        }
    }

    @Subscribe
    public void onKeyTyped(KeyboardEvent event) {
        if (!this.isFocused()) {
            return;
        }
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 200: {
                this.select(this.selectedOption - 1);
                break;
            }
            case 208: {
                this.select(this.selectedOption + 1);
                break;
            }
            case 199: {
                this.select(0);
                break;
            }
            case 207: {
                this.select(this.optionsContainer.optionsLabel.size() - 1);
            }
        }
    }

    public static class Option<T> {
        private int index;
        private T key;
        private String label;

        public Option(int index, T key, String value) {
            this.index = index;
            this.key = key;
            this.label = value;
        }

        public int getIndex() {
            return this.index;
        }

        public T getKey() {
            return this.key;
        }

        public String getLabel(String pattern) {
            if (pattern == null) {
                return this.label;
            }
            return String.format(pattern, this.label);
        }

        public String getLabel() {
            return this.label;
        }

        public static <T> HashMap<Integer, Option> fromList(List<T> list) {
            HashMap<Integer, Option> options = new HashMap<Integer, Option>();
            int index = 0;
            for (T opt : list) {
                Option<T> option = new Option<T>(index, opt, opt.toString());
                options.put(index, option);
                ++index;
            }
            return options;
        }

        public static <T> HashMap<Integer, Option> fromList(HashMap<T, String> list) {
            HashMap<Integer, Option> options = new HashMap<Integer, Option>();
            int index = 0;
            for (Map.Entry<T, String> entry : list.entrySet()) {
                Option<T> option = new Option<T>(index, entry.getKey(), entry.getValue());
                options.put(index, option);
                ++index;
            }
            return options;
        }

        public static <T, E extends Enum> HashMap<Integer, Option> fromEnum(Class<E> enumClass) {
            HashMap<Integer, Option> options = new HashMap<Integer, Option>();
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                Option<Enum> option = new Option<Enum>(e.ordinal(), e, e.toString());
                options.put(e.ordinal(), option);
            }
            return options;
        }
    }

    private class OptionsContainer
    extends UIContainer {
        HashMap<Integer, Option> options;
        ArrayList<UILabel> optionsLabel = new ArrayList();

        public OptionsContainer() {
            this.zIndex = 101;
        }

        private void setOptions(HashMap<Integer, Option> options) {
            this.options = options;
            for (UILabel label : this.optionsLabel) {
                this.unregister(label);
            }
            this.optionsLabel.clear();
            int i = 0;
            for (Map.Entry<Integer, Option> entry : options.entrySet()) {
                UILabel label = (UILabel)((UILabel)((UILabel)new UILabel(entry.getValue().getLabel(UISelect.this.labelPattern)).setPosition(2, 1 + 10 * i++)).setZIndex(this.zIndex + 1)).setDrawShadow(true).register(UISelect.this);
                this.optionsLabel.add(label);
                this.add(label);
            }
            this.calcExpandedSize();
        }

        private void calcExpandedSize() {
            this.width = UISelect.this.width;
            this.height = 10 * (UISelect.this.maxDisplayedOptions == -1 ? this.optionsLabel.size() : UISelect.this.maxDisplayedOptions) + 1;
            for (UILabel label : this.optionsLabel) {
                label.setSize(0);
                this.width = Math.max(this.width, label.getWidth() + 4);
            }
            if (UISelect.this.maxExpandedWidth > 0) {
                this.width = Math.min(UISelect.this.maxExpandedWidth, this.width);
            }
            for (UILabel label : this.optionsLabel) {
                label.setSize(this.width - 2);
            }
        }

        private Option getOption(int index) {
            if (index < 0 || index >= this.options.size()) {
                return null;
            }
            return this.options.get(index);
        }

        public Option getOption(Object obj) {
            for (Map.Entry<Integer, Option> entry : this.options.entrySet()) {
                Option option = entry.getValue();
                if (option.getKey() != obj) continue;
                return option;
            }
            return null;
        }

        @Override
        public void setFocused(boolean focused) {
            if (focused) {
                UISelect.this.setFocused(focused);
            }
        }

        @Override
        public boolean isVisible() {
            return UISelect.this.expanded;
        }

        @Override
        public int screenX() {
            return UISelect.this.screenX();
        }

        @Override
        public int screenY() {
            return UISelect.this.screenY() + 12;
        }

        @Override
        public ClipArea getClipArea() {
            return new ClipArea(this, 0, false);
        }

        @Override
        public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
            Shape shape = ShapePreset.GuiXYResizable(this.width, this.height, 3, 3);
            renderer.drawShape(shape, UISelect.this.iconsExpanded);
            for (UILabel label : this.optionsLabel) {
                if (!label.isHovered()) continue;
                renderer.next();
                GL11.glDisable((int)3553);
                shape = ShapePreset.GuiXResizable(label.getWidth(), label.getHeight());
                shape.translate(this.componentX(label) - 1, this.componentY(label), 0.0f);
                RenderParameters rp = new RenderParameters();
                rp.colorMultiplier.set(6191263);
                rp.useTexture.set(false);
                renderer.drawShape(shape, rp);
                renderer.next();
                GL11.glEnable((int)3553);
            }
        }

        @Override
        public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
            int i = 0;
            for (UILabel label : this.optionsLabel) {
                int color = label.isHovered() ? (i == UISelect.this.selectedOption ? 14604447 : 0xFFFFFF) : (i == UISelect.this.selectedOption ? 10397919 : 0xFFFFFF);
                label.setColor(color);
                label.draw(renderer, mouseX, mouseY, partialTick);
                ++i;
            }
        }
    }
}

