/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.event;

import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.event.GuiEvent;

public abstract class ComponentEvent<T extends UIComponent>
extends GuiEvent {
    private T component;

    public ComponentEvent(T component) {
        this.component = component;
    }

    public T getComponent() {
        return this.component;
    }

    public static class ValueChanged<T extends UIComponent, S>
    extends ComponentEvent<T> {
        private S oldValue;
        private S newValue;

        public ValueChanged(T component, S oldValue, S newValue) {
            super(component);
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public S getOldValue() {
            return this.oldValue;
        }

        public S getNewValue() {
            return this.newValue;
        }
    }

    public static class FocusStateChanged<T extends UIComponent>
    extends StateChanged<T> {
        public FocusStateChanged(T component, boolean focused) {
            super(component, focused);
        }
    }

    public static class HoveredStateChanged<T extends UIComponent>
    extends StateChanged<T> {
        public HoveredStateChanged(T component, boolean hovered) {
            super(component, hovered);
        }
    }

    public static abstract class StateChanged<T extends UIComponent>
    extends ComponentEvent<T> {
        private boolean state;

        public StateChanged(T component, boolean state) {
            super(component);
            this.state = state;
        }

        public boolean getState() {
            return this.state;
        }
    }
}

