/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.IBaseRendering;
import net.malisis.core.renderer.MalisisIcon;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BaseRenderer
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final int TYPE_ISBRH_WORLD = 1;
    public static final int TYPE_ISBRH_INVENTORY = 2;
    public static final int TYPE_ITEM_INVENTORY = 3;
    public static final int TYPE_TESR_WORLD = 4;
    private static Map damagedBlocks;
    protected static IIcon[] damagedIcons;
    protected int renderId = -1;
    protected Tessellator t = Tessellator.field_78398_a;
    protected IBlockAccess world;
    protected RenderBlocks renderBlocks;
    protected Block block;
    protected int blockMetadata;
    protected int x;
    protected int y;
    protected int z;
    protected ItemStack itemStack;
    protected IItemRenderer.ItemRenderType itemRenderType;
    protected int renderType;
    protected int drawMode;
    protected boolean isShifted = false;
    protected Shape shape;
    protected Face face;
    protected RenderParameters shapeParams;
    protected RenderParameters params;
    protected int baseBrightness;
    protected IIcon overrideTexture;
    protected TileEntity tileEntity;
    protected float partialTick = 0.0f;
    protected boolean getBlockDamage = false;
    protected DestroyBlockProgress destroyBlockProgress = null;
    protected boolean vertexDrawn = false;

    public float getPartialTick() {
        return this.partialTick;
    }

    public void reset() {
        this.renderType = 0;
        this.drawMode = 0;
        this.world = null;
        this.block = null;
        this.blockMetadata = 0;
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.overrideTexture = null;
        this.destroyBlockProgress = null;
    }

    public void set(IBlockAccess world, Block block, int x, int y, int z, int metadata) {
        this.world = world;
        this.block = block;
        this.blockMetadata = metadata;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Block block) {
        this.set(this.world, block, this.x, this.y, this.z, this.blockMetadata);
    }

    public void set(int blockMetadata) {
        this.set(this.world, this.block, this.x, this.y, this.z, blockMetadata);
    }

    public void set(Block block, int blockMetadata) {
        this.set(this.world, block, this.x, this.y, this.z, blockMetadata);
    }

    public void set(int x, int y, int z) {
        this.set(this.world, this.block, x, y, z, this.blockMetadata);
    }

    public void set(TileEntity te, float partialTick) {
        this.set((IBlockAccess)te.func_145831_w(), te.func_145838_q(), te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145832_p());
        this.partialTick = partialTick;
        this.tileEntity = te;
    }

    public void set(IItemRenderer.ItemRenderType type, ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            this.set(Block.func_149634_a((Item)itemStack.func_77973_b()));
        }
        this.itemStack = itemStack;
        this.itemRenderType = type;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.set(block, metadata);
        this.renderBlocks = renderer;
        this.prepare(2, new double[0]);
        this.render();
        this.clean();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.set(world, block, x, y, z, world.func_72805_g(x, y, z));
        this.renderBlocks = renderer;
        this.vertexDrawn = false;
        this.prepare(1, new double[0]);
        if (renderer.func_147744_b()) {
            this.overrideTexture = renderer.field_147840_d;
        }
        this.render();
        this.clean();
        return this.vertexDrawn;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.set(type, item);
        this.prepare(3, new double[0]);
        this.render();
        this.clean();
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float partialTick) {
        this.set(te, partialTick);
        this.prepare(4, x, y, z);
        this.render();
        if (this.getBlockDamage) {
            this.destroyBlockProgress = this.getBlockDestroyProgress();
            if (this.destroyBlockProgress != null) {
                this.next();
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)774, (int)768, (int)1, (int)0);
                GL11.glAlphaFunc((int)516, (float)0.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                this.t.func_78383_c();
                this.renderDestroyProgress();
                this.next();
                GL11.glDisable((int)3042);
            }
        }
        this.clean();
    }

    public void prepare(int renderType, double ... data) {
        this.renderType = renderType;
        if (renderType == 1) {
            this.tessellatorShift();
        } else if (renderType == 2) {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            this.startDrawing();
        } else if (renderType == 3) {
            GL11.glPushAttrib((int)64);
            this.startDrawing();
        } else if (renderType == 4) {
            GL11.glPushAttrib((int)64);
            RenderHelper.func_74518_a();
            GL11.glEnable((int)2903);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glTranslated((double)data[0], (double)data[1], (double)data[2]);
            this.func_147499_a(TextureMap.field_110575_b);
            this.startDrawing();
        }
    }

    public void startDrawing() {
        this.startDrawing(7);
    }

    public void startDrawing(int drawMode) {
        this.t.func_78371_b(drawMode);
        this.drawMode = drawMode;
    }

    public void next() {
        this.next(this.drawMode);
    }

    public void next(int drawMode) {
        this.draw();
        this.startDrawing(drawMode);
    }

    public void draw() {
        this.t.func_78381_a();
    }

    public void clean() {
        if (this.renderType == 1) {
            this.tessellatorUnshift();
        } else if (this.renderType == 2) {
            this.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (this.renderType == 3) {
            this.draw();
            GL11.glPopAttrib();
        } else if (this.renderType == 4) {
            this.draw();
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
        this.reset();
    }

    public void tessellatorShift() {
        if (this.isShifted) {
            return;
        }
        this.isShifted = true;
        this.t.func_78372_c((float)this.x, (float)this.y, (float)this.z);
    }

    public void tessellatorUnshift() {
        if (!this.isShifted) {
            return;
        }
        this.isShifted = false;
        this.t.func_78372_c((float)(-this.x), (float)(-this.y), (float)(-this.z));
    }

    public void enableBlending() {
        if (this.renderType == 1) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2903);
        GL11.glShadeModel((int)7425);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glAlphaFunc((int)516, (float)0.0f);
    }

    public void renderStandard() {
        this.renderStandard(this.renderBlocks);
    }

    public void renderStandard(RenderBlocks renderer) {
        if (renderer == null) {
            return;
        }
        boolean b = this.isShifted;
        if (b) {
            this.tessellatorUnshift();
        }
        renderer.func_147775_a(this.block);
        renderer.func_147784_q(this.block, this.x, this.y, this.z);
        if (b) {
            this.tessellatorShift();
        }
    }

    public void render() {
    }

    public void renderDestroyProgress() {
    }

    public void drawShape(Shape shape) {
        this.drawShape(shape, null);
    }

    public void drawShape(Shape s, RenderParameters rp) {
        if (s == null) {
            return;
        }
        this.shape = s;
        this.shapeParams = rp != null ? rp : new RenderParameters();
        s.applyMatrix();
        if (this.shapeParams.applyTexture.get().booleanValue()) {
            this.applyTexture(s, this.shapeParams);
        }
        for (Face face : s.getFaces()) {
            this.drawFace(face, face.getParameters());
        }
    }

    public void drawFace(Face face) {
        this.drawFace(face, face.getParameters());
    }

    protected void drawFace(Face f, RenderParameters rp) {
        if (f == null) {
            return;
        }
        int vertexCount = f.getVertexes().length;
        if (vertexCount != 4 && this.renderType == 1) {
            MalisisCore.log.error("[BaseRenderer] Attempting to render a face containing {} vertexes in ISBRH. Ignored", new Object[]{vertexCount});
            return;
        }
        this.face = f;
        this.params = RenderParameters.merge(this.shapeParams, rp);
        if (!this.shouldRenderFace(this.face)) {
            return;
        }
        if (this.renderType == 3 || this.renderType == 2 || this.params.useNormals.get().booleanValue()) {
            this.t.func_78375_b((float)this.params.direction.get().offsetX, (float)this.params.direction.get().offsetY, (float)this.params.direction.get().offsetZ);
        }
        this.baseBrightness = this.getBaseBrightness();
        if (this.params.vertexPositionRelativeToRenderBounds.get().booleanValue()) {
            this.calcVertexesPosition(this.getRenderBounds());
        }
        this.drawVertexes(this.face.getVertexes());
        if (this.drawMode == 9) {
            this.next();
        }
    }

    protected void drawVertexes(Vertex[] vertexes) {
        for (int i = 0; i < vertexes.length; ++i) {
            this.drawVertex(vertexes[i], i);
            if (this.drawMode != 3) continue;
            this.drawVertex(vertexes[i == vertexes.length - 1 ? 0 : i + 1], i);
        }
    }

    protected void drawVertex(Vertex vertex, int count) {
        int brightness = this.calcVertexBrightness(vertex, (int[][])this.params.aoMatrix.get(count));
        vertex.setBrightness(brightness);
        int color = this.calcVertexColor(vertex, (int[][])this.params.aoMatrix.get(count));
        vertex.setColor(color);
        if (!this.params.usePerVertexAlpha.get().booleanValue()) {
            vertex.setAlpha(this.params.alpha.get());
        }
        this.t.func_78384_a(vertex.getColor(), vertex.getAlpha());
        this.t.func_78380_c(vertex.getBrightness());
        if (this.drawMode != 6913 && this.params.useTexture.get().booleanValue()) {
            this.t.func_78374_a(vertex.getX(), vertex.getY(), vertex.getZ(), vertex.getU(), vertex.getV());
        } else {
            this.t.func_78377_a(vertex.getX(), vertex.getY(), vertex.getZ());
        }
        this.vertexDrawn = true;
    }

    protected IIcon getIcon(RenderParameters params) {
        IIcon icon = params.icon.get();
        if (params.useCustomTexture.get().booleanValue()) {
            icon = new MalisisIcon();
        } else if (this.overrideTexture != null) {
            icon = this.overrideTexture;
        } else if (this.block != null && icon == null) {
            int side = 0;
            if (params.textureSide.get() != null) {
                side = params.textureSide.get().ordinal();
            }
            icon = this.block.func_149691_a(side, this.blockMetadata);
        }
        return icon;
    }

    protected boolean shouldRenderFace(Face face) {
        if (this.renderType != 1 || this.world == null || this.block == null) {
            return true;
        }
        if (this.shapeParams != null && this.shapeParams.renderAllFaces.get().booleanValue()) {
            return true;
        }
        if (this.renderBlocks != null && this.renderBlocks.field_147837_f) {
            return true;
        }
        RenderParameters p = face.getParameters();
        if (p.direction.get() == null) {
            return true;
        }
        boolean b = this.block.func_149646_a(this.world, this.x + p.direction.get().offsetX, this.y + p.direction.get().offsetY, this.z + p.direction.get().offsetZ, p.direction.get().ordinal());
        return b;
    }

    public void applyTexture(Shape shape) {
        this.applyTexture(shape, null);
    }

    public void applyTexture(Shape shape, RenderParameters parameters) {
        for (Face f : shape.getFaces()) {
            RenderParameters params = RenderParameters.merge(f.getParameters(), parameters);
            IIcon icon = this.getIcon(params);
            if (icon == null) continue;
            f.setTexture(icon, params.flipU.get(), params.flipV.get(), params.interpolateUV.get());
        }
    }

    protected int calcVertexColor(Vertex vertex, int[][] aoMatrix) {
        int color;
        int n = color = this.params.usePerVertexColor.get() != false ? vertex.getColor() : this.params.colorMultiplier.get().intValue();
        if (this.drawMode == 6913) {
            return color;
        }
        if (this.renderType != 1 && this.renderType != 4) {
            return color;
        }
        if (!this.params.calculateAOColor.get().booleanValue() || aoMatrix == null) {
            return color;
        }
        float factor = this.getBlockAmbientOcclusion(this.world, this.x + this.params.direction.get().offsetX, this.y + this.params.direction.get().offsetY, this.z + this.params.direction.get().offsetZ);
        for (int i = 0; i < aoMatrix.length; ++i) {
            factor += this.getBlockAmbientOcclusion(this.world, this.x + aoMatrix[i][0], this.y + aoMatrix[i][1], this.z + aoMatrix[i][2]);
        }
        int r = (int)((float)(color >> 16 & 0xFF) * (factor *= this.params.colorFactor.get().floatValue()) / (float)(aoMatrix.length + 1));
        int g = (int)((float)(color >> 8 & 0xFF) * factor / (float)(aoMatrix.length + 1));
        int b = (int)((float)(color & 0xFF) * factor / (float)(aoMatrix.length + 1));
        color = r << 16 | g << 8 | b;
        return color;
    }

    protected int getBaseBrightness() {
        if (this.renderType != 1 && this.renderType != 4 || this.world == null || !this.params.useBlockBrightness.get().booleanValue() || this.params.direction.get() == null) {
            return this.params.brightness.get();
        }
        double[][] bounds = this.getRenderBounds();
        ForgeDirection dir = this.params.direction.get();
        int ox = this.x + dir.offsetX;
        int oy = this.y + dir.offsetY;
        int oz = this.z + dir.offsetZ;
        if (dir == ForgeDirection.WEST && bounds[0][0] > 0.0) {
            ++ox;
        } else if (dir == ForgeDirection.EAST && bounds[1][0] < 1.0) {
            --ox;
        } else if (dir == ForgeDirection.NORTH && bounds[0][2] > 0.0) {
            ++oz;
        } else if (dir == ForgeDirection.SOUTH && bounds[1][2] < 1.0) {
            --oz;
        } else if (dir == ForgeDirection.DOWN && bounds[0][1] > 0.0) {
            ++oy;
        } else if (dir == ForgeDirection.UP && bounds[1][1] < 1.0) {
            --oy;
        }
        return this.getMixedBrightnessForBlock(this.world, ox, oy, oz);
    }

    protected int calcVertexBrightness(Vertex vertex, int[][] aoMatrix) {
        if (this.drawMode == 6913) {
            return this.baseBrightness;
        }
        if (this.renderType != 1 && this.renderType != 4) {
            return this.baseBrightness;
        }
        if (!this.params.calculateBrightness.get().booleanValue() || aoMatrix == null) {
            return this.baseBrightness;
        }
        int[] b = new int[Math.max(3, aoMatrix.length)];
        for (int i = 0; i < aoMatrix.length; ++i) {
            int n = i;
            b[n] = b[n] + this.getMixedBrightnessForBlock(this.world, this.x + aoMatrix[i][0], this.y + aoMatrix[i][1], this.z + aoMatrix[i][2]);
        }
        int brightness = this.getAoBrightness(b[0], b[1], b[2], this.baseBrightness);
        return brightness;
    }

    protected int getAoBrightness(int b1, int b2, int b3, int base) {
        if (b1 == 0) {
            b1 = base;
        }
        if (b2 == 0) {
            b2 = base;
        }
        if (b3 == 0) {
            b3 = base;
        }
        return b1 + b2 + b3 + base >> 2 & 0xFF00FF;
    }

    protected float getBlockAmbientOcclusion(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return 1.0f;
        }
        return block.func_149685_I();
    }

    protected int getMixedBrightnessForBlock(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149677_c(world, x, y, z);
    }

    protected double[][] getRenderBounds() {
        if (this.block == null || !this.params.useBlockBounds.get().booleanValue()) {
            return this.params.renderBounds.get();
        }
        if (this.world != null) {
            this.block.func_149719_a(this.world, this.x, this.y, this.z);
        }
        return new double[][]{{this.block.func_149704_x(), this.block.func_149665_z(), this.block.func_149706_B()}, {this.block.func_149753_y(), this.block.func_149669_A(), this.block.func_149693_C()}};
    }

    protected void calcVertexesPosition(double[][] bounds) {
        for (Vertex v : this.face.getVertexes()) {
            v.interpolateCoord(bounds);
        }
    }

    protected Map getDamagedBlocks() {
        if (damagedBlocks != null) {
            return damagedBlocks;
        }
        try {
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            Field f = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{MalisisCore.isObfEnv ? "field_94141_F" : "destroyBlockIcons"});
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            damagedIcons = (IIcon[])f.get(Minecraft.func_71410_x().field_71438_f);
            f = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{MalisisCore.isObfEnv ? "field_72738_E" : "damagedBlocks"});
            modifiers.setInt(f, f.getModifiers());
            damagedBlocks = (HashMap)f.get(Minecraft.func_71410_x().field_71438_f);
            return damagedBlocks;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected DestroyBlockProgress getBlockDestroyProgress() {
        if (this.renderType != 4) {
            return null;
        }
        Map damagedBlocks = this.getDamagedBlocks();
        if (damagedBlocks == null || damagedBlocks.isEmpty()) {
            return null;
        }
        for (DestroyBlockProgress dbp : damagedBlocks.values()) {
            if (!this.isCurrentBlockDestroyProgress(dbp)) continue;
            return dbp;
        }
        return null;
    }

    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        return dbp.func_73110_b() == this.x && dbp.func_73109_c() == this.y && dbp.func_73108_d() == this.z;
    }

    public static <T extends BaseRenderer> T create(Class<T> clazz, IBaseRendering ... blocks) {
        T r = BaseRenderer.create(clazz);
        for (IBaseRendering b : blocks) {
            if (b == null) continue;
            b.setRenderId(((BaseRenderer)((Object)r)).getRenderId());
        }
        return r;
    }

    public static <T extends BaseRenderer> T create(Class<T> clazz) {
        try {
            BaseRenderer r = (BaseRenderer)((Object)clazz.newInstance());
            r.setRenderId(RenderingRegistry.getNextAvailableRenderId());
            return (T)((Object)r);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setRenderId(int id) {
        this.renderId = id;
    }

    public int getRenderId() {
        return this.renderId;
    }
}

