/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation;

import java.util.LinkedList;
import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.element.Shape;
import net.minecraft.client.Minecraft;

public class AnimationRenderer {
    private BaseRenderer renderer;
    private long startTime;
    private long worldTotalTime;
    private float partialTick;
    private float elapsedTime;
    private LinkedList<Animation> animations = new LinkedList();

    public AnimationRenderer(BaseRenderer renderer) {
        this.renderer = renderer;
    }

    public void setStartTime(long start) {
        this.startTime = start;
        this.worldTotalTime = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        this.partialTick = this.renderer.getPartialTick();
        this.elapsedTime = (float)(this.worldTotalTime - this.startTime) + this.partialTick;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public float getElapsedTime() {
        return this.elapsedTime;
    }

    public void addAnimation(Animation animation) {
        this.animations.add(animation);
    }

    public void clearAnimations() {
        this.animations.clear();
    }

    public void animate() {
        for (Animation animation : this.animations) {
            animation.animate(this.elapsedTime);
        }
    }

    public void render(BaseRenderer renderer) {
        for (Animation animation : this.animations) {
            animation.render(renderer);
        }
    }

    public void animate(Shape shape, Transformation animation) {
        if (shape == null) {
            return;
        }
        animation.transform(shape, this.elapsedTime);
    }
}

