/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.element.Shape;

public class Scale
extends Transformation<Scale> {
    protected float fromX = 1.0f;
    protected float fromY = 1.0f;
    protected float fromZ = 1.0f;
    protected float toX = 1.0f;
    protected float toY = 1.0f;
    protected float toZ = 1.0f;

    public Scale() {
    }

    public Scale(float x, float y, float z) {
        this.to(x, y, z);
    }

    public Scale(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        this.from(fromX, fromY, fromZ);
        this.to(toX, toY, toZ);
    }

    protected Scale from(float x, float y, float z) {
        this.fromX = x;
        this.fromY = y;
        this.fromZ = z;
        return this;
    }

    protected Scale to(float x, float y, float z) {
        this.toX = x;
        this.toY = y;
        this.toZ = z;
        return this;
    }

    @Override
    protected void doTransform(Shape s, float comp) {
        comp = Math.max(comp, 0.0f);
        s.scale(this.fromX + (this.toX - this.fromX) * comp, this.fromY + (this.toY - this.fromY) * comp, this.fromZ + (this.toZ - this.fromZ) * comp);
    }

    @Override
    public Scale reversed(boolean reversed) {
        if (!reversed) {
            return this;
        }
        float tmpX = this.fromX;
        float tmpY = this.fromY;
        float tmpZ = this.fromZ;
        this.fromX = this.toX;
        this.fromY = this.toY;
        this.fromZ = this.toZ;
        this.toX = tmpX;
        this.toY = tmpY;
        this.toZ = tmpZ;
        return this;
    }
}

