/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.element.Shape;

public class Translation
extends Transformation<Translation> {
    protected float fromX;
    protected float fromY;
    protected float fromZ;
    protected float toX;
    protected float toY;
    protected float toZ;

    public Translation(float x, float y, float z) {
        this.to(x, y, z);
    }

    public Translation(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        this.from(fromX, fromY, fromZ);
        this.to(toX, toY, toZ);
    }

    public Translation from(float x, float y, float z) {
        this.fromX = x;
        this.fromY = y;
        this.fromZ = z;
        return this;
    }

    public Translation to(float x, float y, float z) {
        this.toX = x;
        this.toY = y;
        this.toZ = z;
        return this;
    }

    @Override
    protected void doTransform(Shape s, float comp) {
        if (comp >= 0.0f) {
            s.translate(this.fromX + (this.toX - this.fromX) * comp, this.fromY + (this.toY - this.fromY) * comp, this.fromZ + (this.toZ - this.fromZ) * comp);
        }
    }

    @Override
    public Translation reversed(boolean reversed) {
        if (!reversed) {
            return this;
        }
        float tmpX = this.fromX;
        float tmpY = this.fromY;
        float tmpZ = this.fromZ;
        this.fromX = this.toX;
        this.fromY = this.toY;
        this.fromZ = this.toZ;
        this.toX = tmpX;
        this.toY = tmpY;
        this.toZ = tmpZ;
        return this;
    }
}

