/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.model;

import java.util.Collection;
import java.util.HashMap;
import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.model.loader.ObjFileImporter;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.WavefrontObject;

public class MalisisModel {
    protected String fileName;
    protected WavefrontObject wfo;
    protected HashMap<String, Shape> shapes = new HashMap();

    public MalisisModel() {
    }

    public MalisisModel(ResourceLocation resource) {
    }

    public void addShape(String name, Shape shape) {
        this.shapes.put(name, shape);
    }

    public Shape getShape(String name) {
        return this.shapes.get(name);
    }

    public Collection<Shape> getShapes() {
        return this.shapes.values();
    }

    public void render(BaseRenderer renderer) {
        this.render(renderer, (RenderParameters)null);
    }

    public void render(BaseRenderer renderer, RenderParameters rp) {
        for (String name : this.shapes.keySet()) {
            this.render(renderer, name, rp);
        }
    }

    public void render(BaseRenderer renderer, String name) {
        this.render(renderer, name, null);
    }

    public void render(BaseRenderer renderer, String name, RenderParameters rp) {
        Shape shape = this.shapes.get(name);
        if (shape != null) {
            renderer.drawShape(new Shape(shape), rp);
        }
    }

    public static MalisisModel load(ResourceLocation resource) {
        ObjFileImporter importer = new ObjFileImporter(resource);
        return importer.getModel();
    }
}

