/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.model.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.model.MalisisModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelFormatException;

public class ObjFileImporter {
    private MalisisModel model;
    protected String fileName;
    protected Pattern linePattern = Pattern.compile("^(?<type>.*?) (?<data>.*)$");
    protected Pattern facePattern = Pattern.compile("(?<v>\\d+)(/(?<t>\\d+)?(/(?<n>\\d+))?)?");
    protected Matcher matcher;
    protected String currentLine;
    protected int lineNumber;
    protected String currentShape = "Default";
    protected List<Vertex> vertexes = new ArrayList<Vertex>();
    protected List<UV> uvs = new ArrayList<UV>();
    protected List<Face> faces = new ArrayList<Face>();

    public ObjFileImporter(ResourceLocation resource) throws ModelFormatException {
        this.fileName = resource.toString();
        this.model = new MalisisModel();
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource);
            this.loadObjModel(res.func_110527_b());
        }
        catch (IOException e) {
            throw new ModelFormatException("IO Exception reading model format", (Throwable)e);
        }
    }

    public MalisisModel getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObjModel(InputStream inputStream) throws ModelFormatException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream));
            block27: while ((this.currentLine = reader.readLine()) != null) {
                ++this.lineNumber;
                this.currentLine = this.currentLine.replaceAll("\\s+", " ").trim();
                this.matcher = this.linePattern.matcher(this.currentLine);
                if (this.matcher.matches()) {
                    String type = this.matcher.group("type");
                    String data = this.matcher.group("data");
                    switch (type) {
                        case "v": {
                            this.addVertex(data);
                            continue block27;
                        }
                        case "vn": {
                            continue block27;
                        }
                        case "vt": {
                            this.addUV(data);
                            continue block27;
                        }
                        case "f": {
                            this.addFace(data);
                            continue block27;
                        }
                        case "g": 
                        case "o": {
                            this.addShape(data);
                            continue block27;
                        }
                    }
                    MalisisCore.log.debug("[ObjFileImporter] Skipped type {} at line {} : {}", new Object[]{type, this.lineNumber, this.currentLine});
                    continue;
                }
                MalisisCore.log.debug("[ObjFileImporter] Skipped non-matching line {} : {}", new Object[]{this.lineNumber, this.currentLine});
            }
            this.addShape("");
        }
        catch (IOException e) {
            throw new ModelFormatException("IO Exception reading model format", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            try {
                reader.close();
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void addVertex(String data) {
        String[] coords = data.split("\\s+");
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (coords.length != 3) {
            MalisisCore.log.error("[ObjFileImporter] Wrong coordinates number {} at line {} : {}", new Object[]{coords.length, this.lineNumber, this.currentLine});
        } else {
            x = Float.parseFloat(coords[0]);
            y = Float.parseFloat(coords[1]);
            z = Float.parseFloat(coords[2]);
        }
        this.vertexes.add(new Vertex(x, y, z));
    }

    private void addUV(String data) {
        String[] coords = data.split("\\s+");
        float u = 0.0f;
        float v = 0.0f;
        if (coords.length != 2) {
            MalisisCore.log.error("[ObjFileImporter] Wrong coordinates number {} at line {} : {}", new Object[]{coords.length, this.lineNumber, this.currentLine});
        } else {
            u = Float.parseFloat(coords[0]);
            v = 1.0f - Float.parseFloat(coords[1]);
        }
        this.uvs.add(new UV(u, v));
    }

    private void addFace(String data) {
        this.matcher = this.facePattern.matcher(data);
        ArrayList<Vertex> faceVertex = new ArrayList<Vertex>();
        int v = 0;
        int t = 0;
        UV uv = null;
        while (this.matcher.find()) {
            String strV = this.matcher.group("v");
            String strT = this.matcher.group("t");
            v = Integer.parseInt(strV);
            Vertex vertex = this.vertexes.get(v > 0 ? v - 1 : this.vertexes.size() - v - 1);
            if (vertex != null) {
                Vertex vertexCopy = new Vertex(vertex);
                if (strT != null && (uv = this.uvs.get((t = Integer.parseInt(strT)) > 0 ? t - 1 : this.uvs.size() - t - 1)) != null) {
                    vertexCopy.setUV(uv.u, uv.v);
                }
                faceVertex.add(vertexCopy);
                continue;
            }
            MalisisCore.log.error("[ObjFileImporter] Wrong vertex reference {} for face at line {} :\n{}", new Object[]{v, this.lineNumber, this.currentLine});
        }
        this.faces.add(new Face(faceVertex));
    }

    private void addShape(String data) {
        if (this.faces.size() != 0) {
            this.model.addShape(this.currentShape, new Shape(this.faces));
            this.faces.clear();
        }
        if (data != "") {
            this.currentShape = data.substring(0, data.indexOf(95));
        }
    }

    private class UV {
        float u;
        float v;

        public UV(float u, float v) {
            this.u = u;
            this.v = v;
        }
    }
}

