/*
 * Decompiled with CFR 0.152.
 */
package bettersand;

import bettersand.BucketUnit;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

@Mod(modid="BetterSand", name="Better Sand")
public final class BetterSand {
    public static final String REGISTRY = "sand";
    public static final int UNIT = 3;
    public static final Material SAND_MATERIAL = new MaterialLiquid(MapColor.field_151658_d){

        public boolean func_76218_k() {
            return true;
        }
    };
    private Block sandUnit;
    private int[] generate = new int[]{0};

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Fluid liquidSand;
        boolean craft = true;
        try {
            Configuration config = new Configuration(event.getSuggestedConfigurationFile());
            this.generate = config.get("World Generation", "Modded sand generate in world", this.generate, "Select dimension ids in which special sand will generate. Default is overworld.").getIntList();
            craft = config.getBoolean("Craft sand bucket into sand", "Crafting", craft, "Set to false to remove crafting recipe");
            config.save();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        Arrays.sort(this.generate);
        if (!FluidRegistry.isFluidRegistered((String)REGISTRY)) {
            liquidSand = new BlockFluid(REGISTRY).setDensity(3000).setViscosity(4000);
            FluidRegistry.registerFluid((Fluid)liquidSand);
        } else {
            liquidSand = FluidRegistry.getFluid((String)REGISTRY);
        }
        if (liquidSand.canBePlacedInWorld()) {
            this.sandUnit = liquidSand.getBlock();
        } else {
            this.sandUnit = new Finite(liquidSand).setQuantaPerBlock(3).func_149658_d(REGISTRY);
            GameRegistry.registerBlock((Block)this.sandUnit, (String)REGISTRY);
        }
        Item sandBucket = new BucketUnit(this.sandUnit, 3).func_77655_b("bucketSand").func_77642_a(FluidContainerRegistry.EMPTY_BUCKET.func_77973_b()).func_111206_d("bucket_sand");
        if (FluidContainerRegistry.registerFluidContainer((Fluid)liquidSand, (ItemStack)new ItemStack(sandBucket), (ItemStack)FluidContainerRegistry.EMPTY_BUCKET)) {
            GameRegistry.registerItem((Item)sandBucket, (String)"sandBucket");
            if (craft) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)Blocks.field_150354_m), (Object[])new Object[]{sandBucket});
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPopulating(PopulateChunkEvent.Post populate) {
        if (Arrays.binarySearch(this.generate, populate.world.field_73011_w.field_76574_g) >= 0) {
            int xMin = populate.chunkX * 16 + 8;
            int xMax = xMin + 16;
            int zMin = populate.chunkZ * 16 + 8;
            int zMax = zMin + 16;
            for (int x = xMin; x < xMax; ++x) {
                for (int z = zMin; z < zMax; ++z) {
                    int y = populate.world.func_72825_h(x, z) - 1;
                    if (populate.world.func_147439_a(x, y, z) != Blocks.field_150354_m || populate.world.func_72805_g(x, y, z) != 0 || !this.isAirAround(populate.world, x, y, z)) continue;
                    populate.world.func_147465_d(x, y, z, this.sandUnit, 2, 3);
                }
            }
        }
    }

    private boolean isAirAround(World world, int x, int y, int z) {
        return world.func_147437_c(x - 1, y, z) || world.func_147437_c(x + 1, y, z) || world.func_147437_c(x, y, z - 1) || world.func_147437_c(x, y, z + 1);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void inSand(LivingEvent.LivingUpdateEvent event) {
        if (event.entity.func_70089_S() && event.entity.func_70055_a(SAND_MATERIAL)) {
            event.entity.func_70097_a(DamageSource.field_76368_d, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result;
        int k;
        int j;
        int i;
        Block block;
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && FluidContainerRegistry.isEmptyContainer((ItemStack)event.current) && (block = event.world.func_147439_a(i = event.target.field_72311_b, j = event.target.field_72312_c, k = event.target.field_72309_d)).func_149688_o() == SAND_MATERIAL && block instanceof IFluidBlock && (result = FluidContainerRegistry.fillFluidContainer((FluidStack)((IFluidBlock)block).drain(event.world, i, j, k, false), (ItemStack)event.current)) != null) {
            ((IFluidBlock)block).drain(event.world, i, j, k, true);
            event.setResult(Event.Result.ALLOW);
            event.result = result;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSandBreak(BlockEvent.BreakEvent breakEvent) {
        if (breakEvent.block == Blocks.field_150354_m && breakEvent.world.func_72805_g(breakEvent.x, breakEvent.y, breakEvent.z) == 0) {
            if (breakEvent.getPlayer() != null && EnchantmentHelper.func_77502_d((EntityLivingBase)breakEvent.getPlayer())) {
                return;
            }
            breakEvent.setCanceled(true);
            breakEvent.world.func_147465_d(breakEvent.x, breakEvent.y, breakEvent.z, this.sandUnit, 2, 3);
        }
    }

    public static class Finite
    extends BlockFluidFinite {
        public Finite(Fluid fluid) {
            super(fluid, SAND_MATERIAL);
        }

        public void func_149674_a(World world, int x, int y, int z, Random rand) {
            if (world.func_147439_a(x, y + 1, z).func_149688_o() == Material.field_151595_p) {
                world.func_147465_d(x, y + 1, z, (Block)this, this.quantaPerBlock - 1, 3);
            }
            super.func_149674_a(world, x, y, z, rand);
        }

        public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + (double)this.getFilledPercentage(world, x, y, z) * (double)0.65f), (double)((double)z + 1.0));
        }
    }

    public static class BlockFluid
    extends Fluid {
        public BlockFluid(String name) {
            super(name);
            this.setIcons(((Block)GameData.getBlockRegistry().func_82594_a(name)).func_149691_a(0, 0));
        }

        public String getUnlocalizedName() {
            return "tile." + this.getName() + ".name";
        }
    }
}

