/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.Dimension;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CellularAutomationIslands {
    protected World currentWorld;
    public int w;
    public int h;
    public int l;
    protected int[][][] IslandArray;
    protected Random myRand;
    public ArrayList<BlockPos> MyList;
    public ArrayList<BlockPos> MyDirtList;
    public ArrayList<BlockPos> MyGrassList;
    public int OffsetX;
    public int OffsetY;
    public int OffsetZ;

    public CellularAutomationIslands(World myWorld, int W, int H, int L) {
        this.currentWorld = myWorld;
        this.w = W;
        this.h = H;
        this.l = L;
        this.IslandArray = new int[W][H][L];
        this.myRand = new Random();
        this.MyList = new ArrayList();
        this.MyDirtList = new ArrayList();
        this.MyGrassList = new ArrayList();
    }

    public void BeginGeneration(int Iterations, int SmoothIterations) {
        int i;
        int i2;
        this.SeedGameofLife();
        for (i2 = 0; i2 < Iterations; ++i2) {
            this.IterateLife();
        }
        for (i2 = 0; i2 < SmoothIterations; ++i2) {
            this.Smooth();
        }
        this.CullSingleBlocks();
        this.CullSingleBlocks();
        this.FlattenTop();
        this.ExtractLargestIsland();
        for (i2 = 0; i2 < 96; ++i2) {
            for (int j = 0; j < 50; ++j) {
                for (int k = 0; k < 96; ++k) {
                    if (this.IslandArray[i2][j][k] != 1) continue;
                    if (j + 1 < 50 && this.IslandArray[i2][j + 1][k] != 1) {
                        this.MyGrassList.add(new BlockPos(i2, j, k));
                        continue;
                    }
                    if (j + 2 < 50 && this.IslandArray[i2][j + 2][k] != 1) {
                        this.MyDirtList.add(new BlockPos(i2, j, k));
                        continue;
                    }
                    if (j + 3 < 50 && this.IslandArray[i2][j + 3][k] != 1) {
                        this.MyDirtList.add(new BlockPos(i2, j, k));
                        continue;
                    }
                    this.MyList.add(new BlockPos(i2, j, k));
                }
            }
        }
        int maxY = 0;
        int minY = 0;
        int maxX = 0;
        int minX = 0;
        int maxZ = 0;
        int minZ = 0;
        for (int i3 = 0; i3 < this.MyList.size(); ++i3) {
            if (this.MyList.get(i3).func_177958_n() > maxX) {
                maxX = this.MyList.get(i3).func_177958_n();
            }
            if (this.MyList.get(i3).func_177956_o() > maxY) {
                maxY = this.MyList.get(i3).func_177956_o();
            }
            if (this.MyList.get(i3).func_177952_p() > maxZ) {
                maxZ = this.MyList.get(i3).func_177952_p();
            }
            if (this.MyList.get(i3).func_177958_n() < minX) {
                minX = this.MyList.get(i3).func_177958_n();
            }
            if (this.MyList.get(i3).func_177956_o() < minY) {
                minY = this.MyList.get(i3).func_177956_o();
            }
            if (this.MyList.get(i3).func_177952_p() >= minZ) continue;
            minZ = this.MyList.get(i3).func_177952_p();
        }
        int midX = maxX - (maxX - minX) / 2;
        int midY = maxY - (maxY - minY) / 2;
        int midZ = maxZ - (maxZ - minZ) / 2;
        this.OffsetX = this.l / 2 - midX;
        this.OffsetY = this.h / 2 - midY;
        this.OffsetZ = this.w / 2 - midZ;
        for (i = 0; i < this.MyList.size(); ++i) {
            this.MyList.get(i).func_177982_a(this.OffsetX - this.l / 2, this.OffsetY - this.h / 2, this.OffsetZ - this.l / 2);
        }
        for (i = 0; i < this.MyDirtList.size(); ++i) {
            this.MyDirtList.get(i).func_177982_a(this.OffsetX - this.l / 2, this.OffsetY - this.h / 2, this.OffsetZ - this.l / 2);
        }
        for (i = 0; i < this.MyGrassList.size(); ++i) {
            this.MyGrassList.get(i).func_177982_a(this.OffsetX - this.l / 2, this.OffsetY - this.h / 2, this.OffsetZ - this.l / 2);
        }
    }

    private void IterateLife() {
        float ChancetoGrow = 0.4f;
        float ChancetoDie = 0.6f;
        int[][][] TempArray = new int[this.w][this.h][this.l];
        for (int i = 0; i < this.w; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.l; ++k) {
                    int Count = this.CountSurrounding(i, j, k);
                    if (Count <= 4 && Count != 0) {
                        if (this.myRand.nextFloat() < ChancetoGrow) {
                            TempArray[i][j][k] = 1;
                            continue;
                        }
                        TempArray[i][j][k] = this.IslandArray[i][j][k];
                        continue;
                    }
                    if (Count >= 5) {
                        if (this.myRand.nextFloat() < ChancetoDie) {
                            TempArray[i][j][k] = 0;
                            continue;
                        }
                        TempArray[i][j][k] = this.IslandArray[i][j][k];
                        continue;
                    }
                    TempArray[i][j][k] = this.IslandArray[i][j][k];
                }
            }
        }
        this.IslandArray = TempArray;
    }

    private void Smooth() {
        float ChancetoGrow = 0.1f;
        float ChancetoDie = 0.6f;
        int[][][] TempArray = new int[this.w][this.h][this.l];
        for (int i = 0; i < this.w; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.l; ++k) {
                    int Count = this.CountSurrounding(i, j, k);
                    if (Count == 6) {
                        TempArray[i][j][k] = 1;
                        continue;
                    }
                    if (Count > 2) {
                        if (this.myRand.nextFloat() < ChancetoGrow * (float)Count) {
                            TempArray[i][j][k] = 1;
                            continue;
                        }
                        TempArray[i][j][k] = this.IslandArray[i][j][k];
                        continue;
                    }
                    if (Count > 0 && Count < 3) {
                        if (this.myRand.nextFloat() < ChancetoGrow * (float)Count) {
                            TempArray[i][j][k] = 0;
                            continue;
                        }
                        TempArray[i][j][k] = this.IslandArray[i][j][k];
                        continue;
                    }
                    TempArray[i][j][k] = 0;
                }
            }
        }
        this.IslandArray = TempArray;
    }

    private void FlattenTop() {
        for (int i = 0; i < this.w; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.l; ++k) {
                    int Count = this.CountSurrounding(i, j, k);
                    if (j + 1 >= this.h || this.IslandArray[i][j + 1][k] != 0) continue;
                    this.IslandArray[i][j][k] = 0;
                }
            }
        }
    }

    private int CountSurrounding(int i, int j, int k) {
        int Count = 0;
        if (i - 1 > 0 && this.IslandArray[i - 1][j][k] == 1) {
            ++Count;
        }
        if (i + 1 < this.w && this.IslandArray[i + 1][j][k] == 1) {
            ++Count;
        }
        if (j - 1 > 0 && this.IslandArray[i][j - 1][k] == 1) {
            ++Count;
        }
        if (j + 1 < this.h && this.IslandArray[i][j + 1][k] == 1) {
            ++Count;
        }
        if (k - 1 > 0 && this.IslandArray[i][j][k - 1] == 1) {
            ++Count;
        }
        if (k + 1 < this.l && this.IslandArray[i][j][k + 1] == 1) {
            ++Count;
        }
        return Count;
    }

    private void CullSingleBlocks() {
        int[][][] TempArray = new int[this.w][this.h][this.l];
        for (int i = 0; i < this.w; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.l; ++k) {
                    int Count = this.CountSurrounding(i, j, k);
                    TempArray[i][j][k] = Count < 3 ? 0 : this.IslandArray[i][j][k];
                }
            }
        }
        this.IslandArray = TempArray;
    }

    private void SeedGameofLife() {
        float SpawnChance = 1.0E-4f;
        for (int i = 10; i < this.w - 10; ++i) {
            for (int j = 10; j < this.h - 10; ++j) {
                for (int k = 10; k < this.l - 10; ++k) {
                    if (!(this.myRand.nextFloat() < SpawnChance)) continue;
                    this.IslandArray[i][j][k] = 1;
                }
            }
        }
    }

    public void TranslateIslandtoWorld(int x, int y, int z, World myWorld) {
        System.out.println(x + " " + y + " " + z);
        for (int i = 0; i < this.w; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.l; ++k) {
                    if (this.IslandArray[i][j][k] != 1 || this.currentWorld.func_180495_p(new BlockPos(i + x, j + y, k + z)).func_177230_c().func_149688_o(this.currentWorld.func_180495_p(new BlockPos(i + x, j + y, k + z))) != Material.field_151579_a) continue;
                    myWorld.func_175656_a(new BlockPos(i + x, j + y, k + z), Blocks.field_150348_b.func_176223_P());
                }
            }
        }
    }

    private void ExtractLargestIsland() {
        int k;
        int j;
        int i;
        int[][][] CheckArray = new int[this.w][this.h][this.l];
        int Max = 0;
        for (i = 0; i < this.w; ++i) {
            for (j = 0; j < this.h; ++j) {
                for (k = 0; k < this.l; ++k) {
                    int GetCount;
                    if (CheckArray[i][j][k] != 0 || this.IslandArray[i][j][k] != 1 || (GetCount = this.FillIslandCheck(CheckArray, new BlockPos(i, j, k))) <= Max) continue;
                    Max = GetCount;
                }
            }
        }
        for (i = 0; i < this.w; ++i) {
            for (j = 0; j < this.h; ++j) {
                for (k = 0; k < this.l; ++k) {
                    if (CheckArray[i][j][k] == Max) continue;
                    this.IslandArray[i][j][k] = 0;
                }
            }
        }
    }

    private int FillIslandCheck(int[][][] myCheckArray, BlockPos myPos) {
        int Z;
        int Y;
        int X;
        int i;
        ArrayList<BlockPos> MyList = new ArrayList<BlockPos>();
        int Count = 1;
        MyList.add(myPos);
        for (i = 0; i < MyList.size(); ++i) {
            X = ((BlockPos)MyList.get(i)).func_177958_n();
            Y = ((BlockPos)MyList.get(i)).func_177956_o();
            Z = ((BlockPos)MyList.get(i)).func_177952_p();
            if (X + 1 < this.w && this.IslandArray[X + 1][Y][Z] == 1 && !MyList.contains(new BlockPos(X + 1, Y, Z))) {
                MyList.add(new BlockPos(X + 1, Y, Z));
                ++Count;
            }
            if (X - 1 > 0 && this.IslandArray[X - 1][Y][Z] == 1 && !MyList.contains(new BlockPos(X - 1, Y, Z))) {
                MyList.add(new BlockPos(X - 1, Y, Z));
                ++Count;
            }
            if (Y - 1 > 0 && this.IslandArray[X][Y - 1][Z] == 1 && !MyList.contains(new BlockPos(X, Y - 1, Z))) {
                MyList.add(new BlockPos(X, Y - 1, Z));
                ++Count;
            }
            if (Y + 1 < this.h && this.IslandArray[X][Y + 1][Z] == 1 && !MyList.contains(new BlockPos(X, Y + 1, Z))) {
                MyList.add(new BlockPos(X, Y + 1, Z));
                ++Count;
            }
            if (Z + 1 < this.l && this.IslandArray[X][Y][Z + 1] == 1 && !MyList.contains(new BlockPos(X, Y, Z + 1))) {
                MyList.add(new BlockPos(X, Y, Z + 1));
                ++Count;
            }
            if (Z - 1 <= 0 || this.IslandArray[X][Y][Z - 1] != 1 || MyList.contains(new BlockPos(X, Y, Z - 1))) continue;
            MyList.add(new BlockPos(X, Y, Z - 1));
            ++Count;
        }
        for (i = 0; i < MyList.size(); ++i) {
            X = ((BlockPos)MyList.get(i)).func_177958_n();
            Y = ((BlockPos)MyList.get(i)).func_177956_o();
            Z = ((BlockPos)MyList.get(i)).func_177952_p();
            myCheckArray[X][Y][Z] = MyList.size();
        }
        return MyList.size();
    }

    public int[][][] GetIsland() {
        return this.IslandArray;
    }
}

