/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.blocks;

import CookingPlus.blocks.CookingPlusCustomBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class CookingPlusCustomBlockBush
extends CookingPlusCustomBlock
implements IPlantable {
    protected CookingPlusCustomBlockBush(Material materialIn) {
        super(materialIn);
        this.func_149675_a(true);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 3.0f, 0.5f + f);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    protected CookingPlusCustomBlockBush() {
        this(Material.field_151585_k);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    protected boolean canPlaceBlockOn(Block ground) {
        return ground == Blocks.field_150349_c || ground == Blocks.field_150346_d || ground == Blocks.field_150458_ak;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        super.func_189540_a(state, worldIn, pos, neighborBlock);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return this.func_185514_i(worldIn.func_180495_p(pos.func_177977_b()));
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    @Override
    public void setBlockBounds(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.MY_FULL_BLOCK_AABB = new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.MY_FULL_BLOCK_AABB != null) {
            return this.MY_FULL_BLOCK_AABB;
        }
        return super.func_185496_a(state, source, pos);
    }

    @Override
    public boolean func_176214_u() {
        return this.isOpaqueCube();
    }

    @Override
    public boolean isOpaqueCube() {
        return true;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return this.isFullCube();
    }

    @Override
    public boolean isFullCube() {
        return true;
    }

    @Override
    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.canSustainLeaves(world, pos);
    }

    @Override
    public boolean canSustainLeaves(IBlockAccess world, BlockPos pos) {
        return false;
    }
}

