/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CookingPlusCustomCrops
extends BlockCrops
implements IGrowable {
    protected int maxGrowthStage = 7;
    AxisAlignedBB MY_FULL_BLOCK_AABB;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);

    public CookingPlusCustomCrops() {
        this.func_149675_a(true);
        float f = 0.5f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149649_H();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Block soil = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return soil == Blocks.field_150458_ak;
    }

    public void incrementGrowStage(World parWorld, Random parRand, BlockPos myPos, IBlockState myState) {
        int growStage = (Integer)myState.func_177229_b((IProperty)AGE) + MathHelper.func_76136_a((Random)parRand, (int)2, (int)5);
        if (growStage > this.maxGrowthStage) {
            growStage = this.maxGrowthStage;
        }
        parWorld.func_180501_a(myPos, myState.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(growStage)), 2);
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return this.GetSeedItem();
    }

    public boolean func_176473_a(World parWorld, BlockPos myPos, IBlockState myState, boolean p_149851_5_) {
        return (Integer)myState.func_177229_b((IProperty)AGE) != 7;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World parWorld, Random parRand, BlockPos myPos, IBlockState myState) {
        this.incrementGrowStage(parWorld, parRand, myPos, myState);
    }

    public void func_180650_b(World parWorld, BlockPos myPos, IBlockState myState, Random parRand) {
        super.func_180650_b(parWorld, myPos, myState, parRand);
        int growStage = (Integer)myState.func_177229_b((IProperty)AGE) + 1;
        if (growStage > 7) {
            growStage = 7;
        }
        parWorld.func_180501_a(myPos, myState.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(growStage)), 2);
    }

    protected boolean stillOnFarm(World parWorld, int parX, int parY, int parZ) {
        return this.GetWorldBlock(parWorld, parX, parY - 1, parZ) != null && this.GetWorldBlock(parWorld, parX, parY - 1, parZ).equals(Blocks.field_150458_ak);
    }

    public boolean func_180671_f(World world, BlockPos myPos, IBlockState myState) {
        return this.stillOnFarm(world, myPos.func_177958_n(), myPos.func_177956_o(), myPos.func_177952_p());
    }

    protected Block GetWorldBlock(World myWorld, int x, int y, int z) {
        return myWorld.func_180495_p(new BlockPos(new Vec3d((double)x, (double)y, (double)z))).func_177230_c();
    }

    protected Item GetSeedItem() {
        return null;
    }

    protected Item GetHarvestItem() {
        return null;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos myPos, IBlockState myState, int fortune) {
        List ret = super.getDrops(world, myPos, myState, fortune);
        ret.clear();
        int growStage = (Integer)myState.func_177229_b((IProperty)AGE);
        ret.add(new ItemStack(this.GetSeedItem(), 1, 0));
        if (growStage >= 7) {
            ret.add(new ItemStack(this.GetHarvestItem(), 1, 0));
            for (int i = 0; i < 2 + fortune; ++i) {
                Random MyRand = new Random();
                if (MyRand.nextInt(40) > growStage) continue;
                ret.add(new ItemStack(this.GetSeedItem(), 1, 0));
            }
        }
        return ret;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 1;
    }

    public String getName() {
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public void setBlockBounds(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.MY_FULL_BLOCK_AABB = new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.MY_FULL_BLOCK_AABB != null) {
            return this.MY_FULL_BLOCK_AABB;
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean func_176214_u() {
        return this.isOpaqueCube();
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isFullCube();
    }

    public boolean isFullCube() {
        return false;
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.canSustainLeaves(world, pos);
    }

    public boolean canSustainLeaves(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

