/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.blocks;

import CookingPlus.blocks.CookingPlusCustomBlockBush;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CookingPlusCustomGrowingBush
extends CookingPlusCustomBlockBush
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);

    public CookingPlusCustomGrowingBush() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public boolean canBlockStay(World world, BlockPos myPos, IBlockState myState) {
        Block parBlock = world.func_180495_p(myPos).func_177230_c();
        if (parBlock == Blocks.field_150346_d) {
            return true;
        }
        if (parBlock == Blocks.field_150349_c) {
            return true;
        }
        if (parBlock == Blocks.field_150458_ak) {
            return true;
        }
        return parBlock == this.getBushBlock();
    }

    public boolean canBlockGrow(World world, BlockPos myPos, IBlockState myState) {
        Block parBlock = world.func_180495_p(new BlockPos(new Vec3d((double)myPos.func_177958_n(), (double)(myPos.func_177956_o() - 1), (double)myPos.func_177952_p()))).func_177230_c();
        if (parBlock == Blocks.field_150346_d) {
            return true;
        }
        if (parBlock == Blocks.field_150349_c) {
            return true;
        }
        return parBlock == Blocks.field_150349_c;
    }

    @Override
    protected boolean canPlaceBlockOn(Block parBlock) {
        if (parBlock == Blocks.field_150346_d) {
            return true;
        }
        if (parBlock == Blocks.field_150349_c) {
            return true;
        }
        if (parBlock == Blocks.field_150349_c) {
            return true;
        }
        return parBlock == this.getBushBlock();
    }

    public boolean func_180670_a(World p_149852_1_, Random parRand, BlockPos pos, IBlockState state) {
        return false;
    }

    public Block getBushBlock() {
        return null;
    }

    public Item getBushDrop() {
        return null;
    }

    public void growBush(World parWorld, Random parRand, int parX, int parY, int parZ, IBlockState state) {
        if (parRand.nextInt(10) > 2 && this.GetWorldBlock(parWorld, parX, parY + 1, parZ) != null && parWorld.func_180495_p(new BlockPos(parX, parY + 1, parZ)).func_177230_c().func_149688_o(parWorld.func_180495_p(new BlockPos(parX, parY + 1, parZ))) == Material.field_151579_a && this.canGrow(parWorld, new BlockPos(new Vec3d((double)parX, (double)(parY + 1), (double)parZ)), state)) {
            this.SetWorldBlock(parWorld, parX, parY + 1, parZ, this.getBushBlock(), 0, 2);
        }
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState myState, Random rand) {
        super.func_180650_b(worldIn, pos, myState, rand);
        int growStage = (Integer)myState.func_177229_b((IProperty)AGE) + 1;
        if (growStage >= 7) {
            this.growBush(worldIn, rand, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), myState);
            growStage = 7;
        }
        worldIn.func_180501_a(pos, myState.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(growStage)), 2);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos myPos, IBlockState myState, int fortune) {
        List ret = super.getDrops(world, myPos, myState, fortune);
        ret.clear();
        int growStage = (Integer)myState.func_177229_b((IProperty)AGE);
        ret.add(new ItemStack(Item.func_150898_a((Block)this.getBushBlock()), 1, 0));
        if (growStage >= 6) {
            ret.add(new ItemStack(this.getBushDrop(), 1, 0));
            if (growStage == 7) {
                for (int i = 0; i < 2 + fortune; ++i) {
                    Random MyRand = new Random();
                    if (MyRand.nextInt(40) > growStage) continue;
                    ret.add(new ItemStack(this.getBushDrop(), 1, 0));
                }
            }
        }
        return ret;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Item.func_150898_a((Block)this.getBushBlock());
    }

    public boolean func_176473_a(World parWorld, BlockPos MyPos, IBlockState state, boolean p_149851_5_) {
        int parZ;
        int parY;
        int parX = MyPos.func_177958_n();
        if (this.GetWorldBlock(parWorld, parX, (parY = MyPos.func_177956_o()) - 2, parZ = MyPos.func_177952_p()) != null) {
            if (this.canBlockGrow(parWorld, new BlockPos(new Vec3d((double)parX, (double)(parY - 1), (double)parZ)), state)) {
                return true;
            }
            if (this.GetWorldBlock(parWorld, parX, parY - 2, parZ).equals(this.getBushBlock()) && this.GetWorldBlock(parWorld, parX, parY - 3, parZ) != null && this.canBlockGrow(parWorld, new BlockPos(new Vec3d((double)parX, (double)(parY - 2), (double)parZ)), state)) {
                return true;
            }
        }
        return false;
    }

    public void func_176474_b(World parWorld, Random parRand, BlockPos pos, IBlockState state) {
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 1;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && (Integer)state.func_177229_b((IProperty)AGE) >= 6) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 2);
            playerIn.func_71019_a(new ItemStack(this.getBushDrop()), false);
        }
        return true;
    }

    public boolean canGrow(World parWorld, BlockPos myPos, IBlockState myState) {
        if (this.GetWorldBlock(parWorld, myPos.func_177958_n(), myPos.func_177956_o() - 2, myPos.func_177952_p()) != null) {
            if (this.canBlockGrow(parWorld, new BlockPos(new Vec3d((double)myPos.func_177958_n(), (double)(myPos.func_177956_o() - 1), (double)myPos.func_177952_p())), myState)) {
                return true;
            }
            if (this.GetWorldBlock(parWorld, myPos.func_177958_n(), myPos.func_177956_o() - 2, myPos.func_177952_p()).equals(this.getBushBlock()) && this.GetWorldBlock(parWorld, myPos.func_177958_n(), myPos.func_177956_o() - 3, myPos.func_177952_p()) != null && this.canBlockGrow(parWorld, new BlockPos(new Vec3d((double)myPos.func_177958_n(), (double)(myPos.func_177956_o() - 2), (double)myPos.func_177952_p())), myState)) {
                return true;
            }
        }
        return false;
    }

    private void SetWorldBlock(World myWorld, int x, int y, int z, Block newBlock, int meta, int notify) {
        myWorld.func_175656_a(new BlockPos(new Vec3d((double)x, (double)y, (double)z)), newBlock.func_176223_P());
    }

    private Block GetWorldBlock(World myWorld, int x, int y, int z) {
        return myWorld.func_180495_p(new BlockPos(new Vec3d((double)x, (double)y, (double)z))).func_177230_c();
    }

    @Override
    public String getName() {
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }
}

