/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.blocks;

import CookingPlus.CookingPlusMain;
import CookingPlus.blocks.CookingPlusCustomRenderedBlock;
import CookingPlus.blocks.CookingPlusRopeBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class CookingPlusCustomRopeCrop
extends CookingPlusCustomRenderedBlock
implements IPlantable {
    protected int maxGrowthStage = 7;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    public static final PropertyInteger ROPETYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)3);

    public CookingPlusCustomRopeCrop() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void func_180650_b(World parWorld, BlockPos myPos, IBlockState myState, Random parRand) {
        super.func_180650_b(parWorld, myPos, myState, parRand);
        int growStage = (Integer)myState.func_177229_b((IProperty)AGE);
        if (parRand.nextFloat() > 0.75f) {
            ++growStage;
        }
        if (growStage > 3) {
            this.growCropUp(parWorld, myPos.func_177984_a());
            growStage = 3;
        }
        parWorld.func_180501_a(myPos, myState.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(growStage)), 2);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{ROPETYPE, AGE}, new IUnlistedProperty[]{JAI});
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            return ((IExtendedBlockState)state).withProperty(JAI, (Object)1);
        }
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(meta & 3)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta & 3));
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | (Integer)state.func_177229_b((IProperty)ROPETYPE);
        return i |= (Integer)state.func_177229_b((IProperty)AGE) << 2;
    }

    public void checkRopeStatus(World world, BlockPos myPos) {
        int StateNumber = (Integer)world.func_180495_p(myPos).func_177229_b((IProperty)ROPETYPE);
        boolean hasTop = false;
        boolean hasBottom = false;
        if (this.isRopeBlock(world.func_180495_p(myPos.func_177984_a()).func_177230_c())) {
            hasTop = true;
        }
        if (this.isRopeBlock(world.func_180495_p(myPos.func_177977_b()).func_177230_c())) {
            hasBottom = true;
        }
        if (hasTop && hasBottom) {
            world.func_175656_a(myPos, world.func_180495_p(myPos).func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(1)));
            if (StateNumber != 1) {
                this.updateBlockIfApplicable(world, myPos.func_177984_a());
                this.updateBlockIfApplicable(world, myPos.func_177977_b());
            }
        } else if (hasTop && !hasBottom) {
            world.func_175656_a(myPos, world.func_180495_p(myPos).func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(2)));
            if (StateNumber != 2) {
                this.updateBlockIfApplicable(world, myPos.func_177984_a());
                this.updateBlockIfApplicable(world, myPos.func_177977_b());
            }
        } else if (!hasTop && hasBottom) {
            world.func_175656_a(myPos, world.func_180495_p(myPos).func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(3)));
            if (!this.checkIfBlockAbove(world, myPos)) {
                this.breakRopeBlock(world, myPos);
            }
            if (StateNumber != 3) {
                this.updateBlockIfApplicable(world, myPos.func_177984_a());
                this.updateBlockIfApplicable(world, myPos.func_177977_b());
            }
        } else if (!hasTop && !hasBottom) {
            world.func_175656_a(myPos, world.func_180495_p(myPos).func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(0)));
            if (!this.checkIfBlockAbove(world, myPos)) {
                this.breakRopeBlock(world, myPos);
            }
            if (StateNumber != 0) {
                this.updateBlockIfApplicable(world, myPos.func_177984_a());
                this.updateBlockIfApplicable(world, myPos.func_177977_b());
            }
        }
    }

    public IBlockState getRopeStatus(World world, BlockPos myPos) {
        boolean hasTop = false;
        boolean hasBottom = false;
        if (this.isRopeBlock(world.func_180495_p(myPos.func_177984_a()).func_177230_c())) {
            hasTop = true;
        }
        if (this.isRopeBlock(world.func_180495_p(myPos.func_177977_b()).func_177230_c())) {
            hasBottom = true;
        }
        if (hasTop && hasBottom) {
            return this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(1));
        }
        if (hasTop && !hasBottom) {
            return this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(2));
        }
        if (!hasTop && hasBottom) {
            return this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(3));
        }
        return this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(0));
    }

    public boolean isRopeBlock(Block myBlock) {
        if (myBlock.equals(CookingPlusMain.blockRope)) {
            return true;
        }
        if (myBlock.equals(CookingPlusMain.blockGrapeCrop)) {
            return true;
        }
        if (myBlock.equals(CookingPlusMain.blockHopCrop)) {
            return true;
        }
        return myBlock.equals(CookingPlusMain.blockVanillaCrop);
    }

    protected boolean checkIfBlockAbove(World worldIn, BlockPos myPos) {
        return worldIn.func_180495_p(myPos.func_177984_a()).func_177230_c() != null && !worldIn.func_180495_p(myPos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, myPos.func_177984_a());
    }

    protected void breakRopeBlock(World worldIn, BlockPos myPos) {
        CookingPlusCustomRopeCrop.func_180635_a((World)worldIn, (BlockPos)myPos, (ItemStack)new ItemStack(Item.func_150898_a((Block)CookingPlusMain.blockRope)));
        CookingPlusCustomRopeCrop.func_180635_a((World)worldIn, (BlockPos)myPos, (ItemStack)new ItemStack(this.GetSeedItem()));
        if ((Integer)worldIn.func_180495_p(myPos).func_177229_b((IProperty)AGE) == 3) {
            CookingPlusCustomRopeCrop.func_180635_a((World)worldIn, (BlockPos)myPos, (ItemStack)new ItemStack(this.GetCropItem()));
        }
        worldIn.func_175698_g(myPos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateBlockIfApplicable(worldIn, pos.func_177984_a());
        this.updateBlockIfApplicable(worldIn, pos.func_177977_b());
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getRopeStatus(worldIn, pos);
    }

    protected void updateBlockIfApplicable(World world, BlockPos pos) {
        Block myBlock = world.func_180495_p(pos).func_177230_c();
        if (myBlock.equals(CookingPlusMain.blockRope)) {
            ((CookingPlusRopeBlock)world.func_180495_p(pos).func_177230_c()).checkRopeStatus(world, pos);
        }
        if (myBlock instanceof CookingPlusCustomRopeCrop) {
            ((CookingPlusCustomRopeCrop)world.func_180495_p(pos).func_177230_c()).checkRopeStatus(world, pos);
        }
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.updateBlockIfApplicable(worldIn, pos.func_177984_a());
        this.updateBlockIfApplicable(worldIn, pos.func_177977_b());
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.updateBlockIfApplicable(worldIn, pos.func_177984_a());
        this.updateBlockIfApplicable(worldIn, pos.func_177977_b());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().equals(CookingPlusMain.blockRope)) {
            int myRope = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)ROPETYPE);
            worldIn.func_175656_a(pos, CookingPlusMain.blockRope.func_176223_P().func_177226_a((IProperty)CookingPlusRopeBlock.ROPETYPE, (Comparable)Integer.valueOf(myRope)));
        } else if (!worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().equals(this.GetCropBlock()) && !worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_150458_ak)) {
            int myRope = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)ROPETYPE);
            worldIn.func_175656_a(pos, CookingPlusMain.blockRope.func_176223_P().func_177226_a((IProperty)CookingPlusRopeBlock.ROPETYPE, (Comparable)Integer.valueOf(myRope)));
        }
        this.checkRopeStatus(worldIn, pos);
    }

    public void growCropUp(World myWorld, BlockPos myPos) {
        if (myWorld.func_180495_p(myPos).func_177230_c() != null && myWorld.func_180495_p(myPos).func_177230_c().equals(CookingPlusMain.blockRope)) {
            int myRope = (Integer)myWorld.func_180495_p(myPos).func_177229_b((IProperty)CookingPlusRopeBlock.ROPETYPE);
            myWorld.func_175656_a(myPos, this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(myRope)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        }
    }

    public Item GetCropItem() {
        return null;
    }

    public Item GetSeedItem() {
        return null;
    }

    protected Block GetCropBlock() {
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && (Integer)state.func_177229_b((IProperty)AGE) >= 3) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)), 2);
            playerIn.func_71019_a(new ItemStack(this.GetCropItem()), false);
        }
        return true;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos myPos, IBlockState myState, int fortune) {
        List ret = super.getDrops(world, myPos, myState, fortune);
        ret.clear();
        int growStage = (Integer)myState.func_177229_b((IProperty)AGE);
        ret.add(new ItemStack(this.GetSeedItem(), 1, 0));
        ret.add(new ItemStack(CookingPlusMain.blockRope, 1, 0));
        if (growStage >= 3) {
            ret.add(new ItemStack(this.GetCropItem(), 1, 0));
        }
        return ret;
    }
}

