/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.blocks;

import CookingPlus.CookingPlusMain;
import CookingPlus.blocks.CookingPlusCustomBlock;
import CookingPlus.blocks.CookingPlusCustomRopeCrop;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CookingPlusRopeBlock
extends CookingPlusCustomBlock {
    private final String name = "rope";
    public static final PropertyInteger ROPETYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)3);

    public CookingPlusRopeBlock() {
        super(Material.field_151585_k);
        GameRegistry.registerBlock((Block)this, (String)"rope");
        this.func_149663_c("rope");
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.setBlockBounds(0.4f, 0.0f, 0.4f, 0.6f, 1.0f, 0.6f);
        this.func_149713_g(0);
    }

    @Override
    public String getName() {
        return "rope";
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean isFullCube() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(new BlockPos(new Vec3d((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p()))).func_177230_c() != null && !worldIn.func_180495_p(new BlockPos(new Vec3d((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p()))).func_177230_c().func_176200_f((IBlockAccess)worldIn, new BlockPos(new Vec3d((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p())));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)ROPETYPE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROPETYPE});
    }

    public void checkRopeStatus(World world, BlockPos myPos) {
        int StateNumber = (Integer)world.func_180495_p(myPos).func_177229_b((IProperty)ROPETYPE);
        boolean hasTop = false;
        boolean hasBottom = false;
        if (this.isRopeBlock(world.func_180495_p(myPos.func_177984_a()).func_177230_c())) {
            hasTop = true;
        }
        if (this.isRopeBlock(world.func_180495_p(myPos.func_177977_b()).func_177230_c())) {
            hasBottom = true;
        }
        if (hasTop && hasBottom) {
            world.func_175656_a(myPos, this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(1)));
            if (StateNumber != 1) {
                this.updateBlockIfApplicable(world, myPos.func_177984_a());
                this.updateBlockIfApplicable(world, myPos.func_177977_b());
            }
        } else if (hasTop && !hasBottom) {
            world.func_175656_a(myPos, this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(2)));
            if (StateNumber != 2) {
                this.updateBlockIfApplicable(world, myPos.func_177984_a());
                this.updateBlockIfApplicable(world, myPos.func_177977_b());
            }
        } else if (!hasTop && hasBottom) {
            world.func_175656_a(myPos, this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(3)));
            if (!this.checkIfBlockAbove(world, myPos)) {
                this.breakRopeBlock(world, myPos);
            }
            if (StateNumber != 3) {
                this.updateBlockIfApplicable(world, myPos.func_177984_a());
                this.updateBlockIfApplicable(world, myPos.func_177977_b());
            }
        } else if (!hasTop && !hasBottom) {
            world.func_175656_a(myPos, this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(0)));
            if (!this.checkIfBlockAbove(world, myPos)) {
                this.breakRopeBlock(world, myPos);
            }
            if (StateNumber != 0) {
                this.updateBlockIfApplicable(world, myPos.func_177984_a());
                this.updateBlockIfApplicable(world, myPos.func_177977_b());
            }
        }
    }

    public IBlockState getRopeStatus(World world, BlockPos myPos) {
        boolean hasTop = false;
        boolean hasBottom = false;
        if (this.isRopeBlock(world.func_180495_p(myPos.func_177984_a()).func_177230_c())) {
            hasTop = true;
        }
        if (this.isRopeBlock(world.func_180495_p(myPos.func_177977_b()).func_177230_c())) {
            hasBottom = true;
        }
        if (hasTop && hasBottom) {
            return this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(1));
        }
        if (hasTop && !hasBottom) {
            return this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(2));
        }
        if (!hasTop && hasBottom) {
            return this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(3));
        }
        return this.func_176223_P().func_177226_a((IProperty)ROPETYPE, (Comparable)Integer.valueOf(0));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getRopeStatus(worldIn, pos);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkRopeStatus(worldIn, pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateBlockIfApplicable(worldIn, pos.func_177984_a());
        this.updateBlockIfApplicable(worldIn, pos.func_177977_b());
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.updateBlockIfApplicable(worldIn, pos.func_177984_a());
        this.updateBlockIfApplicable(worldIn, pos.func_177977_b());
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.updateBlockIfApplicable(worldIn, pos.func_177984_a());
        this.updateBlockIfApplicable(worldIn, pos.func_177977_b());
    }

    protected boolean checkIfBlockAbove(World worldIn, BlockPos myPos) {
        return worldIn.func_180495_p(myPos.func_177984_a()).func_177230_c() != null && !worldIn.func_180495_p(myPos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, myPos.func_177984_a());
    }

    protected void breakRopeBlock(World worldIn, BlockPos myPos) {
        this.func_176226_b(worldIn, myPos, this.func_176223_P(), 0);
        worldIn.func_175698_g(myPos);
    }

    public boolean isRopeBlock(Block myBlock) {
        if (myBlock.equals(CookingPlusMain.blockRope)) {
            return true;
        }
        if (myBlock.equals(CookingPlusMain.blockGrapeCrop)) {
            return true;
        }
        if (myBlock.equals(CookingPlusMain.blockHopCrop)) {
            return true;
        }
        return myBlock.equals(CookingPlusMain.blockVanillaCrop);
    }

    protected void updateBlockIfApplicable(World world, BlockPos pos) {
        Block myBlock = world.func_180495_p(pos).func_177230_c();
        if (myBlock.equals(CookingPlusMain.blockRope)) {
            ((CookingPlusRopeBlock)world.func_180495_p(pos).func_177230_c()).checkRopeStatus(world, pos);
        }
        if (myBlock instanceof CookingPlusCustomRopeCrop) {
            ((CookingPlusCustomRopeCrop)world.func_180495_p(pos).func_177230_c()).checkRopeStatus(world, pos);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        this.checkRopeStatus(worldIn, pos);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }
}

