/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.blocks.tileentity;

import CookingPlus.CookingPlusMain;
import CookingPlus.blocks.tileentity.CookingPlusCustomTileEntityBlock;
import CookingPlus.tiles.DryingRackTileEntity;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CookingPlusDryingRackBlock
extends CookingPlusCustomTileEntityBlock {
    protected static final AxisAlignedBB PISTON_BASE_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.6f, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_BASE_WEST_AABB = new AxisAlignedBB((double)0.4f, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_BASE_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.6f);
    protected static final AxisAlignedBB PISTON_BASE_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, (double)0.4f, 1.0, 1.0, 1.0);
    private final String name = "dryingrack";
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public CookingPlusDryingRackBlock() {
        super(Material.field_151575_d);
        this.func_149663_c("dryingrack");
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_149711_c(2.0f);
        this.func_149752_b(6.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149713_g(0);
        GameRegistry.registerBlock((Block)this, (String)"dryingrack");
    }

    @Override
    public int getRenderType() {
        return -1;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isFullCube() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new DryingRackTileEntity();
    }

    public void func_176206_d(World world, BlockPos myPos, IBlockState myState) {
        super.func_176206_d(world, myPos, myState);
    }

    public void func_180652_a(World world, BlockPos myPos, Explosion p_149664_5_) {
        super.func_180652_a(world, myPos, p_149664_5_);
    }

    public void func_180633_a(World worldIn, BlockPos myPos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        BlockPos blockpos1 = myPos.func_177978_c();
        BlockPos blockpos2 = myPos.func_177968_d();
        BlockPos blockpos3 = myPos.func_177976_e();
        BlockPos blockpos4 = myPos.func_177974_f();
        boolean flag = this == worldIn.func_180495_p(blockpos1).func_177230_c();
        boolean flag1 = this == worldIn.func_180495_p(blockpos2).func_177230_c();
        boolean flag2 = this == worldIn.func_180495_p(blockpos3).func_177230_c();
        boolean flag3 = this == worldIn.func_180495_p(blockpos4).func_177230_c();
        TileEntity tileentity = worldIn.func_175625_s(myPos);
        if (!(flag || flag1 || flag2 || flag3)) {
            worldIn.func_180501_a(myPos, state, 3);
        } else if (enumfacing.func_176740_k() == EnumFacing.Axis.X && (flag || flag1)) {
            if (flag) {
                worldIn.func_180501_a(blockpos1, state, 3);
            } else {
                worldIn.func_180501_a(blockpos2, state, 3);
            }
            worldIn.func_180501_a(myPos, state, 3);
        } else if (enumfacing.func_176740_k() == EnumFacing.Axis.Z && (flag2 || flag3)) {
            if (flag2) {
                worldIn.func_180501_a(blockpos3, state, 3);
            } else {
                worldIn.func_180501_a(blockpos4, state, 3);
            }
            worldIn.func_180501_a(myPos, state, 3);
        }
        if (tileentity instanceof DryingRackTileEntity) {
            if (enumfacing == EnumFacing.EAST) {
                ((DryingRackTileEntity)tileentity).setDirection(5);
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.6f, 1.0f, 1.0f);
            }
            if (enumfacing == EnumFacing.SOUTH) {
                ((DryingRackTileEntity)tileentity).setDirection(3);
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.6f);
            }
            if (enumfacing == EnumFacing.WEST) {
                ((DryingRackTileEntity)tileentity).setDirection(4);
                this.setBlockBounds(0.4f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
            if (enumfacing == EnumFacing.NORTH) {
                ((DryingRackTileEntity)tileentity).setDirection(2);
                this.setBlockBounds(0.0f, 0.0f, 0.4f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof DryingRackTileEntity) {
            DryingRackTileEntity MyMarketBox = (DryingRackTileEntity)worldIn.func_175625_s(pos);
            MyMarketBox.processActivate(playerIn);
        }
        return true;
    }

    private void SetWorldBlock(World myWorld, int x, int y, int z, Block newBlock, int meta, int notify) {
        myWorld.func_175656_a(new BlockPos(new Vec3d((double)x, (double)y, (double)z)), newBlock.func_176223_P());
    }

    private Block GetWorldBlock(World myWorld, int x, int y, int z) {
        return myWorld.func_180495_p(new BlockPos(new Vec3d((double)x, (double)y, (double)z))).func_177230_c();
    }

    @Override
    public String GetName() {
        return "dryingrack";
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos myPos, IBlockState myState, int fortune) {
        List ret = super.getDrops(world, myPos, myState, fortune);
        ret.clear();
        ret.add(new ItemStack(Item.func_150898_a((Block)CookingPlusMain.blockDryingRack), 1, 0));
        if (world.func_175625_s(myPos) != null) {
            ItemStack[] TempArray = ((DryingRackTileEntity)world.func_175625_s(myPos)).GetItems();
            for (int i = 0; i < TempArray.length; ++i) {
                if (TempArray[i] == null) continue;
                ret.add(TempArray[i].func_77946_l());
            }
            world.func_175625_s(myPos).func_145843_s();
        }
        return ret;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof DryingRackTileEntity) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((DryingRackTileEntity)tileentity));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess worldIn, BlockPos pos) {
        int meta = ((EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_176745_a();
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof DryingRackTileEntity) {
            if (meta == 5) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.6f, 1.0f, 1.0f);
                ((DryingRackTileEntity)tileentity).setDirection(5);
            }
            if (meta == 3) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.6f);
                ((DryingRackTileEntity)tileentity).setDirection(3);
            }
            if (meta == 4) {
                this.setBlockBounds(0.4f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                ((DryingRackTileEntity)tileentity).setDirection(4);
            }
            if (meta == 2) {
                this.setBlockBounds(0.0f, 0.0f, 0.4f, 1.0f, 1.0f, 1.0f);
                ((DryingRackTileEntity)tileentity).setDirection(2);
            }
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            return PISTON_BASE_NORTH_AABB;
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return PISTON_BASE_SOUTH_AABB;
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            return PISTON_BASE_WEST_AABB;
        }
        return PISTON_BASE_EAST_AABB;
    }
}

