/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.generation;

import CookingPlus.CookingPlusConfig;
import CookingPlus.CookingPlusMain;
import CookingPlus.blocks.CookingPlusCustomSpreadingCoral;
import CookingPlus.blocks.CookingPlusCustomUnderwaterPlant;
import CookingPlus.generation.CookingPlusCoralReefBiome;
import CookingPlus.generation.CookingPlusDeepReefBiome;
import CookingPlus.generation.CookingPlusKelpForestBiome;
import CookingPlus.prebuiltstructures.CookingPlusPreBuiltShipFront;
import CookingPlus.prebuiltstructures.CookingPlusPreBuiltSphereCoral;
import CookingPlus.prebuiltstructures.CookingPlusPreBuiltSpikyCoral;
import CookingPlus.prebuiltstructures.CookingPlusPreBuiltStructure;
import CookingPlus.prebuiltstructures.CookingPlusUnderwaterTempleStructure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeBeach;
import net.minecraft.world.biome.BiomeOcean;

public class CookingPlusUnderwaterGen {
    static void GenerateUnderwaterStructures(World worldIn, Random randIn, int ChunkX, int ChunkZ) {
        int y;
        int z;
        int x;
        Biome biome = worldIn.func_180494_b(new BlockPos(new Vec3d((double)(ChunkX * 16 + 8), 0.0, (double)(ChunkZ * 16 + 8))));
        if (biome instanceof BiomeOcean || biome instanceof BiomeBeach) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    if (CookingPlusConfig.SeaweedSpawnRate == 0 || randIn.nextInt(CookingPlusConfig.SeaweedSpawnRate) != 0) continue;
                    if (randIn.nextInt(50) > 48) {
                        y = worldIn.func_175672_r(new BlockPos(new Vec3d((double)(ChunkX * 16 + x), 0.0, (double)(ChunkZ * 16 + z)))).func_177956_o();
                        CookingPlusUnderwaterGen.GenerateUnderwaterGrowingPlant(worldIn, ChunkX * 16 + x, y, ChunkZ * 16 + z, randIn, 2, 5, CookingPlusMain.blockKelpCrop);
                        continue;
                    }
                    y = worldIn.func_175672_r(new BlockPos(new Vec3d((double)(ChunkX * 16 + x), 0.0, (double)(ChunkZ * 16 + z)))).func_177956_o();
                    CookingPlusUnderwaterGen.GenerateUnderwaterGrowingPlant(worldIn, ChunkX * 16 + x, y, ChunkZ * 16 + z, randIn, 2, 5, CookingPlusMain.blockSeaweedCrop);
                }
            }
        }
        if (biome instanceof CookingPlusKelpForestBiome) {
            int y2;
            int z2;
            int x2;
            int mx = ChunkX * 16 + randIn.nextInt(16);
            int mz = ChunkZ * 16 + randIn.nextInt(16);
            int my = worldIn.func_175672_r(new BlockPos(new Vec3d((double)mx, 0.0, (double)mz))).func_177956_o();
            if (CookingPlusConfig.TempleSpawnRate != 0 && randIn.nextInt(CookingPlusConfig.TempleSpawnRate) == 0) {
                CookingPlusUnderwaterTempleStructure myTempStructure = new CookingPlusUnderwaterTempleStructure();
                ((CookingPlusPreBuiltStructure)myTempStructure).Generate(worldIn, mx, my + 1, mz, true, 0, randIn);
            }
            for (x2 = 0; x2 < 16; ++x2) {
                for (z2 = 0; z2 < 16; ++z2) {
                    if (randIn.nextInt(2) != 0) continue;
                    y2 = worldIn.func_175672_r(new BlockPos(new Vec3d((double)(ChunkX * 16 + x2), 0.0, (double)(ChunkZ * 16 + z2)))).func_177956_o();
                    CookingPlusUnderwaterGen.GenerateUnderwaterGrowingPlant(worldIn, ChunkX * 16 + x2, y2, ChunkZ * 16 + z2, randIn, 2, 5, CookingPlusMain.blockKelpCrop);
                }
            }
            x2 = ChunkX * 16 + randIn.nextInt(16);
            z2 = ChunkZ * 16 + randIn.nextInt(16);
            y2 = worldIn.func_175672_r(new BlockPos(new Vec3d((double)x2, 0.0, (double)z2))).func_177956_o();
            if (CookingPlusConfig.ShipWreckSpawnRate != 0 && randIn.nextInt(CookingPlusConfig.ShipWreckSpawnRate) == 0 && y2 < 53) {
                CookingPlusPreBuiltShipFront myTempStructure = new CookingPlusPreBuiltShipFront();
                myTempStructure.Generate(worldIn, x2, y2, z2, true, 0, randIn);
            }
        }
        if (biome instanceof CookingPlusCoralReefBiome) {
            x = ChunkX * 16 + randIn.nextInt(16);
            z = ChunkZ * 16 + randIn.nextInt(16);
            y = worldIn.func_175672_r(new BlockPos(new Vec3d((double)x, 0.0, (double)z))).func_177956_o();
            if (randIn.nextInt(4) == 0) {
                if (CookingPlusConfig.TempleSpawnRate != 0) {
                    if (randIn.nextInt(CookingPlusConfig.TempleSpawnRate) == 0) {
                        CookingPlusUnderwaterTempleStructure myTempStructure = new CookingPlusUnderwaterTempleStructure();
                        ((CookingPlusPreBuiltStructure)myTempStructure).Generate(worldIn, x, y + 1, z, true, 0, randIn);
                    } else {
                        CookingPlusUnderwaterGen.GeneratePatch(worldIn, randIn, new BlockPos(new Vec3d((double)x, (double)y, (double)z)), 20, CookingPlusMain.blockCoralRock);
                    }
                } else {
                    CookingPlusUnderwaterGen.GeneratePatch(worldIn, randIn, new BlockPos(new Vec3d((double)x, (double)y, (double)z)), 20, CookingPlusMain.blockCoralRock);
                }
            } else {
                CookingPlusUnderwaterGen.GenerateCoralReef(worldIn, x, y, z, randIn, 10, 35, CookingPlusMain.blockCoralRock, CookingPlusMain.blockCoralRock, randIn.nextInt(5));
            }
            x = ChunkX * 16 + randIn.nextInt(16);
            z = ChunkZ * 16 + randIn.nextInt(16);
            y = worldIn.func_175672_r(new BlockPos(new Vec3d((double)x, 0.0, (double)z))).func_177956_o();
            if (CookingPlusConfig.ShipWreckSpawnRate != 0 && randIn.nextInt(CookingPlusConfig.ShipWreckSpawnRate) == 0 && y < 53) {
                CookingPlusPreBuiltShipFront myTempStructure = new CookingPlusPreBuiltShipFront();
                myTempStructure.Generate(worldIn, x, y, z, true, 0, randIn);
            }
            CookingPlusUnderwaterGen.AddCoral(worldIn, randIn, ChunkX, ChunkZ);
        }
        if (biome instanceof CookingPlusDeepReefBiome) {
            x = ChunkX * 16 + randIn.nextInt(16);
            z = ChunkZ * 16 + randIn.nextInt(16);
            y = worldIn.func_175672_r(new BlockPos(new Vec3d((double)x, 0.0, (double)z))).func_177956_o();
            CookingPlusUnderwaterGen.GeneratePatch(worldIn, randIn, new BlockPos(new Vec3d((double)x, (double)y, (double)z)), 20, CookingPlusMain.blockCoralRock);
            if (CookingPlusConfig.UnderwaterVentSpawnRate != 0) {
                if (randIn.nextInt(CookingPlusConfig.UnderwaterVentSpawnRate) == 0) {
                    CookingPlusUnderwaterGen.GenerateVent(worldIn, x, y, z, randIn);
                } else {
                    CookingPlusUnderwaterGen.AddGiantCorals(CookingPlusConfig.GiantCoralDensity, ChunkX, ChunkZ, worldIn, randIn);
                }
            } else {
                CookingPlusUnderwaterGen.AddGiantCorals(CookingPlusConfig.GiantCoralDensity, ChunkX, ChunkZ, worldIn, randIn);
            }
            CookingPlusUnderwaterGen.AddCoral(worldIn, randIn, ChunkX, ChunkZ);
        }
    }

    static void GenerateUnderwaterGrowingPlant(World worldIn, int x, int y, int z, Random randIn, int min, int max, Block myBlock) {
        if (myBlock.func_176196_c(worldIn, new BlockPos(new Vec3d((double)x, (double)y, (double)z)))) {
            int Height = randIn.nextInt(max - min) + min;
            for (int i = 0; i < Height; ++i) {
                if (!myBlock.func_176196_c(worldIn, new BlockPos(new Vec3d((double)x, (double)(y + i), (double)z)))) continue;
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(y + i), (double)z)), myBlock.func_176223_P());
            }
        }
    }

    static void GenerateCoralReef(World worldIn, int x, int y, int z, Random randIn, int min, int max, Block myBlock, Block BaseBlock, int heightBelowSea) {
        CookingPlusUnderwaterGen.GeneratePatch(worldIn, randIn, new BlockPos(new Vec3d((double)x, (double)y, (double)z)), 20, BaseBlock);
        float prevWidthX = 6.0f;
        float prevWidthZ = 4.0f;
        boolean SizeState = false;
        for (int myY = 0; myY < max; ++myY) {
            if (worldIn.func_180495_p(new BlockPos(new Vec3d((double)x, (double)(y + myY + 2 + heightBelowSea), (double)z))).func_177230_c() == Blocks.field_150355_j) {
                for (int myX = -7; myX < 7; ++myX) {
                    for (int myZ = -7; myZ < 7; ++myZ) {
                        if (!((float)myX / prevWidthX * ((float)myX / prevWidthX) + (float)myZ / prevWidthZ * ((float)myZ / prevWidthZ) <= 2.0f)) continue;
                        worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + myX), (double)(y + myY), (double)(z + myZ))), myBlock.func_176223_P());
                        if (randIn.nextInt(3) != 0) continue;
                        CookingPlusUnderwaterGen.AddCoralBlock(worldIn, CookingPlusUnderwaterGen.getCoralBlock(randIn), new BlockPos(new Vec3d((double)(x + myX), (double)(y + myY + 1), (double)(z + myZ))));
                    }
                }
            } else {
                myY = max + 1;
            }
            if (prevWidthX >= 6.0f || prevWidthZ >= 6.0f) {
                SizeState = true;
            }
            if (prevWidthX <= 1.0f || prevWidthZ <= 1.0f) {
                SizeState = false;
            }
            if (!SizeState) {
                prevWidthX += (float)(randIn.nextInt(2) + 1);
                prevWidthZ += (float)(randIn.nextInt(2) + 1);
            }
            if (SizeState) {
                prevWidthX -= (float)(randIn.nextInt(2) + 1);
                prevWidthZ -= (float)(randIn.nextInt(2) + 1);
            }
            if (prevWidthX > 6.0f) {
                prevWidthX = 6.0f;
            }
            if (prevWidthZ > 6.0f) {
                prevWidthZ = 6.0f;
            }
            if (prevWidthZ < 1.0f) {
                prevWidthZ = 1.0f;
            }
            if (!(prevWidthX < 1.0f)) continue;
            prevWidthX = 1.0f;
        }
    }

    static void GeneratePatch(World worldIn, Random p_180709_2_, BlockPos p_180709_3_, int radius, Block myBlock) {
        int i = p_180709_2_.nextInt(radius - 2) + 2;
        int b0 = 2;
        for (int j = p_180709_3_.func_177958_n() - i; j <= p_180709_3_.func_177958_n() + i; ++j) {
            for (int k = p_180709_3_.func_177952_p() - i; k <= p_180709_3_.func_177952_p() + i; ++k) {
                int i1;
                int l = j - p_180709_3_.func_177958_n();
                if (l * l + (i1 = k - p_180709_3_.func_177952_p()) * i1 > i * i) continue;
                for (int j1 = p_180709_3_.func_177956_o() - b0; j1 <= p_180709_3_.func_177956_o() + b0; ++j1) {
                    BlockPos blockpos1 = new BlockPos(j, j1, k);
                    if (!worldIn.func_175726_f(blockpos1).func_177419_t()) continue;
                    Block block = worldIn.func_180495_p(blockpos1).func_177230_c();
                    if (blockpos1.func_177956_o() >= 62 || block == Blocks.field_150355_j || block == Blocks.field_150350_a || block instanceof CookingPlusCustomUnderwaterPlant || block != Blocks.field_150354_m && block != Blocks.field_150346_d && block != Blocks.field_150348_b && block != Blocks.field_150351_n && block != CookingPlusMain.blockCoralRock) continue;
                    worldIn.func_180501_a(blockpos1, myBlock.func_176223_P(), 2);
                }
            }
        }
    }

    static void AddCoral(World worldIn, Random randIn, int ChunkX, int ChunkZ) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (randIn.nextInt(3) != 0) continue;
                int y = worldIn.func_175672_r(new BlockPos(new Vec3d((double)(ChunkX * 16 + x), 0.0, (double)(ChunkZ * 16 + z)))).func_177956_o();
                Block CoralBlock = CookingPlusUnderwaterGen.getCoralBlock(randIn);
                if (!((CookingPlusCustomSpreadingCoral)CoralBlock).canBlockStay(worldIn, new BlockPos(new Vec3d((double)(ChunkX * 16 + x), (double)y, (double)(ChunkZ * 16 + z))))) continue;
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(ChunkX * 16 + x), (double)y, (double)(ChunkZ * 16 + z))), CoralBlock.func_176223_P());
            }
        }
    }

    static void AddCoralBlock(World worldIn, Block CoralBlock, BlockPos myPos) {
        worldIn.func_175656_a(myPos, CoralBlock.func_176223_P());
    }

    static Block getCoralBlock(Random randIn) {
        int which = randIn.nextInt(7);
        if (which == 0) {
            return CookingPlusMain.blockWhiteCoral;
        }
        if (which == 1) {
            return CookingPlusMain.blockGreenCoral;
        }
        if (which == 2) {
            return CookingPlusMain.blockRedCoral;
        }
        if (which == 3) {
            return CookingPlusMain.blockBlueCoral;
        }
        if (which == 4) {
            return CookingPlusMain.blockBlackCoral;
        }
        if (which == 5) {
            return CookingPlusMain.blockOrangeCoral;
        }
        if (which == 6) {
            return CookingPlusMain.blockYellowCoral;
        }
        return null;
    }

    static void GenerateVent(World worldIn, int x, int y, int z, Random randIn) {
        boolean done = false;
        int myY = y;
        int layer = randIn.nextInt(12);
        BlockStaticLiquid myFillingBlock = Blocks.field_150353_l;
        if (randIn.nextInt(2) == 0) {
            myFillingBlock = CookingPlusMain.blockHydrothermal;
        }
        while (!done) {
            if (layer < 4) {
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 4), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 4), (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 4), (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 4), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 4), (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 4), (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 4))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 4))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 4))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 4))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 4))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 4))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z - 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z - 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z + 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z + 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)myY, (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)myY, (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)myY, (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)myY, (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z + 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z + 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z + 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z - 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z - 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z - 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)(myY + 1), (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)(myY + 1), (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)(myY + 1), (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)(myY + 1), (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 3))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 3))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 3))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 3))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 3))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 3))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z - 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z + 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z - 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z + 2))), myFillingBlock.func_176223_P());
            }
            if (layer >= 4 && layer < 6) {
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 4), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 4), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 4))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 4))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z + 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z - 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 3))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 3))), myFillingBlock.func_176223_P());
            }
            if (layer >= 6 && layer < 10) {
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 3), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 3), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 3))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 2))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 2))), myFillingBlock.func_176223_P());
            }
            if (layer >= 10 && layer < 13) {
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)z)), myFillingBlock.func_176223_P());
            }
            if (layer >= 13 && layer < 15) {
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 2), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 2), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 2))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)z)), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 1))), myFillingBlock.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 1))), myFillingBlock.func_176223_P());
            }
            if (layer >= 15 && layer < 18) {
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x + 1), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)(x - 1), (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z + 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)(z - 1))), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)(myY + 1), (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)z)), myFillingBlock.func_176223_P());
            }
            if (layer >= 18 && layer < 21) {
                worldIn.func_175656_a(new BlockPos(new Vec3d((double)x, (double)myY, (double)z)), CookingPlusMain.blockBasalt.func_176223_P());
            }
            if (layer > 20) {
                done = true;
                continue;
            }
            ++layer;
            ++myY;
        }
    }

    static void AddGiantCorals(int Attempts, int chunkX, int chunkZ, World worldIn, Random randIn) {
        for (int i = 0; i < Attempts; ++i) {
            CookingPlusPreBuiltStructure myTempStructure;
            int z;
            int y;
            int x = chunkX * 16 + randIn.nextInt(16);
            if (worldIn.func_180495_p(new BlockPos(new Vec3d((double)x, (double)((y = worldIn.func_175672_r(new BlockPos(new Vec3d((double)x, 0.0, (double)(z = chunkZ * 16 + randIn.nextInt(16))))).func_177956_o()) - 1), (double)z))).func_177230_c() != CookingPlusMain.blockCoralRock) continue;
            if (randIn.nextInt(3) == 0) {
                myTempStructure = new CookingPlusPreBuiltSphereCoral(CookingPlusUnderwaterGen.GetRandomCoralBlock(randIn));
                myTempStructure.Generate(worldIn, x, y, z, true, 0, randIn);
                continue;
            }
            myTempStructure = new CookingPlusPreBuiltSpikyCoral(CookingPlusUnderwaterGen.GetRandomCoralBlock(randIn));
            myTempStructure.Generate(worldIn, x, y, z, 3, 3, 0, randIn);
        }
    }

    static Block GetRandomCoralBlock(Random randIn) {
        int which = randIn.nextInt(7);
        if (which == 0) {
            return CookingPlusMain.blockYellowCoralBlock;
        }
        if (which == 1) {
            return CookingPlusMain.blockBlueCoralBlock;
        }
        if (which == 2) {
            return CookingPlusMain.blockRedCoralBlock;
        }
        if (which == 3) {
            return CookingPlusMain.blockGreenCoralBlock;
        }
        if (which == 4) {
            return CookingPlusMain.blockOrangeCoralBlock;
        }
        if (which == 5) {
            return CookingPlusMain.blockWhiteCoralBlock;
        }
        return CookingPlusMain.blockBlackCoralBlock;
    }
}

