/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.generation;

import CookingPlus.CookingPlusConfig;
import CookingPlus.CookingPlusLootHelper;
import CookingPlus.CookingPlusMain;
import CookingPlus.blocks.CookingPlusCustomLeaves;
import CookingPlus.generation.CookingPlusNetherGen;
import CookingPlus.generation.CookingPlusOrchardBiome;
import CookingPlus.generation.CookingPlusTropicalBiome;
import CookingPlus.generation.CookingPlusUnderwaterGen;
import CookingPlus.prebuiltstructures.CookingPlusPreBuiltTropicalHut;
import CookingPlus.prebuiltstructures.CookingPlusPrebuiltFarmhouse;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class CookingPlusWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                CookingPlusNetherGen.GenerateNetherStructures(world, random, chunkX, chunkZ);
                break;
            }
            case 0: {
                int z;
                int x;
                Biome biome;
                Biome biome2;
                int mz;
                int mx;
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                if (CookingPlusConfig.AbandonedFarmHouseSpawnRate != 0 && random.nextInt(CookingPlusConfig.AbandonedFarmHouseSpawnRate) == 0) {
                    mx = chunkX * 16 + random.nextInt(16);
                    mz = chunkZ * 16 + random.nextInt(16);
                    int my = world.func_175672_r(new BlockPos(new Vec3d((double)mx, 0.0, (double)mz))).func_177956_o();
                    biome2 = world.func_180494_b(new BlockPos(new Vec3d((double)mx, 0.0, (double)mz)));
                    Block CheckBlock = world.func_180495_p(new BlockPos(mx, my - 1, mz)).func_177230_c();
                    if (BiomeDictionary.isBiomeOfType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.isBiomeOfType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) || BiomeDictionary.isBiomeOfType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH) || BiomeDictionary.isBiomeOfType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.isBiomeOfType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                        if (CheckBlock == Blocks.field_150349_c || CheckBlock == Blocks.field_150348_b || CheckBlock == Blocks.field_150346_d) {
                            CookingPlusPrebuiltFarmhouse myTempStructure = new CookingPlusPrebuiltFarmhouse();
                            myTempStructure.Generate(world, mx, my, mz, true, 0, random);
                        } else if (CheckBlock == Blocks.field_150362_t || CheckBlock == Blocks.field_150329_H || CheckBlock instanceof CookingPlusCustomLeaves) {
                            boolean done = false;
                            for (int i = my; i > 0 && !done; --i) {
                                Block myCheckBloc = world.func_180495_p(new BlockPos(new Vec3d((double)mx, (double)i, (double)mz))).func_177230_c();
                                if (myCheckBloc != Blocks.field_150349_c && CheckBlock != Blocks.field_150346_d) continue;
                                CookingPlusPrebuiltFarmhouse myTempStructure = new CookingPlusPrebuiltFarmhouse();
                                myTempStructure.Generate(world, mx, i, mz, true, 0, random);
                            }
                        }
                    }
                }
                if (CookingPlusConfig.UnderwaterVentSpawnRate != 0 && random.nextInt(CookingPlusConfig.UnderwaterVentSpawnRate) == 0) {
                    mx = chunkX * 16 + random.nextInt(16);
                    mz = chunkZ * 16 + random.nextInt(16);
                    Biome biome3 = world.func_180494_b(new BlockPos(new Vec3d((double)mx, 0.0, (double)mz)));
                    Block CheckBlock = world.func_180495_p(new BlockPos(mx, 1, mz)).func_177230_c();
                    if (!BiomeDictionary.isBiomeOfType((Biome)biome3, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) && !BiomeDictionary.isBiomeOfType((Biome)biome3, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                        CookingPlusUnderwaterGen.GenerateVent(world, mx, 1, mz, random);
                    }
                }
                if (CookingPlusConfig.BushSpawnRate != 0 && random.nextInt(CookingPlusConfig.BushSpawnRate) == 0 && (BiomeDictionary.isBiomeOfType((Biome)(biome = world.func_180494_b(new BlockPos(new Vec3d((double)(x = chunkX * 16 + random.nextInt(16)), 0.0, (double)(z = chunkZ * 16 + random.nextInt(16)))))), (BiomeDictionary.Type)BiomeDictionary.Type.LUSH) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS))) {
                    this.SpawnBushes(world, random, x, z);
                }
                if (CookingPlusConfig.HerbSpawnRate != 0 && random.nextInt(CookingPlusConfig.HerbSpawnRate) == 0) {
                    x = chunkX * 16 + random.nextInt(16);
                    z = chunkZ * 16 + random.nextInt(16);
                    int y = world.func_175672_r(new BlockPos(new Vec3d((double)x, 0.0, (double)z))).func_177956_o();
                    biome2 = world.func_180494_b(new BlockPos(new Vec3d((double)x, 0.0, (double)z)));
                    if (BiomeDictionary.isBiomeOfType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH) || BiomeDictionary.isBiomeOfType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.isBiomeOfType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                        this.AddHerb(world, random, x, y, z);
                    }
                }
                if (CookingPlusConfig.FruitTreeSpawnRate != 0 && random.nextInt(CookingPlusConfig.FruitTreeSpawnRate) == 0 && (BiomeDictionary.isBiomeOfType((Biome)(biome = world.func_180494_b(new BlockPos(new Vec3d((double)(x = chunkX * 16 + random.nextInt(16)), 0.0, (double)(z = chunkZ * 16 + random.nextInt(16)))))), (BiomeDictionary.Type)BiomeDictionary.Type.LUSH) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST))) {
                    int y = world.func_175672_r(new BlockPos(new Vec3d((double)x, 0.0, (double)z))).func_177956_o();
                    CookingPlusOrchardBiome myBiome = new CookingPlusOrchardBiome(new Biome.BiomeProperties("Orchard").func_185395_b(0.3f).func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(0.8f));
                    myBiome.func_150567_a(random).func_180709_b(world, random, new BlockPos(new Vec3d((double)x, (double)y, (double)z)));
                }
                if (CookingPlusConfig.CornucopiaSpawnRate != 0 && random.nextInt(CookingPlusConfig.CornucopiaSpawnRate) == 0) {
                    x = chunkX * 16 + random.nextInt(16);
                    z = chunkZ * 16 + random.nextInt(16);
                    int y = world.func_175672_r(new BlockPos(new Vec3d((double)x, 0.0, (double)z))).func_177956_o();
                    this.AddCornocopia(world, random, x, y, z);
                }
                if (CookingPlusConfig.TropicalHutSpawnRate != 0 && random.nextInt(CookingPlusConfig.TropicalHutSpawnRate) == 0 && (biome = world.func_180494_b(new BlockPos(new Vec3d((double)(x = chunkX * 16 + random.nextInt(16)), 0.0, (double)(z = chunkZ * 16 + random.nextInt(16)))))) instanceof CookingPlusTropicalBiome) {
                    int y = world.func_175672_r(new BlockPos(new Vec3d((double)x, 0.0, (double)z))).func_177956_o();
                    if (world.func_175672_r(new BlockPos(new Vec3d((double)(x + 1), 0.0, (double)z))).func_177956_o() == y && world.func_175672_r(new BlockPos(new Vec3d((double)(x - 1), 0.0, (double)z))).func_177956_o() == y && world.func_175672_r(new BlockPos(new Vec3d((double)x, 0.0, (double)(z + 1)))).func_177956_o() == y && world.func_175672_r(new BlockPos(new Vec3d((double)x, 0.0, (double)(z - 1)))).func_177956_o() == y) {
                        CookingPlusPreBuiltTropicalHut myTempStructure = new CookingPlusPreBuiltTropicalHut();
                        myTempStructure.Generate(world, x, y - 1, z, true, 0, random);
                    }
                }
                CookingPlusUnderwaterGen.GenerateUnderwaterStructures(world, random, chunkX, chunkZ);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateEnd(World world, Random rand, int chunkX, int chunkZ) {
    }

    private void generateSurface(World world, Random rand, int chunkX, int chunkZ) {
        int firstBlockZCoord;
        int firstBlockYCoord;
        int firstBlockXCoord;
        int k;
        if (!CookingPlusConfig.disableSaltSpawn) {
            for (k = 0; k < 2; ++k) {
                firstBlockXCoord = chunkX + rand.nextInt(16);
                firstBlockYCoord = rand.nextInt(64);
                firstBlockZCoord = chunkZ + rand.nextInt(16);
                new WorldGenMinable(CookingPlusMain.blockSalt.func_176223_P(), 22).func_180709_b(world, rand, new BlockPos(new Vec3d((double)firstBlockXCoord, (double)firstBlockYCoord, (double)firstBlockZCoord)));
            }
        }
        if (!CookingPlusConfig.disableCopperSpawn) {
            for (k = 0; k < 10; ++k) {
                firstBlockXCoord = chunkX + rand.nextInt(16);
                firstBlockYCoord = rand.nextInt(100);
                firstBlockZCoord = chunkZ + rand.nextInt(16);
                new WorldGenMinable(CookingPlusMain.blockCopperOre.func_176223_P(), 8).func_180709_b(world, rand, new BlockPos(new Vec3d((double)firstBlockXCoord, (double)firstBlockYCoord, (double)firstBlockZCoord)));
            }
        }
        if (!CookingPlusConfig.disableZincSpawn) {
            for (k = 0; k < 10; ++k) {
                firstBlockXCoord = chunkX + rand.nextInt(16);
                firstBlockYCoord = rand.nextInt(100);
                firstBlockZCoord = chunkZ + rand.nextInt(16);
                new WorldGenMinable(CookingPlusMain.blockZincOre.func_176223_P(), 8).func_180709_b(world, rand, new BlockPos(new Vec3d((double)firstBlockXCoord, (double)firstBlockYCoord, (double)firstBlockZCoord)));
            }
        }
    }

    private void generateNether(World world, Random rand, int chunkX, int chunkZ) {
    }

    public static void FillFarmerChest(TileEntityChest MyChest, Random random) {
        if (MyChest != null) {
            int chance = 70;
            for (int i = 0; i < 27; ++i) {
                int mychance = (int)(random.nextFloat() * 100.0f);
                if (mychance > chance) {
                    chance = 90;
                    MyChest.func_70299_a(i, CookingPlusWorldGen.GenChestItem(random));
                    continue;
                }
                chance -= 7;
            }
        }
    }

    private static ItemStack GenChestItem(Random random) {
        ItemStack MyStack = new ItemStack(CookingPlusMain.onionseed, 1);
        int which = (int)(random.nextFloat() * 100.0f);
        if (which <= 60) {
            MyStack = CookingPlusWorldGen.GetRandomSeedItem(random);
        } else if (which > 60 && which <= 90) {
            MyStack = new ItemStack(CookingPlusLootHelper.instance().GetRandomGenericItem(random), 1);
        } else if (which > 90 && which <= 100 && !CookingPlusConfig.removeCraftedItemsFromChestLoot) {
            MyStack = CookingPlusWorldGen.GetRandomRareItem(random);
        }
        return MyStack;
    }

    private static ItemStack GetRandomSeedItem(Random random) {
        ItemStack myStack = new ItemStack(CookingPlusMain.onionseed);
        int which = (int)(random.nextFloat() * 100.0f);
        int amount = 1 + (int)(random.nextFloat() * 6.0f);
        int SeedVariations = 20;
        if (which <= 100 / SeedVariations) {
            myStack = new ItemStack(CookingPlusMain.onionseed, amount);
        } else if (which > 100 / SeedVariations && which <= 100 / SeedVariations * 2) {
            myStack = new ItemStack(CookingPlusMain.chilliseed, amount);
        } else if (which > 100 / SeedVariations * 2 && which <= 100 / SeedVariations * 3) {
            myStack = new ItemStack(Items.field_185163_cU, amount);
        } else if (which > 100 / SeedVariations * 3 && which <= 100 / SeedVariations * 4) {
            myStack = new ItemStack(CookingPlusMain.grapeseed, amount);
        } else if (which > 100 / SeedVariations * 4 && which <= 100 / SeedVariations * 5) {
            myStack = new ItemStack(CookingPlusMain.hopseed, amount);
        } else if (which > 100 / SeedVariations * 5 && which <= 100 / SeedVariations * 6) {
            myStack = new ItemStack(CookingPlusMain.cottonseed, amount);
        } else if (which > 100 / SeedVariations * 6 && which <= 100 / SeedVariations * 7) {
            myStack = new ItemStack(CookingPlusMain.teaseed, amount);
        } else if (which > 100 / SeedVariations * 7 && which <= 100 / SeedVariations * 8) {
            myStack = new ItemStack(CookingPlusMain.vanillaseed, amount);
        } else if (which > 100 / SeedVariations * 8 && which <= 100 / SeedVariations * 9) {
            myStack = new ItemStack(CookingPlusMain.pineappleseed, amount);
        } else if (which > 100 / SeedVariations * 9 && which <= 100 / SeedVariations * 10) {
            myStack = new ItemStack(CookingPlusMain.riceSeed, amount);
        } else if (which > 100 / SeedVariations * 10 && which <= 100 / SeedVariations * 11) {
            myStack = new ItemStack(CookingPlusMain.pricklypearseeds, amount);
        } else if (which > 100 / SeedVariations * 11 && which <= 100 / SeedVariations * 12) {
            myStack = new ItemStack(CookingPlusMain.leekseeds, amount);
        } else if (which > 100 / SeedVariations * 12 && which <= 100 / SeedVariations * 13) {
            myStack = new ItemStack(CookingPlusMain.cornseeds, amount);
        } else if (which > 100 / SeedVariations * 13 && which <= 100 / SeedVariations * 14) {
            myStack = new ItemStack(CookingPlusMain.coffeeseeds, amount);
        } else if (which > 100 / SeedVariations * 14 && which <= 100 / SeedVariations * 15) {
            myStack = new ItemStack(CookingPlusMain.lettuceseeds, amount);
        } else if (which > 100 / SeedVariations * 16 && which <= 100 / SeedVariations * 21) {
            myStack = new ItemStack(CookingPlusMain.basicschematic, amount * 9);
        }
        return myStack;
    }

    private static ItemStack GetRandomGenericItem(Random random) {
        ItemStack myStack = new ItemStack(CookingPlusMain.onionseed);
        int SeedVariations = 11;
        int which = random.nextInt(SeedVariations);
        int amount = 1;
        if (which == 0) {
            myStack = new ItemStack(CookingPlusMain.woodenscythe, amount);
        } else if (which == 1) {
            myStack = new ItemStack(CookingPlusMain.fishingnet, amount);
        } else if (which == 2) {
            myStack = new ItemStack(CookingPlusMain.blockRope, amount);
        } else if (which == 3) {
            myStack = new ItemStack(CookingPlusMain.mug, amount);
        } else if (which == 4) {
            myStack = new ItemStack(CookingPlusMain.teapotguide, amount);
        } else if (which == 5) {
            myStack = new ItemStack(CookingPlusMain.circlecutter, amount);
        } else if (which == 6) {
            myStack = new ItemStack(CookingPlusMain.starcutter, amount);
        } else if (which == 7) {
            myStack = new ItemStack(CookingPlusMain.heartcutter, amount);
        } else if (which == 8) {
            myStack = new ItemStack(CookingPlusMain.mooncutter, amount);
        } else if (which == 9) {
            myStack = CookingPlusLootHelper.instance().GetRandomProcessor(random);
        } else if (which == 10) {
            myStack = random.nextInt(2) == 0 ? new ItemStack(CookingPlusMain.mysteriousorb, amount) : new ItemStack(CookingPlusMain.chipmold, amount);
        }
        return myStack;
    }

    private static ItemStack GetRandomRareItem(Random random) {
        ItemStack myStack = new ItemStack(CookingPlusMain.onionseed);
        int SeedVariations = 7;
        int which = random.nextInt(SeedVariations);
        int amount = 1;
        if (which == 0) {
            myStack = new ItemStack(CookingPlusMain.juicer, amount);
        } else if (which == 1) {
            myStack = new ItemStack(Items.field_151133_ar, amount);
        } else if (which == 2) {
            myStack = new ItemStack(CookingPlusMain.rack, amount);
        } else if (which == 3) {
            myStack = new ItemStack(CookingPlusMain.blockTeapot, amount);
        } else if (which == 4) {
            myStack = new ItemStack(CookingPlusMain.blockPlate, amount);
        } else if (which == 5) {
            myStack = new ItemStack(CookingPlusMain.blockFryingPan, amount);
        } else if (which == 6) {
            myStack = random.nextInt(4) > 1 ? new ItemStack(CookingPlusLootHelper.instance().GetRandomCommonGuide(random), amount) : new ItemStack(CookingPlusLootHelper.instance().GetRandomRareGuide(random), amount);
        }
        return myStack;
    }

    private void SetWorldBlock(World myWorld, int x, int y, int z, Block newBlock, int meta, int notify) {
        myWorld.func_175656_a(new BlockPos(new Vec3d((double)x, (double)y, (double)z)), newBlock.func_176223_P());
    }

    private Block GetWorldBlock(World myWorld, int x, int y, int z) {
        return myWorld.func_180495_p(new BlockPos(new Vec3d((double)x, (double)y, (double)z))).func_177230_c();
    }

    private void SpawnBushes(World world, Random rand, int chunkX, int chunkZ) {
        int y = world.func_175672_r(new BlockPos(new Vec3d((double)chunkX, 0.0, (double)chunkZ))).func_177956_o();
        if (this.GetWorldBlock(world, chunkX, y, chunkZ).equals(Blocks.field_150350_a)) {
            this.AddBush(world, rand, chunkX, y, chunkZ);
        }
    }

    private void AddBush(World world, Random rand, int x, int y, int z) {
        int Which = rand.nextInt(4);
        if (Which == 0) {
            this.SpawnBushNode(world, rand, x, y, z, CookingPlusMain.blockBlueBerryBush);
        } else if (Which == 1) {
            this.SpawnBushNode(world, rand, x, y, z, CookingPlusMain.blockGooseBerryBush);
        } else if (Which == 2) {
            this.SpawnBushNode(world, rand, x, y, z, CookingPlusMain.blockBush);
        } else if (Which == 3) {
            this.SpawnBushNode(world, rand, x, y, z, CookingPlusMain.blockStrawBerryBush);
        }
    }

    private void SpawnBushNode(World world, Random rand, int x, int y, int z, Block bushBlock) {
        this.SetWorldBlock(world, x, y, z, bushBlock, 0, 2);
        if (rand.nextInt(4) == 0 && this.GetWorldBlock(world, x, y, z + 1).equals(Blocks.field_150350_a)) {
            this.SetWorldBlock(world, x, y, z + 1, bushBlock, 0, 2);
        }
        if (rand.nextInt(4) == 0 && this.GetWorldBlock(world, x, y, z - 1).equals(Blocks.field_150350_a)) {
            this.SetWorldBlock(world, x, y, z - 1, bushBlock, 0, 2);
        }
        if (rand.nextInt(4) == 0 && this.GetWorldBlock(world, x + 1, y, z).equals(Blocks.field_150350_a)) {
            this.SetWorldBlock(world, x + 1, y, z, bushBlock, 0, 2);
        }
        if (rand.nextInt(4) == 0 && this.GetWorldBlock(world, x - 1, y, z).equals(Blocks.field_150350_a)) {
            this.SetWorldBlock(world, x - 1, y, z, bushBlock, 0, 2);
        }
        if (rand.nextInt(4) == 0 && this.GetWorldBlock(world, x, y + 1, z).equals(Blocks.field_150350_a)) {
            this.SetWorldBlock(world, x, y + 1, z, bushBlock, 0, 2);
        }
    }

    private void AddHerb(World world, Random rand, int x, int y, int z) {
        int Which = rand.nextInt(6);
        if (Which == 0) {
            this.SetWorldBlock(world, x, y, z, CookingPlusMain.blockSage, 0, 2);
        } else if (Which == 1) {
            this.SetWorldBlock(world, x, y, z, CookingPlusMain.blockMint, 0, 2);
        } else if (Which == 2) {
            this.SetWorldBlock(world, x, y, z, CookingPlusMain.blockBuchu, 0, 2);
        } else if (Which == 3) {
            this.SetWorldBlock(world, x, y, z, CookingPlusMain.blockRosemary, 0, 2);
        } else if (Which == 4) {
            this.SetWorldBlock(world, x, y, z, CookingPlusMain.blockLicorice, 0, 2);
        } else if (Which == 5) {
            this.SetWorldBlock(world, x, y, z, CookingPlusMain.blockChamomile, 0, 2);
        }
    }

    private void AddCornocopia(World world, Random rand, int x, int y, int z) {
        for (int i = y - 1; i > 1; --i) {
            if (this.GetWorldBlock(world, x, i, z) != Blocks.field_150350_a || this.GetWorldBlock(world, x, i - 1, z) != Blocks.field_150348_b) continue;
            this.SetWorldBlock(world, x, i, z, CookingPlusMain.blockOrnateChest, 0, 2);
            this.SetWorldBlock(world, x, i, z, (Block)Blocks.field_150486_ae, 0, 2);
            TileEntityChest tileentitychest = (TileEntityChest)world.func_175625_s(new BlockPos(new Vec3d((double)x, (double)i, (double)z)));
            if (tileentitychest != null && tileentitychest.func_70302_i_() > 0) {
                this.FillCornocopiaChest(tileentitychest, rand);
            }
            this.SpreadCornocopia(world, rand, x, i, z);
            this.SetWorldBlock(world, x, i - 1, z, (Block)Blocks.field_150349_c, 0, 2);
            i = 0;
        }
    }

    private void SpreadCornocopia(World world, Random rand, int x, int y, int z) {
        int CornSize = rand.nextInt(10) + 10;
        for (int w = x - CornSize / 2; w < x + CornSize / 2; ++w) {
            for (int h = z - CornSize / 2; h < z + CornSize / 2; ++h) {
                for (int d = y - CornSize / 2; d < y + CornSize / 2; ++d) {
                    BlockPos myPos = new BlockPos(new Vec3d((double)w, (double)d, (double)h));
                    if (world.func_180495_p(myPos) == null || world.func_180495_p(myPos).func_177230_c() != Blocks.field_150348_b) continue;
                    if (world.func_180495_p(myPos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                        this.SetWorldBlock(world, myPos.func_177958_n(), myPos.func_177956_o(), myPos.func_177952_p(), (Block)Blocks.field_150349_c, 0, 2);
                        this.SetWorldBlock(world, myPos.func_177958_n(), myPos.func_177984_a().func_177956_o(), myPos.func_177952_p(), this.GetRandomPlant(rand), 0, 2);
                        continue;
                    }
                    if (world.func_180495_p(myPos.func_177977_b()).func_177230_c() == Blocks.field_150350_a && myPos.func_177977_b().func_177956_o() > y) {
                        this.SetWorldBlock(world, myPos.func_177958_n(), myPos.func_177956_o(), myPos.func_177952_p(), Blocks.field_150426_aN, 0, 2);
                        continue;
                    }
                    this.SetWorldBlock(world, myPos.func_177958_n(), myPos.func_177956_o(), myPos.func_177952_p(), Blocks.field_150346_d, 0, 2);
                }
            }
        }
    }

    private void FillCornocopiaChest(TileEntityChest MyChest, Random random) {
        int chance = 90;
        for (int i = 0; i < 27; ++i) {
            MyChest.func_70299_a(i, CookingPlusWorldGen.GenChestItem(random));
        }
    }

    private Block GetRandomPlant(Random rand) {
        int Which = rand.nextInt(6);
        if (Which == 0) {
            return CookingPlusMain.blockSage;
        }
        if (Which == 1) {
            return CookingPlusMain.blockMint;
        }
        if (Which == 2) {
            return CookingPlusMain.blockBuchu;
        }
        if (Which == 3) {
            return CookingPlusMain.blockRosemary;
        }
        if (Which == 4) {
            return CookingPlusMain.blockLicorice;
        }
        if (Which == 5) {
            return CookingPlusMain.blockChamomile;
        }
        return null;
    }
}

