/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.tiles;

import CookingPlus.CookingPlusMain;
import CookingPlus.recipes.CookingPlusOvenRecipes;
import CookingPlus.tiles.CookingPlusCustomTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BrickOvenTileEntity
extends CookingPlusCustomTileEntity
implements IInventory,
ITickable,
ISidedInventory {
    private int EntityDirection;
    private ItemStack[] inv = new ItemStack[19];
    private int[] CookTimer = new int[9];
    private int FuelTimer;

    public BrickOvenTileEntity() {
        for (int i = 0; i < 9; ++i) {
            this.CookTimer[i] = 0;
        }
        this.FuelTimer = 0;
        this.EntityDirection = 0;
    }

    public void setDirection(int Direction) {
        this.EntityDirection = Direction;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDirection() {
        return this.EntityDirection;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.inv = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = nbttaglist.func_150305_b(i);
            byte b0 = nbtTagCompound.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inv.length) continue;
            this.inv[b0] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
        this.EntityDirection = nbt.func_74762_e("MyDirection");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("MyDirection", this.EntityDirection);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(nbtTagCompound);
            nbttaglist.func_74742_a((NBTBase)nbtTagCompound);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        return super.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (slot < 9) {
            this.CookTimer[slot] = 0;
        }
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c().equals(CookingPlusMain.blockBrickOven) && !newSate.func_177230_c().equals(CookingPlusMain.blockBrickOven)) {
            world.func_175713_t(pos);
        }
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) < 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (slot < 9) {
            if (itemstack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150364_r))) {
                return false;
            }
            if (itemstack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150363_s))) {
                return false;
            }
            if (itemstack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150344_f))) {
                return false;
            }
            if (itemstack.func_77973_b().equals(Items.field_151044_h)) {
                return false;
            }
            return !itemstack.func_77973_b().equals(Items.field_151129_at);
        }
        if (slot == 9) {
            if (itemstack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150364_r))) {
                return true;
            }
            if (itemstack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150363_s))) {
                return true;
            }
            if (itemstack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150344_f))) {
                return true;
            }
            if (itemstack.func_77973_b().equals(Items.field_151044_h)) {
                return true;
            }
            if (itemstack.func_77973_b().equals(Items.field_151129_at)) {
                return true;
            }
        } else if (slot >= 10) {
            return false;
        }
        return false;
    }

    public void func_73660_a() {
        block7: {
            block8: {
                block6: {
                    if (this.FuelTimer > 0) {
                        --this.FuelTimer;
                    } else {
                        this.Refuel();
                    }
                    if (this.FuelTimer <= 0) break block6;
                    for (int i = 0; i < 9; ++i) {
                        if (this.inv[i] == null) {
                            this.CookTimer[i] = 0;
                        }
                        if (CookingPlusOvenRecipes.instance().getOvenResult(this.inv[i]) == null) continue;
                        this.ProcessSlot(i);
                    }
                    break block7;
                }
                if (this.inv[9] != null) break block8;
                for (int i = 0; i < 9; ++i) {
                    this.CookTimer[i] = 0;
                }
                break block7;
            }
            if (this.func_94041_b(9, this.inv[9])) break block7;
            for (int i = 0; i < 9; ++i) {
                this.CookTimer[i] = 0;
            }
        }
    }

    public boolean fillSlot(int slotNum, ItemStack MyStack) {
        if (this.inv[slotNum] == null) {
            this.inv[slotNum] = MyStack.func_77946_l();
            return true;
        }
        if (this.inv[slotNum].func_77973_b().equals(MyStack.func_77973_b()) && this.inv[slotNum].field_77994_a < 64 - (MyStack.field_77994_a - 1)) {
            this.inv[slotNum].field_77994_a += MyStack.field_77994_a;
            return true;
        }
        return false;
    }

    protected void ProcessSlot(int i) {
        if (this.CookTimer[i] > 100) {
            if (this.fillSlot(i + 10, CookingPlusOvenRecipes.instance().getOvenResult(this.inv[i]))) {
                this.inv[i] = this.GetReplaceItem(this.inv[i]) == null ? (this.inv[i].field_77994_a == 1 ? null : this.func_70298_a(i, this.inv[i].field_77994_a--)) : this.GetReplaceItem(this.inv[i]);
                this.CookTimer[i] = 0;
            }
        } else {
            int n = i;
            this.CookTimer[n] = this.CookTimer[n] + 1;
        }
    }

    public int getBurnTimeRemainingScaled(int p_145955_1_) {
        return this.FuelTimer * p_145955_1_ / 320;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled() {
        return 10;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isBurning() {
        return this.FuelTimer > 0;
    }

    public void Refuel() {
        if (this.needRefuel() && this.inv[9] != null && this.func_94041_b(9, this.inv[9])) {
            this.FuelTimer = this.getItemBurnTime(this.inv[9]);
            this.inv[9] = this.inv[9].field_77994_a == 1 ? null : this.func_70298_a(9, this.inv[9].field_77994_a--);
        }
    }

    public boolean needRefuel() {
        boolean refuel = false;
        for (int i = 0; i < 9; ++i) {
            if (this.inv[i] == null || CookingPlusOvenRecipes.instance().getOvenResult(this.inv[i]) == null || !this.canSlotBeCooked(i)) continue;
            return true;
        }
        return false;
    }

    public boolean canSlotBeCooked(int slotNum) {
        if (this.inv[slotNum] != null) {
            if (this.inv[slotNum + 10] == null) {
                return true;
            }
            if (this.inv[slotNum + 10].field_77994_a < 64 && this.inv[slotNum + 10].func_77973_b().equals(CookingPlusOvenRecipes.instance().getOvenResult(this.inv[slotNum]).func_77973_b()) && this.inv[slotNum + 10].field_77994_a < this.inv[slotNum + 10].func_77973_b().getItemStackLimit(this.inv[slotNum + 10])) {
                return true;
            }
        }
        return false;
    }

    public int getItemBurnTime(ItemStack myStack) {
        if (myStack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150364_r))) {
            return 80;
        }
        if (myStack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150363_s))) {
            return 80;
        }
        if (myStack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150344_f))) {
            return 80;
        }
        if (myStack.func_77973_b().equals(Items.field_151044_h)) {
            return 160;
        }
        if (myStack.func_77973_b().equals(Items.field_151129_at)) {
            return 320;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getItemCook(int slotNum, int scale) {
        return this.CookTimer[slotNum] * scale / 100;
    }

    public ItemStack GetReplaceItem(ItemStack myStack) {
        if (myStack.func_77973_b().equals(CookingPlusMain.cakebatter)) {
            return new ItemStack(CookingPlusMain.caketin);
        }
        if (myStack.func_77973_b().equals(CookingPlusMain.dough)) {
            return new ItemStack(CookingPlusMain.breadtin);
        }
        if (myStack.func_77973_b().equals(CookingPlusMain.bananadough)) {
            return new ItemStack(CookingPlusMain.breadtin);
        }
        if (myStack.func_77973_b().equals(CookingPlusMain.cookiebatter)) {
            return new ItemStack(Items.field_151054_z);
        }
        if (myStack.func_77973_b().equals(CookingPlusMain.pancakemix)) {
            return new ItemStack(Items.field_151054_z);
        }
        if (myStack.func_77973_b().equals(CookingPlusMain.traysponge)) {
            return new ItemStack(CookingPlusMain.cupcaketray);
        }
        if (myStack.func_77973_b().equals(CookingPlusMain.traychocolate)) {
            return new ItemStack(CookingPlusMain.cupcaketray);
        }
        if (myStack.func_77973_b().equals(CookingPlusMain.trayvelvet)) {
            return new ItemStack(CookingPlusMain.cupcaketray);
        }
        if (myStack.func_77973_b().equals(CookingPlusMain.traylargesponge)) {
            return new ItemStack(CookingPlusMain.largecupcaketray);
        }
        return null;
    }

    public ItemStack[] GetItems() {
        return this.inv;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] mySlotForFace = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
        return mySlotForFace;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (index < 9 && CookingPlusOvenRecipes.instance().isItemInput(itemStackIn)) {
            return index == this.findBestSlotForItem(itemStackIn);
        }
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (index < 9 && !CookingPlusOvenRecipes.instance().isItemInput(stack)) {
            return true;
        }
        return index > 9;
    }

    public int findBestSlotForItem(ItemStack myStack) {
        boolean[] canSmelt = new boolean[9];
        for (int i = 0; i < 9; ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() == myStack.func_77973_b()) {
                ItemStack outputItem = CookingPlusOvenRecipes.instance().getOvenResult(myStack);
                if (this.inv[i + 10] == null || this.inv[i + 10].func_77973_b() == outputItem.func_77973_b()) {
                    canSmelt[i] = true;
                    continue;
                }
                canSmelt[i] = false;
                continue;
            }
            canSmelt[i] = false;
        }
        int smallestSize = 65;
        int smallestSlot = -1;
        for (int i = 0; i < 9 && smallestSize != 0; ++i) {
            if (!canSmelt[i]) continue;
            if (this.inv[i] == null) {
                smallestSize = 0;
                smallestSlot = i;
                continue;
            }
            if (this.inv[i].field_77994_a >= smallestSize) continue;
            smallestSize = this.inv[i].field_77994_a;
            smallestSlot = i;
        }
        return smallestSlot;
    }
}

