/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.tiles;

import CookingPlus.CookingPlusConfig;
import CookingPlus.CookingPlusLootHelper;
import CookingPlus.CookingPlusMain;
import CookingPlus.blocks.CookingPlusCustomCrops;
import CookingPlus.tiles.CookingPlusCustomTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class HydrophonicTileEntity
extends CookingPlusCustomTileEntity
implements IInventory,
ITickable {
    private ItemStack[] inv = new ItemStack[1];
    private int EntityDirection = 0;
    private int[] CoolTime = new int[1];
    private Block myBlock;
    private int myAge = 0;
    private int timer = 0;
    private float rotation;

    public void setDirection(int Direction) {
        this.EntityDirection = Direction;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDirection() {
        return this.EntityDirection;
    }

    public void func_73660_a() {
        this.rotation += 0.1f;
        if (this.myAge < 7) {
            ++this.timer;
        }
        if (this.timer > CookingPlusConfig.HydrophonicGrowthRate) {
            this.SetAge(this.myAge + 1);
            this.timer = 0;
        }
        if (this.rotation > 360.0f) {
            this.rotation = 0.0f;
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c().equals(CookingPlusMain.blockHydrophonic) && !newSate.func_177230_c().equals(CookingPlusMain.blockHydrophonic)) {
            world.func_175713_t(pos);
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.inv = new ItemStack[this.func_70302_i_()];
        this.EntityDirection = nbt.func_74762_e("MyDirection");
        this.myAge = nbt.func_74762_e("Age");
        this.timer = nbt.func_74762_e("time");
        int tempInt = nbt.func_74762_e("blockID");
        this.myBlock = tempInt == 0 ? null : Block.func_149729_e((int)nbt.func_74762_e("blockID"));
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = nbttaglist.func_150305_b(i);
            byte b0 = nbtTagCompound.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inv.length) continue;
            this.inv[b0] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        nbt.func_74768_a("MyDirection", this.EntityDirection);
        nbt.func_74768_a("Age", this.myAge);
        nbt.func_74768_a("time", this.timer);
        if (this.myBlock == null) {
            nbt.func_74768_a("blockID", 0);
        } else {
            nbt.func_74768_a("blockID", Block.func_149682_b((Block)this.myBlock));
        }
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(nbtTagCompound);
            nbttaglist.func_74742_a((NBTBase)nbtTagCompound);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        return super.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) < 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ItemStack[] GetItems() {
        return this.inv;
    }

    public void FillSlot(ItemStack myItem, int slot) {
        if (!this.func_145831_w().field_72995_K) {
            this.inv[slot] = myItem;
            this.CoolTime[slot] = 0;
            this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
        }
    }

    public void processAutoActivate(Item myItem) {
        block3: {
            block2: {
                Block TempBlock;
                block4: {
                    if (myItem == null) break block2;
                    if (this.myBlock != null || !(myItem instanceof IPlantable) || ((IPlantable)myItem).getPlant(null, null) == null) break block3;
                    TempBlock = ((IPlantable)myItem).getPlant(null, null).func_177230_c();
                    if (TempBlock instanceof CookingPlusCustomCrops || TempBlock == Blocks.field_185773_cZ || TempBlock == Blocks.field_150464_aj || TempBlock == Blocks.field_150469_bN || TempBlock == Blocks.field_150459_bM || CookingPlusLootHelper.instance().whiteListedHydrohonicUnlocalisedName.contains(myItem.func_77658_a())) break block4;
                    if (!CookingPlusLootHelper.instance().whiteListedHydrohonicOreDictionary.contains(OreDictionary.getOreName((int)Item.func_150891_b((Item)myItem))) && !this.SmartInterpretSeed(myItem)) break block3;
                }
                this.myBlock = TempBlock;
                this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
                this.SetAge(0);
                break block3;
            }
            this.myBlock = null;
            this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
            this.SetAge(0);
        }
    }

    public void processActivate(EntityPlayer playerIn) {
        block20: {
            block19: {
                Block TempBlock;
                Item myItem;
                block21: {
                    if (playerIn.func_184582_a(EntityEquipmentSlot.MAINHAND) == null) break block19;
                    myItem = playerIn.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b();
                    if (CookingPlusConfig.enableHydrophonicBlockSeedDebug) {
                        System.out.println("output item unlocalised name " + myItem.func_77658_a());
                        System.out.println("input item ore dictionary name " + OreDictionary.getOreName((int)Item.func_150891_b((Item)myItem)));
                    }
                    if (this.myBlock != null || !(myItem instanceof IPlantable) || ((IPlantable)myItem).getPlant(null, null) == null) break block20;
                    TempBlock = ((IPlantable)myItem).getPlant(null, null).func_177230_c();
                    if (TempBlock instanceof CookingPlusCustomCrops || TempBlock == Blocks.field_185773_cZ || TempBlock == Blocks.field_150464_aj || TempBlock == Blocks.field_150469_bN || TempBlock == Blocks.field_150459_bM || CookingPlusLootHelper.instance().whiteListedHydrohonicUnlocalisedName.contains(myItem.func_77658_a())) break block21;
                    if (!CookingPlusLootHelper.instance().whiteListedHydrohonicOreDictionary.contains(OreDictionary.getOreName((int)Item.func_150891_b((Item)myItem))) && !this.SmartInterpretSeed(myItem)) break block20;
                }
                this.myBlock = TempBlock;
                this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
                this.SetAge(0);
                if (playerIn.func_184582_a((EntityEquipmentSlot)EntityEquipmentSlot.MAINHAND).field_77994_a > 1) {
                    playerIn.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(myItem, playerIn.func_184582_a((EntityEquipmentSlot)EntityEquipmentSlot.MAINHAND).field_77994_a - 1));
                } else {
                    playerIn.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
                }
                break block20;
            }
            if (playerIn.func_70093_af()) {
                if (this.myBlock instanceof CookingPlusCustomCrops) {
                    this.myBlock.func_176226_b(this.func_145831_w(), playerIn.func_180425_c(), this.myBlock.func_176223_P().func_177226_a((IProperty)CookingPlusCustomCrops.AGE, (Comparable)Integer.valueOf(this.myAge)), 0);
                    this.myBlock = null;
                    this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
                    this.SetAge(0);
                } else if (this.myBlock == Blocks.field_150464_aj || this.myBlock == Blocks.field_150469_bN || this.myBlock == Blocks.field_150459_bM || ((BlockCrops)this.myBlock).func_185526_g() == 3) {
                    this.myBlock.func_176226_b(this.func_145831_w(), playerIn.func_180425_c(), this.myBlock.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(this.myAge)), 0);
                    this.myBlock = null;
                    this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
                    this.SetAge(0);
                } else if (this.myBlock == Blocks.field_185773_cZ || ((BlockCrops)this.myBlock).func_185526_g() == 3) {
                    int age = this.myAge;
                    if (age == 0 || age == 1 || age == 2) {
                        age = 0;
                    } else if (age == 3 || age == 4) {
                        age = 1;
                    } else if (age == 5 || age == 6) {
                        age = 2;
                    } else if (age == 7) {
                        age = 3;
                    }
                    this.myBlock.func_176226_b(this.func_145831_w(), playerIn.func_180425_c(), this.myBlock.func_176223_P().func_177226_a((IProperty)BlockBeetroot.field_185531_a, (Comparable)Integer.valueOf(age)), 0);
                    this.myBlock = null;
                    this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
                    this.SetAge(0);
                } else {
                    this.myBlock.func_176226_b(this.func_145831_w(), playerIn.func_180425_c(), this.myBlock.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(this.myAge)), 0);
                    this.myBlock = null;
                    this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
                    this.SetAge(0);
                }
            }
        }
    }

    public void SetAge(int newamount) {
        if (!this.func_145831_w().field_72995_K && newamount != this.myAge) {
            this.myAge = newamount;
            this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
        }
    }

    public Block getCurrentCrop() {
        return this.myBlock;
    }

    public float getRotation() {
        return this.rotation;
    }

    public int GetAge() {
        return this.myAge;
    }

    public boolean isItemAcceptableInput(Item myItem) {
        block4: {
            block6: {
                block5: {
                    if (myItem == null || !(myItem instanceof IPlantable) || ((IPlantable)myItem).getPlant(null, null) == null) break block4;
                    Block TempBlock = ((IPlantable)myItem).getPlant(null, null).func_177230_c();
                    if (TempBlock instanceof CookingPlusCustomCrops || TempBlock == Blocks.field_185773_cZ || TempBlock == Blocks.field_150464_aj || TempBlock == Blocks.field_150469_bN || TempBlock == Blocks.field_150459_bM || CookingPlusLootHelper.instance().whiteListedHydrohonicUnlocalisedName.contains(myItem.func_77658_a())) break block5;
                    if (!CookingPlusLootHelper.instance().whiteListedHydrohonicOreDictionary.contains(OreDictionary.getOreName((int)Item.func_150891_b((Item)myItem)))) break block6;
                }
                return true;
            }
            if (this.SmartInterpretSeed(myItem)) {
                return true;
            }
        }
        return false;
    }

    public boolean SmartInterpretSeed(Item myItem) {
        Block TempBlock;
        if (CookingPlusConfig.enableAutoDetectSeedEligibilityForHydrophonicBlock && myItem != null && myItem instanceof IPlantable && ((IPlantable)myItem).getPlant(null, null) != null && (TempBlock = ((IPlantable)myItem).getPlant(null, null).func_177230_c()) instanceof BlockCrops) {
            if (((BlockCrops)TempBlock).func_185526_g() == 7 && TempBlock.getDrops((IBlockAccess)this.func_145831_w(), this.func_174877_v(), TempBlock.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(7)), 0) != null && TempBlock.getDrops((IBlockAccess)this.func_145831_w(), this.func_174877_v(), TempBlock.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(7)), 0).size() > 1) {
                return true;
            }
            if (((BlockCrops)TempBlock).func_185526_g() == 3 && TempBlock.getDrops((IBlockAccess)this.func_145831_w(), this.func_174877_v(), TempBlock.func_176223_P().func_177226_a((IProperty)BlockBeetroot.field_185531_a, (Comparable)Integer.valueOf(3)), 0) != null && TempBlock.getDrops((IBlockAccess)this.func_145831_w(), this.func_174877_v(), TempBlock.func_176223_P().func_177226_a((IProperty)BlockBeetroot.field_185531_a, (Comparable)Integer.valueOf(3)), 0).size() > 1) {
                return true;
            }
        }
        return false;
    }
}

