/*
 * Decompiled with CFR 0.152.
 */
package CookingPlus.tiles;

import CookingPlus.CookingPlusGenericHelper;
import CookingPlus.CookingPlusMain;
import CookingPlus.blocks.tileentity.CookingPlusCustomTileEntityBlock;
import CookingPlus.tiles.BotTileEntity;
import CookingPlus.tiles.CookingPlusCustomTileEntity;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LaserDroneBayTileEntity
extends CookingPlusCustomTileEntity
implements ITickable {
    float speed;
    float basespeed;
    float rotation;
    int basepause;
    int pause;
    int Type = 0;
    int rangeboost;
    boolean droneInPosition;
    Vec3d oldlaserDroneVec;
    Vec3d currentlaserDroneVec;
    Vec3d currentharvestDroneVec;
    private static final ArrayList<Block> IgnoreBlockList = new ArrayList();

    public LaserDroneBayTileEntity() {
        Random myRand = new Random();
        this.basespeed = 0.03f;
        this.basepause = 30;
        this.rotation = 0.0f;
        this.pause = 0;
        this.speed = this.basespeed;
        this.rangeboost = 0;
        if (IgnoreBlockList.isEmpty()) {
            IgnoreBlockList.add(CookingPlusMain.blockNetworkBlock);
            IgnoreBlockList.add(Blocks.field_150357_h);
            IgnoreBlockList.add(Blocks.field_180395_cM);
            IgnoreBlockList.add(Blocks.field_180399_cE);
        }
        this.SetDroneInPosition(false);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74760_g("dronech") > -1000.0f) {
            this.currentharvestDroneVec = new Vec3d((double)nbt.func_74760_g("dronehx"), (double)nbt.func_74760_g("dronehy"), (double)nbt.func_74760_g("dronehz"));
        }
        if (nbt.func_74760_g("dronecy") > -1000.0f) {
            this.currentlaserDroneVec = new Vec3d((double)nbt.func_74760_g("dronecx"), (double)nbt.func_74760_g("dronecy"), (double)nbt.func_74760_g("dronecz"));
        }
        this.droneInPosition = nbt.func_74767_n("DIP");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.currentharvestDroneVec == null) {
            nbt.func_74776_a("dronehx", 0.0f);
            nbt.func_74776_a("dronehy", -1000.0f);
            nbt.func_74776_a("dronehz", 0.0f);
        } else {
            nbt.func_74776_a("dronehx", (float)this.currentharvestDroneVec.field_72450_a);
            nbt.func_74776_a("dronehy", (float)this.currentharvestDroneVec.field_72448_b);
            nbt.func_74776_a("dronehz", (float)this.currentharvestDroneVec.field_72449_c);
        }
        if (this.currentlaserDroneVec == null) {
            nbt.func_74776_a("dronecx", 0.0f);
            nbt.func_74776_a("dronecy", -1000.0f);
            nbt.func_74776_a("dronecz", 0.0f);
        } else {
            nbt.func_74776_a("dronecx", (float)this.currentlaserDroneVec.field_72450_a);
            nbt.func_74776_a("dronecy", (float)this.currentlaserDroneVec.field_72448_b);
            nbt.func_74776_a("dronecz", (float)this.currentlaserDroneVec.field_72449_c);
        }
        nbt.func_74757_a("DIP", this.droneInPosition);
        return super.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void processActivate(EntityPlayer Player) {
    }

    public void func_73660_a() {
        this.rotation += 3.0f;
        if (this.currentlaserDroneVec == null) {
            this.currentlaserDroneVec = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        }
        ++this.Type;
        if (this.Type > 12) {
            this.Type = 0;
        }
        if (this.currentharvestDroneVec != null) {
            this.MoveDrone();
        }
        if (!CookingPlusMain.blockLaserDroneBay.func_176196_c(this.func_145831_w(), this.func_174877_v())) {
            CookingPlusMain.blockLaserDroneBay.func_176226_b(this.func_145831_w(), this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), 0);
            this.func_145831_w().func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
        }
    }

    public int getType() {
        return this.Type / 4;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c().equals(CookingPlusMain.blockLaserDroneBay) && !newSate.func_177230_c().equals(CookingPlusMain.blockLaserDroneBay)) {
            world.func_175713_t(pos);
        }
        return false;
    }

    public boolean updateLaserDrone(BlockPos myBayPos, float droneSpeedMultiplier, BotTileEntity myBot, int myRangeBoost) {
        this.speed = this.basespeed / droneSpeedMultiplier;
        this.rangeboost = myRangeBoost;
        if (this.currentlaserDroneVec == null) {
            this.currentlaserDroneVec = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        }
        if (!this.func_145831_w().field_72995_K) {
            if (!this.findNextHarvestBlock(this.field_174879_c)) {
                return false;
            }
            if (this.currentlaserDroneVec.field_72450_a != this.currentharvestDroneVec.field_72450_a || this.currentlaserDroneVec.field_72448_b != this.currentharvestDroneVec.field_72448_b + 1.0 || this.currentlaserDroneVec.field_72449_c != this.currentharvestDroneVec.field_72449_c) {
                this.SetDroneInPosition(false);
            } else {
                this.SetDroneInPosition(true);
            }
            if (this.droneInPosition) {
                ++this.pause;
                if ((float)this.pause > (float)this.basepause * droneSpeedMultiplier && this.currentharvestDroneVec != null) {
                    this.HarvestCurrentBlock(myBot);
                    this.pause = 0;
                }
            }
        }
        return true;
    }

    protected boolean findNextHarvestBlock(BlockPos myPos) {
        for (int y = 0; y < myPos.func_177956_o(); ++y) {
            for (int x = 0; x < 9 + this.rangeboost * 2; ++x) {
                for (int z = 0; z < 9 + this.rangeboost * 2; ++z) {
                    BlockPos myCheckPos = new BlockPos(new Vec3d((double)(myPos.func_177958_n() + x - 4 - this.rangeboost), (double)(myPos.func_177956_o() - y), (double)(myPos.func_177952_p() + z - 4 - this.rangeboost)));
                    if (!this.isBlockValidForHarvest(myCheckPos)) continue;
                    this.SetCurrentHarvestPosition(myCheckPos);
                    return true;
                }
            }
        }
        return false;
    }

    private void SetCurrentHarvestPosition(BlockPos myNewHarvest) {
        if (this.currentharvestDroneVec != new Vec3d((double)myNewHarvest.func_177958_n(), (double)myNewHarvest.func_177956_o(), (double)myNewHarvest.func_177952_p())) {
            this.currentharvestDroneVec = new Vec3d((double)myNewHarvest.func_177958_n(), (double)myNewHarvest.func_177956_o(), (double)myNewHarvest.func_177952_p());
            this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
        }
    }

    private void SetDroneInPosition(boolean newValue) {
        if (this.droneInPosition != newValue) {
            this.droneInPosition = newValue;
            this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
        }
    }

    private boolean isBlockValidForHarvest(BlockPos myCheckPos) {
        Block myBlock = this.func_145831_w().func_180495_p(myCheckPos).func_177230_c();
        return !(myBlock instanceof CookingPlusCustomTileEntityBlock) && !(myBlock instanceof BlockChest) && !IgnoreBlockList.contains(myBlock) && myBlock.func_176223_P().func_185904_a() != Material.field_151579_a && myBlock.func_176223_P().func_185904_a() != Material.field_151587_i && myBlock.func_176223_P().func_185904_a() != Material.field_151586_h && !CookingPlusGenericHelper.isValidNetworkAttachment(myBlock, (IBlockAccess)this.func_145831_w(), myCheckPos);
    }

    private void HarvestCurrentBlock(BotTileEntity myBot) {
        myBot.DepositBlockPositionIntoChest(new BlockPos(this.currentharvestDroneVec));
        this.func_145831_w().func_175656_a(new BlockPos(this.currentharvestDroneVec), Blocks.field_150350_a.func_176223_P());
        this.SetDroneInPosition(false);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getDroneOffsetPos() {
        if (this.currentlaserDroneVec.field_72450_a == 0.0 && this.currentlaserDroneVec.field_72448_b == 0.0 && this.currentlaserDroneVec.field_72449_c == 0.0) {
            return this.currentlaserDroneVec;
        }
        return this.currentlaserDroneVec.func_178788_d(new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
    }

    @SideOnly(value=Side.CLIENT)
    public float getRotation() {
        return this.rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getInPosition() {
        return this.droneInPosition;
    }

    protected void MoveDrone() {
        if (this.currentlaserDroneVec.field_72450_a != this.currentharvestDroneVec.field_72450_a || this.currentlaserDroneVec.field_72448_b != this.currentharvestDroneVec.field_72448_b + 1.0 || this.currentlaserDroneVec.field_72449_c != this.currentharvestDroneVec.field_72449_c) {
            this.oldlaserDroneVec = new Vec3d(this.currentlaserDroneVec.field_72450_a, this.currentlaserDroneVec.field_72448_b, this.currentlaserDroneVec.field_72449_c);
            float ldpx = (float)this.currentlaserDroneVec.field_72450_a;
            float ldpy = (float)this.currentlaserDroneVec.field_72448_b;
            float ldpz = (float)this.currentlaserDroneVec.field_72449_c;
            float hdx = (float)this.currentharvestDroneVec.field_72450_a;
            float hdy = (float)(this.currentharvestDroneVec.field_72448_b + 1.0);
            float hdz = (float)this.currentharvestDroneVec.field_72449_c;
            int XDirection = 0;
            int YDirection = 0;
            int ZDirection = 0;
            if (ldpx < hdx) {
                XDirection = 1;
            } else if (ldpx > hdx) {
                XDirection = -1;
            }
            if (ldpy < hdy) {
                YDirection = 1;
            } else if (ldpy > hdy) {
                YDirection = -1;
            }
            if (ldpz < hdz) {
                ZDirection = 1;
            } else if (ldpz > hdz) {
                ZDirection = -1;
            }
            if (XDirection > 0) {
                ldpx = ldpx + this.speed > hdx ? hdx : (ldpx += this.speed);
            }
            if (XDirection < 0) {
                ldpx = ldpx - this.speed < hdx ? hdx : (ldpx -= this.speed);
            }
            if (YDirection > 0) {
                ldpy = ldpy + this.speed > hdy ? hdy : (ldpy += this.speed);
            }
            if (YDirection < 0) {
                ldpy = ldpy - this.speed < hdy ? hdy : (ldpy -= this.speed);
            }
            if (ZDirection > 0) {
                ldpz = ldpz + this.speed > hdz ? hdz : (ldpz += this.speed);
            }
            if (ZDirection < 0) {
                ldpz = ldpz - this.speed < hdz ? hdz : (ldpz -= this.speed);
            }
            this.currentlaserDroneVec = new Vec3d((double)ldpx, (double)ldpy, (double)ldpz);
            if (ldpx == hdx && ldpy == hdy && ldpz == hdz) {
                this.UpdateBlock(this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), this.field_145850_b);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB MY_AABB = new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        return MY_AABB;
    }
}

