/*
 * Decompiled with CFR 0.152.
 */
package levelup.event;

import levelup.player.PlayerExtendedProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class BowEventHandler {
    public static final BowEventHandler INSTANCE = new BowEventHandler();

    private BowEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityArrow) {
            int archer;
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityPlayer && (archer = BowEventHandler.getArcherSkill((EntityPlayer)arrow.field_70250_c)) != 0) {
                arrow.field_70159_w *= (double)(1.0f + (float)archer / 100.0f);
                arrow.field_70181_x *= (double)(1.0f + (float)archer / 100.0f);
                arrow.field_70179_y *= (double)(1.0f + (float)archer / 100.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBowUse(ArrowNockEvent event) {
        int archer = BowEventHandler.getArcherSkill(event.getEntityPlayer());
        if (archer > 4) {
            event.getEntityPlayer().func_184598_c(event.getHand());
            this.setItemUseCount(event.getEntityPlayer());
            event.setAction(new ActionResult(EnumActionResult.SUCCESS, (Object)event.getBow()));
        }
    }

    public static int getArcherSkill(EntityPlayer player) {
        return PlayerExtendedProperties.getSkillFromIndex(player, 5);
    }

    private void setItemUseCount(EntityPlayer player) {
        player.field_184628_bn -= BowEventHandler.getArcherSkill(player) / 5;
    }
}

