/*
 * Decompiled with CFR 0.152.
 */
package levelup.event;

import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import levelup.ClassBonus;
import levelup.LevelUp;
import levelup.api.IProcessor;
import levelup.capabilities.CapabilityBrewingStand;
import levelup.capabilities.CapabilityFurnace;
import levelup.capabilities.LevelUpCapability;
import levelup.player.IPlayerClass;
import levelup.player.PlayerExtendedProperties;
import levelup.util.PlankCache;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStone;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public final class PlayerEventHandler {
    public static boolean oldSpeedDigging = true;
    public static boolean oldSpeedRedstone = true;
    public static float resetSkillOnDeath = 0.0f;
    public static boolean resetClassOnDeath = false;
    public static boolean noPlaceDuplicate = true;
    public static double xpPerLevel = 3.0;
    public static final int minLevel = 4;
    private static ResourceLocation fishingLoot = new ResourceLocation("levelup", "fishing/fishing_loot");
    private static ResourceLocation commonDig = new ResourceLocation("levelup", "digging/common_dig");
    private static ResourceLocation uncommonDig = new ResourceLocation("levelup", "digging/uncommon_dig");
    private static ResourceLocation rareDig = new ResourceLocation("levelup", "digging/rare_dig");
    private static ResourceLocation diggingLoot = new ResourceLocation("levelup", "digging/digging_loot");
    private static Map<Block, Integer> blockToCounter = new IdentityHashMap<Block, Integer>();
    private static ItemStack[] digLoot;
    private static ItemStack[] digLoot1;
    private static ItemStack[] digLoot2;
    private static ItemStack[] digLoot3;
    private static Set<Block> ores;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBreak(PlayerEvent.BreakSpeed event) {
        ItemStack itemstack = event.getEntityPlayer().func_184614_ca();
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        if (itemstack != null) {
            if (oldSpeedDigging && itemstack.func_77973_b() instanceof ItemSpade) {
                if (block instanceof BlockDirt || block instanceof BlockGravel) {
                    event.setNewSpeed(event.getNewSpeed() * itemstack.func_150997_a(state) / 0.5f);
                }
            } else if (oldSpeedRedstone && itemstack.func_77973_b() instanceof ItemPickaxe && block instanceof BlockRedstoneOre) {
                event.setNewSpeed(event.getNewSpeed() * itemstack.func_150997_a(state) / 3.0f);
            }
        }
        if (block instanceof BlockStone || block == Blocks.field_150347_e || block == Blocks.field_150343_Z || block instanceof BlockOre) {
            event.setNewSpeed(event.getNewSpeed() + (float)(PlayerEventHandler.getSkill(event.getEntityPlayer(), 0) / 5) * 0.2f);
        } else if (state.func_185904_a() == Material.field_151575_d) {
            event.setNewSpeed(event.getNewSpeed() + (float)(PlayerEventHandler.getSkill(event.getEntityPlayer(), 3) / 5) * 0.2f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            if (resetClassOnDeath) {
                PlayerExtendedProperties.from((EntityPlayer)event.getEntityLiving()).setPlayerClass((byte)0);
            }
            if (resetSkillOnDeath > 0.0f) {
                PlayerExtendedProperties.from((EntityPlayer)event.getEntityLiving()).takeSkillFraction(resetSkillOnDeath);
            }
        } else if (event.getEntityLiving() instanceof EntityMob && event.getSource().func_76346_g() instanceof EntityPlayer) {
            LevelUp.giveBonusFightingXP((EntityPlayer)event.getSource().func_76346_g());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFishInteract(PlayerInteractEvent.RightClickItem event) {
        ItemStack loot;
        EntityFishHook hook;
        if (event.getResult() != Event.Result.DENY && (hook = event.getEntityPlayer().field_71104_cf) != null && hook.field_146043_c == null && hook.field_146045_ax > 0 && (loot = PlayerEventHandler.getFishingLoot(event.getWorld(), event.getEntityPlayer())) != null) {
            ItemStack stack = event.getEntityPlayer().field_71071_by.func_70448_g();
            int i = stack.field_77994_a;
            int j = stack.func_77952_i();
            stack.func_77972_a(1, (EntityLivingBase)event.getEntityPlayer());
            event.getEntityPlayer().func_184609_a(event.getHand());
            event.getEntityPlayer().field_71071_by.func_70299_a(event.getEntityPlayer().field_71071_by.field_70461_c, stack);
            if (event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                stack.field_77994_a = i;
                if (stack.func_77984_f()) {
                    stack.func_77964_b(j);
                }
            }
            if (stack.field_77994_a <= 0) {
                event.getEntityPlayer().field_71071_by.func_70299_a(event.getEntityPlayer().field_71071_by.field_70461_c, null);
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(event.getEntityPlayer(), stack, event.getHand()));
            }
            if (!event.getEntityPlayer().func_184587_cr() && event.getEntityPlayer() instanceof EntityPlayerMP) {
                ((EntityPlayerMP)event.getEntityPlayer()).func_71120_a(event.getEntityPlayer().field_71069_bz);
            }
            event.setResult(Event.Result.DENY);
            if (!hook.field_70170_p.field_72995_K) {
                EntityItem entityitem = new EntityItem(hook.field_70170_p, hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, loot.func_77946_l());
                double d5 = hook.field_146042_b.field_70165_t - hook.field_70165_t;
                double d6 = hook.field_146042_b.field_70163_u - hook.field_70163_u;
                double d7 = hook.field_146042_b.field_70161_v - hook.field_70161_v;
                double d8 = MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7));
                double d9 = 0.1;
                entityitem.field_70159_w = d5 * d9;
                entityitem.field_70181_x = d6 * d9 + (double)MathHelper.func_76133_a((double)d8) * 0.08;
                entityitem.field_70179_y = d7 * d9;
                hook.field_70170_p.func_72838_d((Entity)entityitem);
                hook.field_146042_b.field_70170_p.func_72838_d((Entity)new EntityXPOrb(hook.field_146042_b.field_70170_p, hook.field_146042_b.field_70165_t, hook.field_146042_b.field_70163_u + 0.5, hook.field_146042_b.field_70161_v + 0.5, event.getEntityPlayer().func_70681_au().nextInt(6) + 1));
            }
        }
    }

    @SubscribeEvent
    public void tryPlaceOre(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack;
        if (noPlaceDuplicate && (stack = event.getEntityPlayer().field_71071_by.func_70448_g()) != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("NoPlacing")) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null && !event.getWorld().field_72995_K) {
            IBlockState state = event.getState();
            Random random = event.getHarvester().func_70681_au();
            if (PlankCache.contains(state.func_177230_c(), state.func_177230_c().func_180651_a(state))) {
                ItemStack planks;
                int skill = PlayerEventHandler.getSkill(event.getHarvester(), 3);
                if (random.nextDouble() <= (double)skill / 150.0 && (planks = PlankCache.getProduct(state.func_177230_c(), state.func_177230_c().func_180651_a(state))) != null) {
                    event.getDrops().add(PlankCache.getProduct(state.func_177230_c(), state.func_177230_c().func_180651_a(state)).func_77946_l());
                }
                if (random.nextDouble() <= (double)skill / 150.0) {
                    event.getDrops().add(new ItemStack(Items.field_151055_y, 2));
                }
            } else if (state.func_177230_c() instanceof BlockOre || state.func_177230_c() instanceof BlockRedstoneOre || ores.contains(state.func_177230_c())) {
                int skill = PlayerEventHandler.getSkill(event.getHarvester(), 0);
                if (!blockToCounter.containsKey(state.func_177230_c())) {
                    blockToCounter.put(state.func_177230_c(), blockToCounter.size());
                }
                if (!event.isSilkTouching()) {
                    LevelUp.incrementOreCounter(event.getHarvester(), blockToCounter.get(state.func_177230_c()));
                }
                if (random.nextDouble() <= (double)skill / 200.0) {
                    int qutity;
                    Item ID;
                    boolean foundBlock = false;
                    ItemStack newOre = null;
                    for (ItemStack stack : event.getDrops()) {
                        if (stack == null || state.func_177230_c() != Block.func_149634_a((Item)stack.func_77973_b())) continue;
                        this.writeNoPlacing(stack);
                        newOre = stack.func_77946_l();
                        foundBlock = true;
                        break;
                    }
                    if (newOre != null) {
                        event.getDrops().add(newOre);
                    }
                    if (!foundBlock && (ID = state.func_177230_c().func_180660_a(state, random, event.getFortuneLevel())) != null && (qutity = state.func_177230_c().quantityDropped(state, event.getFortuneLevel(), random)) > 0) {
                        event.getDrops().add(new ItemStack(ID, qutity, state.func_177230_c().func_180651_a(state)));
                    }
                }
            } else if (!event.isSilkTouching()) {
                int skill = PlayerEventHandler.getSkill(event.getHarvester(), 11);
                if (state.func_185904_a() == Material.field_151578_c) {
                    ItemStack loot;
                    if (random.nextFloat() <= (float)skill / 200.0f && (loot = this.getDigLoot(event.getWorld(), event.getHarvester())) != null) {
                        this.removeFromList(event.getDrops(), state.func_177230_c());
                        ItemStack toDrop = loot.func_77946_l();
                        event.getDrops().add(toDrop);
                    }
                } else if (state.func_177230_c() instanceof BlockGravel && random.nextInt(10) < skill / 5) {
                    this.removeFromList(event.getDrops(), state.func_177230_c());
                    event.getDrops().add(new ItemStack(Items.field_151145_ak));
                }
            }
        }
    }

    private ItemStack getDigLoot(World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)world).func_186470_a(player);
            build.func_186469_a((float)EnchantmentHelper.func_185284_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (EntityLivingBase)player) + player.func_184817_da());
            return (ItemStack)world.func_184146_ak().func_186521_a(diggingLoot).func_186462_a(player.func_70681_au(), build.func_186471_a()).get(0);
        }
        return null;
    }

    private void removeFromList(List<ItemStack> drops, Block block) {
        Iterator<ItemStack> itr = drops.iterator();
        while (itr.hasNext()) {
            ItemStack drop = itr.next();
            if (drop == null || block != Block.func_149634_a((Item)drop.func_77973_b())) continue;
            itr.remove();
        }
    }

    private void writeNoPlacing(ItemStack toDrop) {
        if (!noPlaceDuplicate) {
            return;
        }
        NBTTagCompound tagCompound = toDrop.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74757_a("NoPlacing", true);
        toDrop.func_77982_d(tagCompound);
    }

    private ItemStack getPlanks(EntityPlayer player, ItemStack drop) {
        InventoryCrafting craft = new ContainerPlayer((InventoryPlayer)player.field_71071_by, (boolean)(!player.field_70170_p.field_72995_K ? true : false), (EntityPlayer)player).field_75181_e;
        craft.func_70299_a(1, drop);
        return CraftingManager.func_77594_a().func_82787_a(craft, player.field_70170_p);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!event.getWorld().field_72995_K && event.getPlayer() != null) {
            if (event.getState().func_177230_c() instanceof BlockCrops || event.getState().func_177230_c() instanceof BlockStem) {
                if (!((IGrowable)event.getState().func_177230_c()).func_176473_a(event.getWorld(), event.getPos(), event.getState(), false)) {
                    this.doCropDrops(event);
                }
            } else if (event.getState().func_177230_c() instanceof BlockMelon) {
                this.doCropDrops(event);
            }
        }
    }

    private void doCropDrops(BlockEvent.BreakEvent event) {
        Random random = event.getPlayer().func_70681_au();
        int skill = PlayerEventHandler.getSkill(event.getPlayer(), 9);
        if (random.nextInt(10) < skill / 5) {
            Item ID = event.getState().func_177230_c().func_180660_a(event.getState(), random, 0);
            if (ID == null) {
                if (event.getState().func_177230_c() == Blocks.field_150393_bb) {
                    ID = Items.field_151080_bb;
                } else if (event.getState().func_177230_c() == Blocks.field_150394_bc) {
                    ID = Items.field_151081_bc;
                }
            }
            if (ID != null) {
                event.getWorld().func_72838_d((Entity)new EntityItem(event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack(ID, 1, event.getState().func_177230_c().func_180651_a(event.getState()))));
            }
        }
    }

    @SubscribeEvent
    public void registerFurnaceCap(AttachCapabilitiesEvent.TileEntity evt) {
        if (evt.getTileEntity() instanceof TileEntityFurnace) {
            final TileEntityFurnace furnace = (TileEntityFurnace)evt.getTileEntity();
            evt.addCapability(ClassBonus.FURNACE_LOCATION, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IProcessor instance;
                {
                    this.instance = new CapabilityFurnace(furnace);
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == LevelUpCapability.MACHINE_PROCESSING;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == LevelUpCapability.MACHINE_PROCESSING ? LevelUpCapability.MACHINE_PROCESSING.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)LevelUpCapability.MACHINE_PROCESSING.getStorage().writeNBT(LevelUpCapability.MACHINE_PROCESSING, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound tag) {
                    LevelUpCapability.MACHINE_PROCESSING.getStorage().readNBT(LevelUpCapability.MACHINE_PROCESSING, (Object)this.instance, null, (NBTBase)tag);
                }
            });
        } else if (evt.getTileEntity() instanceof TileEntityBrewingStand) {
            final TileEntityBrewingStand stand = (TileEntityBrewingStand)evt.getTileEntity();
            evt.addCapability(ClassBonus.FURNACE_LOCATION, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IProcessor instance;
                {
                    this.instance = new CapabilityBrewingStand(stand);
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == LevelUpCapability.MACHINE_PROCESSING;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == LevelUpCapability.MACHINE_PROCESSING ? LevelUpCapability.MACHINE_PROCESSING.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)LevelUpCapability.MACHINE_PROCESSING.getStorage().writeNBT(LevelUpCapability.MACHINE_PROCESSING, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound tag) {
                    LevelUpCapability.MACHINE_PROCESSING.getStorage().readNBT(LevelUpCapability.MACHINE_PROCESSING, (Object)this.instance, null, (NBTBase)tag);
                }
            });
        }
    }

    @SubscribeEvent
    public void onEntityConstruct(AttachCapabilitiesEvent.Entity evt) {
        if (evt.getEntity() instanceof EntityPlayer) {
            evt.addCapability(ClassBonus.SKILL_LOCATION, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IPlayerClass instance = (IPlayerClass)LevelUpCapability.CAPABILITY_CLASS.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == LevelUpCapability.CAPABILITY_CLASS;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == LevelUpCapability.CAPABILITY_CLASS ? LevelUpCapability.CAPABILITY_CLASS.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)LevelUpCapability.CAPABILITY_CLASS.getStorage().writeNBT(LevelUpCapability.CAPABILITY_CLASS, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound tag) {
                    LevelUpCapability.CAPABILITY_CLASS.getStorage().readNBT(LevelUpCapability.CAPABILITY_CLASS, (Object)this.instance, null, (NBTBase)tag);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath() || !resetClassOnDeath || resetSkillOnDeath < 1.0f) {
            NBTTagCompound data = new NBTTagCompound();
            PlayerExtendedProperties.from(event.getOriginal()).saveNBTData(data);
            PlayerExtendedProperties.from(event.getEntityPlayer()).loadNBTData(data);
        }
    }

    public static void registerOres() {
        for (String ore : OreDictionary.getOreNames()) {
            if (!ore.startsWith("ore") || OreDictionary.getOres((String)ore) == null || OreDictionary.getOres((String)ore).isEmpty()) continue;
            for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                Block block;
                if (!(stack.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof BlockOre || block instanceof BlockRedstoneOre || ores.contains(block)) continue;
                ores.add(block);
            }
        }
    }

    public static ItemStack getFishingLoot(World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70681_au().nextDouble() <= (double)(PlayerEventHandler.getSkill(player, 10) / 5) * 0.05) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)world);
            build.func_186469_a((float)EnchantmentHelper.func_151386_g((EntityLivingBase)player) + player.func_184817_da());
            return (ItemStack)world.func_184146_ak().func_186521_a(fishingLoot).func_186462_a(player.func_70681_au(), build.func_186471_a()).get(0);
        }
        return null;
    }

    public static int getSkill(EntityPlayer player, int id) {
        return PlayerExtendedProperties.getSkillFromIndex(player, id);
    }

    static {
        blockToCounter.put(Blocks.field_150365_q, 0);
        blockToCounter.put(Blocks.field_150369_x, 1);
        blockToCounter.put(Blocks.field_150450_ax, 2);
        blockToCounter.put(Blocks.field_150366_p, 3);
        blockToCounter.put(Blocks.field_150352_o, 4);
        blockToCounter.put(Blocks.field_150412_bA, 5);
        blockToCounter.put(Blocks.field_150482_ag, 6);
        blockToCounter.put(Blocks.field_150449_bY, 7);
        LootTableList.func_186375_a((ResourceLocation)fishingLoot);
        LootTableList.func_186375_a((ResourceLocation)commonDig);
        LootTableList.func_186375_a((ResourceLocation)uncommonDig);
        LootTableList.func_186375_a((ResourceLocation)rareDig);
        LootTableList.func_186375_a((ResourceLocation)diggingLoot);
        digLoot = new ItemStack[]{new ItemStack(Items.field_151119_aD, 8), new ItemStack(Items.field_151054_z, 2), new ItemStack(Items.field_151044_h, 4), new ItemStack(Items.field_151159_an), new ItemStack(Items.field_151055_y, 4), new ItemStack(Items.field_151007_F, 2)};
        digLoot1 = new ItemStack[]{new ItemStack(Items.field_151052_q), new ItemStack(Items.field_151051_r), new ItemStack(Items.field_151050_s), new ItemStack(Items.field_151049_t)};
        digLoot2 = new ItemStack[]{new ItemStack(Items.field_151123_aH, 2), new ItemStack(Items.field_151137_ax, 8), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151043_k)};
        digLoot3 = new ItemStack[]{new ItemStack(Items.field_151045_i)};
        ores = Sets.newIdentityHashSet();
    }
}

