/*
 * Decompiled with CFR 0.152.
 */
package levelup.gui;

import java.awt.Color;
import java.util.List;
import levelup.ClassBonus;
import levelup.LevelUp;
import levelup.event.FMLEventHandler;
import levelup.event.PlayerEventHandler;
import levelup.player.PlayerExtendedProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class LevelUpHUD
extends Gui {
    public static final LevelUpHUD INSTANCE = new LevelUpHUD();
    private float val = 0.7f;
    private float valIncr = 0.005f;

    private LevelUpHUD() {
    }

    public void addToText(List<String> left) {
        byte playerClass = PlayerExtendedProperties.getPlayerClass(LevelUp.proxy.getPlayer());
        if (playerClass != 0) {
            int skillXP;
            if (!LevelUp.renderExpBar && (skillXP = PlayerExtendedProperties.from(LevelUp.proxy.getPlayer()).getSkillFromIndex("XP")) > 0) {
                left.add(I18n.func_135052_a((String)"hud.skill.text1", (Object[])new Object[]{skillXP}));
            }
            left.add(I18n.func_135052_a((String)"hud.skill.text2", (Object[])new Object[]{I18n.func_135052_a((String)("class" + playerClass + ".name"), (Object[])new Object[0])}));
        } else if (LevelUpHUD.canSelectClass() && !LevelUp.renderExpBar) {
            left.add(I18n.func_135052_a((String)"hud.skill.select", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public void renderLvlUpHUD(RenderGameOverlayEvent.Pre event) {
        if (LevelUp.allowHUD && LevelUp.proxy.getPlayer() != null) {
            if (LevelUp.renderTopLeft && event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
                this.addToText(((RenderGameOverlayEvent.Text)event).getLeft());
            }
            if (LevelUp.renderExpBar && event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
                this.addToExpBar(event.getResolution());
            }
        }
    }

    @SubscribeEvent
    public void onFOV(FOVUpdateEvent event) {
        if (!LevelUp.changeFOV && !event.getEntity().func_175144_cb()) {
            int skill = 0;
            if (event.getEntity().func_70093_af()) {
                skill = 2 * FMLEventHandler.getSkill(event.getEntity(), 8);
            } else if (event.getEntity().func_70051_ag()) {
                skill = FMLEventHandler.getSkill(event.getEntity(), 6);
            }
            if (skill > 0) {
                event.setNewfov(event.getFov() - 0.5f);
                event.setNewfov(event.getNewfov() * 1.0f / (1.0f + (float)skill / 100.0f));
                event.setNewfov(event.getNewfov() + 0.5f);
            }
        }
    }

    private void addToExpBar(ScaledResolution res) {
        this.val += this.valIncr;
        if (this.val >= 1.0f || this.val <= 0.4f) {
            this.valIncr *= -1.0f;
        }
        if (this.val > 1.0f) {
            this.val = 1.0f;
        }
        if (this.val < 0.4f) {
            this.val = 0.4f;
        }
        String text = null;
        if (LevelUpHUD.canShowSkills()) {
            int skillXP = PlayerExtendedProperties.from(LevelUp.proxy.getPlayer()).getSkillFromIndex("XP");
            if (skillXP > 0) {
                text = I18n.func_135052_a((String)"hud.skill.text1", (Object[])new Object[]{skillXP});
            }
        } else if (LevelUpHUD.canSelectClass()) {
            text = I18n.func_135052_a((String)"hud.skill.select", (Object[])new Object[0]);
        }
        int x = (res.func_78326_a() - Minecraft.func_71410_x().field_71466_p.func_78256_a(text)) / 2;
        int y = res.func_78328_b() - 29;
        if (text != null) {
            int col = Color.HSBtoRGB(0.2929688f, 1.0f, this.val) & 0xFFFFFF;
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, x, y, col);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static boolean canSelectClass() {
        if (LevelUp.proxy.getPlayer().field_71068_ca >= 4) {
            return true;
        }
        int points = PlayerExtendedProperties.from(LevelUp.proxy.getPlayer()).getSkillPoints();
        return (double)points > 4.0 * PlayerEventHandler.xpPerLevel || points > ClassBonus.getBonusPoints();
    }

    public static boolean canShowSkills() {
        return PlayerExtendedProperties.from(LevelUp.proxy.getPlayer()).hasClass();
    }
}

