/*
 * Decompiled with CFR 0.152.
 */
package com.is.core.cards;

import com.is.References.References_Rarity;
import com.is.core.cards.Card;
import com.is.core.cards.CardFigure;
import com.is.core.cards.FiguresRegisterer;
import com.is.core.mechanics.MTC_Configuration;
import com.is.main.MTC_Mod;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class Booster
extends Item {
    References_Rarity.rarity mRar;
    int[] custom_count;

    public Booster(References_Rarity.rarity parRar) {
        this.mRar = parRar;
        this.func_77655_b("Booster_" + References_Rarity.AsString(this.mRar));
        this.func_111206_d("is_mtc:boosters/Booster_" + References_Rarity.AsString(this.mRar));
        this.func_77637_a(MTC_Mod.booster_creative_tab);
    }

    public void setCardsCount(int com, int uncom, int rare, int art) {
        this.custom_count = new int[4];
        if (com < 0 || uncom < 0 || rare < 0 || art < 0) {
            this.custom_count = null;
            return;
        }
        this.custom_count[0] = com;
        this.custom_count[1] = uncom;
        this.custom_count[2] = rare;
        this.custom_count[3] = art;
    }

    void createInWorld(ItemStack stack, World w, EntityPlayer entity) {
        EntityItem enti = new EntityItem(w, entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v, stack);
        w.func_72838_d((Entity)enti);
    }

    void generateXCards(int count, References_Rarity.rarity r, World w, EntityPlayer player) {
        Card created = r == References_Rarity.rarity.ARTIFACT ? MTC_Mod.ca : (r == References_Rarity.rarity.RARE ? MTC_Mod.cr : (r == References_Rarity.rarity.UNCOMMON ? MTC_Mod.cu : MTC_Mod.cc));
        for (int i = 0; i < count; ++i) {
            CardFigure cf = FiguresRegisterer.getARandomFigure(r);
            if (cf == null) continue;
            ItemStack cardStack = new ItemStack((Item)created, 1);
            NBTTagCompound nbttag = new NBTTagCompound();
            nbttag.func_74778_a("name", cf.Name);
            nbttag.func_74778_a("category", cf.Category);
            nbttag.func_74778_a("edition", cf.Edition);
            nbttag.func_74768_a("rar", cf.Rarity.ordinal());
            cardStack.func_77982_d(nbttag);
            this.createInWorld(cardStack, w, player);
        }
    }

    void openBooster(World w, EntityPlayer player) {
        if (this.custom_count != null) {
            this.generateXCards(this.custom_count[0], References_Rarity.rarity.COMMON, w, player);
            this.generateXCards(this.custom_count[1], References_Rarity.rarity.UNCOMMON, w, player);
            this.generateXCards(this.custom_count[2], References_Rarity.rarity.RARE, w, player);
            this.generateXCards(this.custom_count[3], References_Rarity.rarity.ARTIFACT, w, player);
        } else {
            this.generateXCards(MTC_Configuration.common_count[this.mRar.ordinal()], References_Rarity.rarity.COMMON, w, player);
            this.generateXCards(MTC_Configuration.uncommon_count[this.mRar.ordinal()], References_Rarity.rarity.UNCOMMON, w, player);
            this.generateXCards(MTC_Configuration.rare_count[this.mRar.ordinal()], References_Rarity.rarity.RARE, w, player);
            this.generateXCards(MTC_Configuration.artifact_count[this.mRar.ordinal()], References_Rarity.rarity.ARTIFACT, w, player);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World w, EntityPlayer player) {
        if (w.field_72995_K) {
            return stack;
        }
        this.openBooster(w, player);
        --stack.field_77994_a;
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer ent, List list, boolean bool) {
        list.add("What cards can I find in this booster ?");
        if (this.mRar == References_Rarity.rarity.ARTIFACT) {
            list.add("It's thinner than usual...");
        }
        list.add(References_Rarity.AsColor(this.mRar) + References_Rarity.AsString(this.mRar));
        list.add("");
        list.add(EnumChatFormatting.ITALIC + "Made by -TW- Industries");
        list.add(EnumChatFormatting.ITALIC + "Some endermen may have plundered some cards");
    }
}

