/*
 * Decompiled with CFR 0.152.
 */
package com.is.core.cards;

import com.is.References.References_Rarity;
import com.is.core.cards.CardFigure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class FiguresRegisterer {
    static Boolean initialized = false;
    static Map<String, Map<References_Rarity.rarity, ArrayList<CardFigure>>> byEdRar;
    static Map<String, ArrayList<CardFigure>> byEdition;
    static Map<References_Rarity.rarity, ArrayList<CardFigure>> byRarity;
    static ArrayList<CardFigure> figures;

    static void init() {
        if (initialized.booleanValue()) {
            return;
        }
        byEdRar = new HashMap<String, Map<References_Rarity.rarity, ArrayList<CardFigure>>>();
        byEdition = new HashMap<String, ArrayList<CardFigure>>();
        byRarity = new HashMap<References_Rarity.rarity, ArrayList<CardFigure>>();
        figures = new ArrayList();
        for (int i = 0; i < References_Rarity.rarity.values().length; ++i) {
            byRarity.put(References_Rarity.rarity.values()[i], new ArrayList());
        }
        initialized = true;
    }

    public static Boolean registerACardFigure(CardFigure cf) {
        if (!initialized.booleanValue()) {
            FiguresRegisterer.init();
        }
        if (!cf.isValid().booleanValue()) {
            System.out.println("[MTC_Error] Got an invalid cardFigure. This should not have happened");
            return false;
        }
        if (!byEdition.containsKey(cf.Edition)) {
            byEdition.put(cf.Edition, new ArrayList());
        }
        if (!byEdRar.containsKey(cf.Edition)) {
            byEdRar.put(cf.Edition, new HashMap());
            for (int i = 0; i < References_Rarity.rarity.values().length; ++i) {
                byEdRar.get(cf.Edition).put(References_Rarity.rarity.values()[i], new ArrayList());
            }
        }
        if (figures.contains(cf)) {
            System.out.println("[MTC_Warning] " + cf.Name + " in edition " + cf.Edition + " is a duplicate. Ignored");
            return false;
        }
        cf.Number = FiguresRegisterer.getNumberOfFiguresInEdition(cf.Edition) + 1;
        byEdition.get(cf.Edition).add(cf);
        byRarity.get((Object)cf.Rarity).add(cf);
        byEdRar.get(cf.Edition).get((Object)cf.Rarity).add(cf);
        figures.add(cf);
        return true;
    }

    public static int getNumberOfFiguresInEdition(String edition) {
        if (!initialized.booleanValue()) {
            FiguresRegisterer.init();
        }
        if (byEdition != null && !byEdition.containsKey(edition)) {
            return -1;
        }
        return byEdition.get(edition).size();
    }

    public static int getFigureNumber(CardFigure cf) {
        if (!initialized.booleanValue()) {
            FiguresRegisterer.init();
            return -1;
        }
        if (figures.contains(cf)) {
            return FiguresRegisterer.figures.get((int)FiguresRegisterer.figures.indexOf((Object)cf)).Number;
        }
        return -1;
    }

    public static void dumpEditionData(String edition) {
        if (!initialized.booleanValue()) {
            FiguresRegisterer.init();
        }
        if (byEdRar == null && !byEdRar.containsKey(edition)) {
            return;
        }
        Map<References_Rarity.rarity, ArrayList<CardFigure>> data = byEdRar.get(edition);
        if (data == null) {
            return;
        }
        System.out.println("[MTC_Info] In edition" + edition);
        System.out.println("\tcommons: " + data.get((Object)References_Rarity.rarity.COMMON).size());
        System.out.println("\tuncommons: " + data.get((Object)References_Rarity.rarity.UNCOMMON).size());
        System.out.println("\trares: " + data.get((Object)References_Rarity.rarity.RARE).size());
        System.out.println("\tartifacts: " + data.get((Object)References_Rarity.rarity.ARTIFACT).size());
    }

    public static CardFigure getARandomFigure(References_Rarity.rarity rar) {
        Random r = new Random();
        if (!initialized.booleanValue()) {
            FiguresRegisterer.init();
            return null;
        }
        ArrayList<CardFigure> available = byRarity.get((Object)rar);
        if (available.isEmpty()) {
            return null;
        }
        return available.get(r.nextInt(available.size()));
    }

    public static CardFigure getARandomFigure(String edition) {
        Random r = new Random();
        if (!initialized.booleanValue()) {
            FiguresRegisterer.init();
            return null;
        }
        if (!byEdition.containsKey(edition)) {
            return null;
        }
        ArrayList<CardFigure> available = byEdition.get(edition);
        if (available.isEmpty()) {
            return null;
        }
        return available.get(r.nextInt(available.size()));
    }
}

