/*
 * Decompiled with CFR 0.152.
 */
package com.is.core.mechanics;

import com.is.References.References_Rarity;
import com.is.core.cards.CardFigure;
import com.is.core.cards.FiguresRegisterer;
import com.is.other.StringCleaner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;

public class EditionsLoader {
    public static void readCollections() {
        File f = new File(System.getProperty("user.dir").replace("\\", "/") + "/MTC Editions");
        if (!f.exists()) {
            return;
        }
        System.out.println("[MTC] Looking for custom editions");
        for (File file : f.listFiles()) {
            if (!file.isFile() || !FilenameUtils.getExtension((String)file.getName()).equals("csv")) continue;
            String edition = StringCleaner.clean(FilenameUtils.removeExtension((String)file.getName()));
            System.out.println("[MTC] Reading csv file: " + file.getName());
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file.getPath()));
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                br.close();
                for (int i = 0; lines != null && i < lines.size(); ++i) {
                    String[] tokens = StringCleaner.clean((String)lines.get(i)).split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
                    if (tokens.length < 2) continue;
                    try {
                        References_Rarity.rarity r = References_Rarity.rarity.valueOf(tokens[1].toUpperCase());
                        CardFigure.register(tokens[0], r, edition, tokens.length >= 3 ? tokens[2] : "");
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println("[MTC_ERROR] Card " + tokens[0] + ": Incorrect value of an enum: " + e.getMessage());
                        System.out.println("[MTC_HELP] Waited for 'common', 'uncommon', 'rare', 'artifact'. Case unsensitive");
                    }
                }
            }
            catch (IOException e) {
                System.out.println("[MTC_ERROR] Error while reading a file in 'MTC Editions' folder: " + file.getName());
                e.printStackTrace();
            }
            System.out.println("[MTC_Info] Edition loaded: " + edition);
            FiguresRegisterer.dumpEditionData(edition);
        }
    }

    public static void setCollectionDirectory() {
        String exDir = System.getProperty("user.dir").replace("\\", "/");
        File modDir = new File(exDir + "/MTC Editions");
        if (!modDir.exists()) {
            modDir.mkdir();
        }
    }
}

