/*
 * Decompiled with CFR 0.152.
 */
package balkondeuralpha.freerunner;

import balkondeuralpha.freerunner.FRCommonProxy;
import balkondeuralpha.freerunner.Situation;
import balkondeuralpha.freerunner.moves.Move;
import balkondeuralpha.freerunner.moves.MoveAroundEdge;
import balkondeuralpha.freerunner.moves.MoveClimb;
import balkondeuralpha.freerunner.moves.MoveEject;
import balkondeuralpha.freerunner.moves.MovePushUp;
import balkondeuralpha.freerunner.moves.MoveRoll;
import balkondeuralpha.freerunner.moves.MoveUpBehind;
import balkondeuralpha.freerunner.moves.MoveWallrun;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntitiesClassAccess;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class FreerunPlayer
implements IExtendedEntityProperties {
    public Move move;
    public Situation situation;
    public int pauseTimer;
    public boolean paused;
    public double startPosY;
    public double startPosX;
    public double startPosZ;
    public double horizontalSpeed;
    public boolean isClimbing;
    public boolean wallRunning;
    public boolean freeRunning;
    public EntityPlayer player;
    private Move wallrun;
    private Move pushUp;
    private Move upBehind;
    private MoveClimb climbUp;
    private MoveClimb climbDown;
    private MoveClimb climbLeft;
    private MoveClimb climbRight;
    private MoveClimb climbAroundLeft;
    private MoveClimb climbAroundRight;
    private MoveEject ejectUp;
    private MoveEject ejectBack;
    private MoveEject ejectLeft;
    private MoveEject ejectRight;
    private MoveRoll roll;
    public static final int LOOK_WEST = 0;
    public static final int LOOK_NORTH = 1;
    public static final int LOOK_EAST = 2;
    public static final int LOOK_SOUTH = 3;

    public FreerunPlayer(EntityPlayer player) {
        this.player = player;
        this.freeRunning = false;
        this.horizontalSpeed = 0.0;
        this.addAllMoves();
    }

    public void addAllMoves() {
        this.climbUp = new MoveClimb(this, 1, 0.8f);
        this.climbDown = new MoveClimb(this, 2, 1.0f);
        this.climbLeft = new MoveClimb(this, 3, 1.0f);
        this.climbRight = new MoveClimb(this, 4, 1.0f);
        this.climbAroundLeft = new MoveAroundEdge(this, 3, 2.0f);
        this.climbAroundRight = new MoveAroundEdge(this, 4, 2.0f);
        this.ejectUp = new MoveEject(this, 1);
        this.ejectBack = new MoveEject(this, 2);
        this.ejectLeft = new MoveEject(this, 3);
        this.ejectRight = new MoveEject(this, 4);
        this.wallrun = new MoveWallrun(this);
        this.pushUp = new MovePushUp(this);
        this.upBehind = new MoveUpBehind(this);
        this.roll = new MoveRoll(this);
    }

    public static FreerunPlayer get(EntityPlayer entityPlayer) {
        return (FreerunPlayer)entityPlayer.getExtendedProperties("FreeRun");
    }

    public int canHopOver() {
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(true);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.isSelectedBlockClose(movingobjectposition, 2.0f) && this.isSelectedBlockOnLevel(movingobjectposition, 0)) {
            Block b = this.getSelectedBlock(movingobjectposition);
            Material m = this.getSelectedBlockMaterial(movingobjectposition);
            AxisAlignedBB boundingbox = b.func_149668_a(this.player.field_70170_p, movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d);
            if (m.func_76220_a() && this.isBlockAboveAir(2, false, this.isClimbing)) {
                if (boundingbox != null && boundingbox.field_72337_e - (double)movingobjectposition.field_72312_c > 1.0) {
                    return 2;
                }
                if (b.func_149669_A() > (double)this.player.field_70138_W && b.func_149669_A() <= 1.0 && b != Blocks.field_150476_ad && b != Blocks.field_150446_ar) {
                    return 1;
                }
            }
        }
        if (movingobjectposition == null || movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.ENTITY || movingobjectposition.field_72308_g == null) {
            return 0;
        }
        if (this.isSelectedEntityClose(movingobjectposition.field_72308_g, 2.0f) && this.isSelectedEntityOnLevel(movingobjectposition.field_72308_g, 0) && movingobjectposition.field_72308_g.field_70121_D.field_72337_e - movingobjectposition.field_72308_g.field_70121_D.field_72338_b <= 1.5) {
            return 3;
        }
        return 0;
    }

    public int canJumpOverGap() {
        int j = MathHelper.func_76128_c((double)(this.player.field_70121_D.field_72338_b - (double)0.1f));
        if (this.player.field_70122_E && !this.player.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.player.field_70165_t), j, MathHelper.func_76128_c((double)this.player.field_70161_v)).func_149688_o().func_76220_a()) {
            double d = -MathHelper.func_76126_a((float)(this.player.field_70177_z / 180.0f * (float)Math.PI));
            double d1 = MathHelper.func_76134_b((float)(this.player.field_70177_z / 180.0f * (float)Math.PI));
            if (this.player.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.player.field_70165_t + d)), j, MathHelper.func_76128_c((double)(this.player.field_70161_v + d1))).func_149688_o().func_76220_a()) {
                return 1;
            }
            if (this.player.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.player.field_70165_t + 2.0 * d)), j, MathHelper.func_76128_c((double)(this.player.field_70161_v + 2.0 * d1))).func_149688_o().func_76220_a()) {
                return 2;
            }
        }
        return 0;
    }

    public EntityLiving canLandOnMob(List list) {
        for (Object ent : list) {
            if (!(ent instanceof EntityLiving) || !this.isSelectedEntityClose((Entity)((EntityLiving)ent), 3.0f, 0.0, this.player.field_70181_x, 0.0)) continue;
            return (EntityLiving)ent;
        }
        return null;
    }

    public boolean canWallrun() {
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(true);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.isSelectedBlockClose(movingobjectposition, 2.0f)) {
            Material m = this.getSelectedBlockMaterial(movingobjectposition);
            Material m1 = this.getSelectedBlockMaterial(movingobjectposition, 0, 1, 0);
            if (this.isSelectedBlockOnLevel(movingobjectposition, 1)) {
                m = this.getSelectedBlockMaterial(movingobjectposition);
                m1 = this.getSelectedBlockMaterial(movingobjectposition, 0, -1, 0);
            }
            if (!m1.func_76220_a() && this.situation.canPushUp() != 0.0f) {
                return m.func_76220_a() && !EntitiesClassAccess.isJumping((EntityLivingBase)this.player);
            }
            return m.func_76220_a() && m1.func_76220_a() && !EntitiesClassAccess.isJumping((EntityLivingBase)this.player);
        }
        return false;
    }

    public int getLookDirection() {
        return MathHelper.func_76128_c((double)((double)(this.player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    public Block getSelectedBlock(MovingObjectPosition movingobjectposition) {
        return this.getSelectedBlock(movingobjectposition, 0, 0, 0);
    }

    public Block getSelectedBlock(MovingObjectPosition movingobjectposition, int addX, int addY, int addZ) {
        return this.player.field_70170_p.func_147439_a(movingobjectposition.field_72311_b + addX, movingobjectposition.field_72312_c + addY, movingobjectposition.field_72309_d + addZ);
    }

    public Material getSelectedBlockMaterial(MovingObjectPosition movingobjectposition) {
        return this.getSelectedBlockMaterial(movingobjectposition, 0, 0, 0);
    }

    public Material getSelectedBlockMaterial(MovingObjectPosition movingobjectposition, int addX, int addY, int addZ) {
        return this.getSelectedBlock(movingobjectposition, addX, addY, addZ).func_149688_o();
    }

    public void handleThings() {
        this.handleFreerunning();
        this.handleMoves();
    }

    public boolean hasBlockInFront() {
        double d = -MathHelper.func_76126_a((float)(this.player.field_70177_z / 180.0f * (float)Math.PI));
        double d1 = MathHelper.func_76134_b((float)(this.player.field_70177_z / 180.0f * (float)Math.PI));
        int i = MathHelper.func_76128_c((double)(this.player.field_70165_t + d));
        int j = MathHelper.func_76128_c((double)this.player.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)(this.player.field_70161_v + d1));
        return this.player.field_70170_p.func_147439_a(i, j, k).func_149688_o().func_76220_a();
    }

    public boolean isBlockAboveAir(int l, boolean blockAboveBlockIsSolid, boolean climbing) {
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(true);
        if (movingobjectposition == null || movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return false;
        }
        int i = movingobjectposition.field_72311_b;
        int j = movingobjectposition.field_72312_c + 1;
        int k = movingobjectposition.field_72309_d;
        Material m = this.player.field_70170_p.func_147439_a(i, j, k).func_149688_o();
        Material m1 = this.player.field_70170_p.func_147439_a(i, j + 1, k).func_149688_o();
        Material m2 = this.player.field_70170_p.func_147439_a(i, j + 2, k).func_149688_o();
        if (l == 1) {
            if (blockAboveBlockIsSolid) {
                return !m.func_76220_a() && m1.func_76220_a();
            }
            return !m.func_76220_a();
        }
        if (l == 2) {
            if (blockAboveBlockIsSolid) {
                return !m.func_76220_a() && !m1.func_76220_a() && m2.func_76220_a();
            }
            return !m.func_76220_a() && !m1.func_76220_a();
        }
        if (l == 3) {
            return !m.func_76220_a() && !m1.func_76220_a() && !m2.func_76220_a();
        }
        return !m.func_76220_a();
    }

    public boolean isHangingStill() {
        return this.isClimbing && this.move == null;
    }

    public boolean isMoving() {
        return this.move != null;
    }

    public boolean isMovingBackwards() {
        return this.player.field_70701_bs < 0.0f;
    }

    public boolean isMovingForwards() {
        return this.player.field_70701_bs > 0.0f;
    }

    public boolean isMovingLeft() {
        return this.player.field_70702_br > 0.0f;
    }

    public boolean isMovingRight() {
        return this.player.field_70702_br < 0.0f;
    }

    public boolean isOnCertainBlock(Block blockID) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.player.field_70165_t);
        return this.player.field_70170_p.func_147439_a(i, j = MathHelper.func_76128_c((double)(this.player.field_70121_D.field_72338_b - (double)0.1f + this.player.field_70181_x)), k = MathHelper.func_76128_c((double)this.player.field_70161_v)) == blockID;
    }

    public boolean isRolling() {
        return this.roll.animProgress < 1.0f;
    }

    public boolean isSelectedBlockClose(MovingObjectPosition movingobjectposition, float f) {
        return this.isSelectedBlockClose(movingobjectposition, f, 0.0, 0.0, 0.0);
    }

    public boolean isSelectedBlockClose(MovingObjectPosition movingobjectposition, float f, double addX, double addY, double addZ) {
        double d3;
        double d2;
        double d1 = Math.sqrt(Math.pow((double)movingobjectposition.field_72311_b + 0.5 + addX - this.player.field_70165_t, 2.0));
        double dXYZ = Math.sqrt(d1 * d1 + (d2 = Math.sqrt(Math.pow((double)movingobjectposition.field_72312_c + 0.5 + addY - this.player.field_70163_u, 2.0))) * d2 + (d3 = Math.sqrt(Math.pow((double)movingobjectposition.field_72309_d + 0.5 + addZ - this.player.field_70161_v, 2.0))) * d3);
        return dXYZ <= (double)f;
    }

    public boolean isSelectedBlockOnLevel(MovingObjectPosition movingobjectposition, int i) {
        int j = MathHelper.func_76128_c((double)this.player.field_70121_D.field_72338_b) + i;
        return j == movingobjectposition.field_72312_c;
    }

    public boolean isSelectedEntityClose(Entity ent, float f) {
        return this.isSelectedEntityClose(ent, f, 0.0, 0.0, 0.0);
    }

    public boolean isSelectedEntityClose(Entity ent, float f, double addX, double addY, double addZ) {
        double d3;
        double d2;
        double d1 = Math.sqrt(Math.pow(ent.field_70165_t + 0.5 + addX - this.player.field_70165_t, 2.0));
        double dXYZ = Math.sqrt(d1 * d1 + (d2 = Math.sqrt(Math.pow(ent.field_70163_u + 0.5 + addY - this.player.field_70163_u, 2.0))) * d2 + (d3 = Math.sqrt(Math.pow(ent.field_70161_v + 0.5 + addZ - this.player.field_70161_v, 2.0))) * d3);
        return dXYZ <= (double)f;
    }

    public boolean isSelectedEntityOnLevel(Entity ent, int i) {
        int j = MathHelper.func_76128_c((double)this.player.field_70121_D.field_72338_b) + i;
        return j == MathHelper.func_76128_c((double)ent.field_70121_D.field_72338_b);
    }

    public boolean isTooHungry() {
        return this.player.func_71024_bL().func_75116_a() <= 6;
    }

    public boolean isWallrunning() {
        return this.move instanceof MoveWallrun;
    }

    public MoveRoll getRoll() {
        return this.roll;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public void stopMove() {
        if (this.isMoving()) {
            this.move.moveDone();
        }
    }

    public void tryGrabLedge() {
        if (!this.player.field_70122_E && this.situation.canHangStill() && !this.isWallrunning()) {
            this.isClimbing = true;
            Vec3 vec3d = this.situation.getHangPositions();
            this.player.field_70159_w = vec3d.field_72450_a - this.player.field_70165_t;
            this.player.field_70181_x = vec3d.field_72448_b - this.player.field_70163_u;
            this.player.field_70179_y = vec3d.field_72449_c - this.player.field_70161_v;
        }
    }

    protected MovingObjectPosition getMovingObjectPositionFromPlayer(boolean par3) {
        float f = 1.0f;
        float f1 = this.player.field_70127_C + (this.player.field_70125_A - this.player.field_70127_C) * f;
        float f2 = this.player.field_70126_B + (this.player.field_70177_z - this.player.field_70126_B) * f;
        double d0 = this.player.field_70169_q + (this.player.field_70165_t - this.player.field_70169_q) * (double)f;
        double d1 = this.player.field_70167_r + (this.player.field_70163_u - this.player.field_70167_r) * (double)f + (double)(this.player.field_70170_p.field_72995_K ? this.player.func_70047_e() - this.player.getDefaultEyeHeight() : this.player.func_70047_e());
        double d2 = this.player.field_70166_s + (this.player.field_70161_v - this.player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (this.player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)this.player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return this.player.field_70170_p.func_147447_a(vec3, vec31, par3, !par3, false);
    }

    private void handleFreerunning() {
        if (this.isTooHungry()) {
            this.stopMove();
            return;
        }
        if (!this.player.func_70090_H() && !this.player.func_70058_J()) {
            if (this.player.field_70122_E || this.player.func_70093_af() || this.player.func_70617_f_()) {
                this.isClimbing = false;
                this.stopMove();
            }
            if (this.isClimbing) {
                this.player.func_71020_j(0.001f);
                this.player.field_70143_R = 0.0f;
                this.player.field_70179_y = 0.0;
                this.player.field_70181_x = 0.0;
                this.player.field_70159_w = 0.0;
                if (!this.situation.canHangStill() && !(this.move instanceof MoveAroundEdge)) {
                    this.isClimbing = false;
                } else if (this.isHangingStill()) {
                    Vec3 vec3d = this.situation.getHangPositions();
                    this.player.field_70159_w = vec3d.field_72450_a - this.player.field_70165_t;
                    this.player.field_70181_x = vec3d.field_72448_b - this.player.field_70163_u;
                    this.player.field_70179_y = vec3d.field_72449_c - this.player.field_70161_v;
                    int lookdirection = this.situation.lookDirection;
                    List<Move> moves = this.getMovesHangingStill();
                    for (Move mvoe : moves) {
                        if (mvoe == null || !mvoe.canPerform(this.situation)) continue;
                        mvoe.performMove(lookdirection);
                        break;
                    }
                }
                if (this.freeRunning && EntitiesClassAccess.isJumping((EntityLivingBase)this.player) && this.isHangingStill()) {
                    if (this.isMovingForwards() && !this.isWallrunning()) {
                        this.ejectUp.performMove(this.situation.lookDirection);
                    } else {
                        this.getEject().performMove(this.situation.lookDirection);
                    }
                }
                return;
            }
            if (this.freeRunning) {
                this.tryGrabLedge();
                if (!this.player.field_70122_E) {
                    if (FRCommonProxy.properties.enableWallKick && this.isWallrunning() && EntitiesClassAccess.isJumping((EntityLivingBase)this.player) && this.move.getAnimationProgress() > 0.3f) {
                        this.stopMove();
                        this.getEject().performMove(this.situation.lookDirection, 0.8f);
                    }
                    return;
                }
                if ((this.isMovingForwards() || this.player.field_70123_F) && !this.isRolling()) {
                    int i = this.canJumpOverGap();
                    int j = this.canHopOver();
                    if (!EntitiesClassAccess.isJumping((EntityLivingBase)this.player)) {
                        if (i == 1) {
                            this.player.func_70024_g(0.0, 0.35, 0.0);
                            EntitiesClassAccess.setJumping((EntityLivingBase)this.player);
                            this.player.func_71020_j(0.1f);
                        } else if (i == 2) {
                            this.player.func_70664_aZ();
                        }
                    }
                    if (j == 1 && !EntitiesClassAccess.isJumping((EntityLivingBase)this.player)) {
                        this.player.func_70664_aZ();
                    } else if (j > 1 || this.canWallrun()) {
                        this.wallrun.performMove(this.getLookDirection());
                    }
                }
            }
            if (this.isWallrunning()) {
                if (this.player.field_70124_G && !this.player.field_70122_E) {
                    this.move.moveDone();
                }
                this.tryGrabLedge();
            }
            return;
        }
    }

    private List<Move> getMovesHangingStill() {
        if (this.isMovingForwards()) {
            return Arrays.asList(this.upBehind, this.climbUp, this.pushUp);
        }
        if (this.isMovingBackwards()) {
            return Arrays.asList(this.climbDown);
        }
        if (this.isMovingLeft()) {
            return Arrays.asList(this.climbLeft, this.climbAroundLeft);
        }
        if (this.isMovingRight()) {
            return Arrays.asList(this.climbRight, this.climbAroundRight);
        }
        return new ArrayList<Move>(0);
    }

    private MoveEject getEject() {
        if (this.isMovingLeft()) {
            return this.ejectLeft;
        }
        if (this.isMovingRight()) {
            return this.ejectRight;
        }
        return this.ejectBack;
    }

    private void handleMoves() {
        if (!this.paused && this.move != null) {
            this.move.updateMove();
        }
        if (this.pauseTimer > 0) {
            --this.pauseTimer;
        } else {
            this.paused = false;
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tags = new NBTTagCompound();
        compound.func_74782_a("FreeRun", (NBTBase)tags);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound tags = compound.func_74775_l("FreeRun");
    }

    public void init(Entity entity, World world) {
    }
}

