/*
 * Decompiled with CFR 0.152.
 */
package balkondeuralpha.freerunner;

import balkondeuralpha.freerunner.FRCommonProxy;
import balkondeuralpha.freerunner.FreerunPlayer;
import balkondeuralpha.freerunner.Situation;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class PlayerEventHandler {
    private static final UUID freerunSpeed = UUID.fromString("7f4a5bc2-c657-457b-9ba1-7960db31e814");

    @SubscribeEvent
    public void afterDamageEntity(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            FreerunPlayer.get((EntityPlayer)((EntityPlayer)event.entityLiving)).isClimbing = false;
        }
    }

    @SubscribeEvent
    public void beforeFall(LivingFallEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            FreerunPlayer freeRunner = FreerunPlayer.get(player);
            if (freeRunner.freeRunning) {
                int i = MathHelper.func_76128_c((double)player.field_70165_t);
                int j = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b);
                int k = MathHelper.func_76128_c((double)player.field_70161_v);
                Block b = player.field_70170_p.func_147439_a(i, j, k);
                j = MathHelper.func_76128_c((double)(player.field_70121_D.field_72338_b + player.field_70181_x));
                Block b1 = player.field_70170_p.func_147439_a(i, j, k);
                Material material = b1.func_149688_o();
                List list = player.field_70170_p.func_72839_b((Entity)player, player.field_70121_D.func_72314_b(1.0, 2.0, 1.0));
                float f = event.distance;
                if (f > 3.0f && list != null && !list.isEmpty()) {
                    EntityLiving entityliving = freeRunner.canLandOnMob(list);
                    if (entityliving != null) {
                        entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 0.0f);
                        entityliving.func_70624_b((EntityLivingBase)player);
                        if (event.entity.field_70170_p.field_72995_K) {
                            entityliving.func_70057_ab();
                        }
                        player.field_70181_x *= (double)0.1f;
                        event.distance = 0.0f;
                    }
                } else if (b != b1 && material.func_76220_a() && material != Material.field_151586_h && material != Material.field_151587_i) {
                    event.distance = this.roll(player, freeRunner, f);
                }
            }
        }
    }

    private float roll(EntityPlayer player, FreerunPlayer freeRunner, float f) {
        int k;
        int j;
        if (!freeRunner.freeRunning || f < 3.0f) {
            return f;
        }
        float maxFall = 6.0f;
        if (f < maxFall) {
            return f /= 2.0f;
        }
        int i = MathHelper.func_76128_c((double)player.field_70165_t);
        Block b = player.field_70170_p.func_147439_a(i, j = MathHelper.func_76128_c((double)(player.field_70121_D.field_72338_b - (double)1.1f + player.field_70181_x)), k = MathHelper.func_76128_c((double)player.field_70161_v));
        if (b == Blocks.field_150422_aJ || b == Blocks.field_150386_bk || freeRunner.isOnCertainBlock((Block)Blocks.field_150362_t) || freeRunner.isOnCertainBlock(FRCommonProxy.barWood) || player.func_70090_H()) {
            return f /= 2.0f;
        }
        if (!freeRunner.isMovingForwards()) {
            return f *= 0.8f;
        }
        double d = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI));
        double d1 = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI));
        freeRunner.getRoll().start();
        player.func_70016_h(d, 0.0, d1);
        player.func_71020_j(0.3f);
        return f /= 2.0f;
    }

    @SubscribeEvent
    public void beforeOnUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            FreerunPlayer freeRunner = FreerunPlayer.get(player);
            freeRunner.situation = Situation.getSituation(player, freeRunner.getLookDirection());
            freeRunner.horizontalSpeed = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y);
            freeRunner.handleThings();
            IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            AttributeModifier mod = new AttributeModifier(freerunSpeed, "FreeRunSpeed", (double)(this.getSpeedModifier(player, freeRunner) - 1.0f), 2);
            if (mod.func_111164_d() > -1.0) {
                if (atinst.func_111127_a(freerunSpeed) == null) {
                    atinst.func_111121_a(mod);
                }
            } else if (atinst.func_111127_a(freerunSpeed) != null) {
                atinst.func_111124_b(mod);
            }
        }
    }

    public float getSpeedModifier(EntityPlayer player, FreerunPlayer freeRunner) {
        if (player.func_70051_ag() || freeRunner.isTooHungry()) {
            return -1.0f;
        }
        if (freeRunner.freeRunning) {
            return FRCommonProxy.properties.speedMultiplier;
        }
        if (!player.func_70090_H() && !player.func_70058_J() && player.field_70122_E && !freeRunner.isClimbing && FRCommonProxy.barWood != null && freeRunner.isOnCertainBlock(FRCommonProxy.barWood)) {
            return 0.5f;
        }
        return -1.0f;
    }

    @SubscribeEvent
    public void onPlayerConstruction(EntityEvent.EntityConstructing event) {
        FreerunPlayer runner;
        if (event.entity instanceof EntityPlayer && (runner = FreerunPlayer.get((EntityPlayer)event.entity)) == null) {
            runner = new FreerunPlayer((EntityPlayer)event.entity);
            event.entity.registerExtendedProperties("FreeRun", (IExtendedEntityProperties)runner);
        }
    }
}

