/*
 * Decompiled with CFR 0.152.
 */
package balkondeuralpha.freerunner;

import balkondeuralpha.freerunner.FRCommonProxy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Situation {
    private static List<Block> climbableBlocks;
    private static List<Block> climbableInside;
    private World worldObj;
    public float blockHeight = 1.0f;
    public int lookDirection;
    private int posX;
    private int posY;
    private int posZ;
    private int nextPosX;
    private int nextPosY;
    private int nextPosZ;

    private Situation(double x, double y, double z, int lookdirection, World world) {
        this.nextPosX = this.posX = MathHelper.func_76128_c((double)x);
        this.nextPosY = this.posY = (int)Math.ceil(y);
        this.nextPosZ = this.posZ = MathHelper.func_76128_c((double)z);
        this.lookDirection = lookdirection;
        this.worldObj = world;
    }

    public boolean canClimbAroundEdgeLeft() {
        boolean flag = false;
        int i = this.lookDirection;
        this.lookDirection = (this.lookDirection + 1) % 4;
        if (i == 0) {
            this.nextPosX = this.posX + 1;
            this.nextPosZ = this.posZ + 1;
            flag = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.nextPosZ);
        } else if (i == 1) {
            this.nextPosZ = this.posZ + 1;
            this.nextPosX = this.posX - 1;
            flag = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.nextPosZ);
        } else if (i == 2) {
            this.nextPosX = this.posX - 1;
            this.nextPosZ = this.posZ - 1;
            flag = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.nextPosZ);
        } else if (i == 3) {
            this.nextPosZ = this.posZ - 1;
            this.nextPosX = this.posX + 1;
            flag = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.nextPosZ);
        }
        this.lookDirection = i;
        return flag;
    }

    public boolean canClimbAroundEdgeRight() {
        boolean flag = false;
        int i = this.lookDirection;
        this.lookDirection = (this.lookDirection - 1) % 4;
        if (i == 0) {
            this.nextPosX = this.posX + 1;
            this.nextPosZ = this.posZ + 1;
            flag = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.nextPosZ);
        } else if (i == 1) {
            this.nextPosZ = this.posZ + 1;
            this.nextPosX = this.posX - 1;
            flag = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.nextPosZ);
        } else if (i == 2) {
            this.nextPosX = this.posX - 1;
            this.nextPosZ = this.posZ - 1;
            flag = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.nextPosZ);
        } else if (i == 3) {
            this.nextPosZ = this.posZ - 1;
            this.nextPosX = this.posX + 1;
            flag = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.nextPosZ);
        }
        this.lookDirection = i;
        return flag;
    }

    public boolean canClimbDown() {
        return this.hasEdgeDown();
    }

    public boolean canClimbLeft() {
        return this.hasEdgeLeft();
    }

    public boolean canClimbRight() {
        return this.hasEdgeRight();
    }

    public boolean canClimbUp() {
        return this.hasEdgeUp();
    }

    public boolean canHangStill() {
        return this.hasEdgeOnLocation(this.posX, this.posY, this.posZ);
    }

    public float canPushUp() {
        if (this.canClimbUp() || !this.canHangStill()) {
            return 0.0f;
        }
        int x = this.posX;
        int y = this.posY - 1;
        int z = this.posZ;
        boolean flag = this.hasAirAbove(x, y, z, 2);
        if (this.lookDirection == 0) {
            ++z;
        } else if (this.lookDirection == 1) {
            --x;
        } else if (this.lookDirection == 2) {
            --z;
        } else if (this.lookDirection == 3) {
            ++x;
        }
        Material material = this.worldObj.func_147439_a(x, y, z).func_149688_o();
        if (material.func_76220_a() && this.hasAirAbove(x, y, z, 2) && flag) {
            AxisAlignedBB bb;
            float f = y;
            Block block = this.worldObj.func_147439_a(x, y, z);
            if (block != null && (bb = block.func_149668_a(this.worldObj, x, y, z)) != null) {
                f = (float)((double)f + (bb.field_72337_e - (double)y - 1.0));
            }
            return f;
        }
        return 0.0f;
    }

    public Vec3 getHangPositions() {
        double x = (double)this.posX + 0.5;
        double y = (double)this.posY - 0.1 - (double)(1.0f - this.blockHeight);
        double z = (double)this.posZ + 0.5;
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    private boolean hasAirAbove(int x, int y, int z, int i) {
        if (i >= 1) {
            Material material = this.worldObj.func_147439_a(x, y + 1, z).func_149688_o();
            if (i >= 2) {
                Material material1 = this.worldObj.func_147439_a(x, y + 2, z).func_149688_o();
                return !material.func_76220_a() && !material1.func_76220_a();
            }
            return !material.func_76220_a();
        }
        return false;
    }

    private boolean hasEdgeDown() {
        this.nextPosY = this.posY - 1;
        return this.hasEdgeOnLocation(this.posX, this.nextPosY, this.posZ);
    }

    private boolean hasEdgeLeft() {
        boolean b = false;
        if (this.lookDirection == 0) {
            this.nextPosX = this.posX + 1;
            b = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.posZ);
        } else if (this.lookDirection == 1) {
            this.nextPosZ = this.posZ + 1;
            b = this.hasEdgeOnLocation(this.posX, this.posY, this.nextPosZ);
        } else if (this.lookDirection == 2) {
            this.nextPosX = this.posX - 1;
            b = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.posZ);
        } else if (this.lookDirection == 3) {
            this.nextPosZ = this.posZ - 1;
            b = this.hasEdgeOnLocation(this.posX, this.posY, this.nextPosZ);
        }
        return b;
    }

    private boolean hasEdgeOnLocation(int x, int y, int z) {
        Block b = this.worldObj.func_147439_a(x, y - 1, z);
        Block b1 = this.worldObj.func_147439_a(x, y, z);
        int md = this.worldObj.func_72805_g(x, y - 1, z);
        int md1 = this.getMetaData();
        if (b1 == Blocks.field_150395_bd || md == 0 || md == md1) {
            if (climbableInside.contains(b)) {
                return true;
            }
            if (b1.func_149688_o().func_76220_a() || b.func_149688_o().func_76220_a()) {
                return false;
            }
        }
        if (this.lookDirection == 0) {
            ++z;
        } else if (this.lookDirection == 1) {
            --x;
        } else if (this.lookDirection == 2) {
            --z;
        } else if (this.lookDirection == 3) {
            ++x;
        }
        b = this.worldObj.func_147439_a(x, y - 1, z);
        b1 = this.worldObj.func_147439_a(x, y, z);
        if (climbableInside.contains(b)) {
            return false;
        }
        if (climbableBlocks.contains(b)) {
            this.blockHeight = (float)b.func_149669_A();
            return true;
        }
        if (b.func_149688_o().func_76220_a() && b != b1) {
            this.blockHeight = (float)b.func_149669_A();
            return (!Situation.isStoneOre(b) || !Situation.isStoneOre(b1)) && (b != Blocks.field_150346_d && b != Blocks.field_150349_c || b1 != Blocks.field_150346_d && b1 != Blocks.field_150349_c) && (b != Blocks.field_150347_e && b != Blocks.field_150341_Y && b != Blocks.field_150446_ar || b1 != Blocks.field_150347_e && b1 != Blocks.field_150341_Y && b1 != Blocks.field_150446_ar) && (b != Blocks.field_150344_f && b != Blocks.field_150389_bf || b1 != Blocks.field_150344_f && b1 != Blocks.field_150389_bf);
        }
        this.blockHeight = 1.0f;
        return false;
    }

    public static boolean isStoneOre(Block b) {
        return b == Blocks.field_150348_b || b == Blocks.field_150352_o || b == Blocks.field_150366_p || b == Blocks.field_150365_q || b == Blocks.field_150369_x || b == Blocks.field_150482_ag || b == Blocks.field_150450_ax || b == Blocks.field_150439_ay;
    }

    private boolean hasEdgeRight() {
        boolean b = false;
        if (this.lookDirection == 0) {
            this.nextPosX = this.posX - 1;
            b = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.posZ);
        } else if (this.lookDirection == 1) {
            this.nextPosZ = this.posZ - 1;
            b = this.hasEdgeOnLocation(this.posX, this.posY, this.nextPosZ);
        } else if (this.lookDirection == 2) {
            this.nextPosX = this.posX + 1;
            b = this.hasEdgeOnLocation(this.nextPosX, this.posY, this.posZ);
        } else if (this.lookDirection == 3) {
            this.nextPosZ = this.posZ + 1;
            b = this.hasEdgeOnLocation(this.posX, this.posY, this.nextPosZ);
        }
        return b;
    }

    private boolean hasEdgeUp() {
        this.nextPosY = this.posY + 1;
        return this.hasEdgeOnLocation(this.posX, this.nextPosY, this.posZ);
    }

    public boolean hasEdgeUpBehind() {
        boolean b = false;
        this.nextPosY = this.posY + 2;
        if (this.lookDirection == 0) {
            this.nextPosZ = this.posZ - 1;
            b = this.hasEdgeOnLocation(this.posX, this.nextPosY, this.nextPosZ);
        } else if (this.lookDirection == 1) {
            this.nextPosX = this.posX + 1;
            b = this.hasEdgeOnLocation(this.nextPosX, this.nextPosY, this.posZ);
        } else if (this.lookDirection == 2) {
            this.nextPosZ = this.posZ + 1;
            b = this.hasEdgeOnLocation(this.posX, this.nextPosY, this.nextPosZ);
        } else if (this.lookDirection == 3) {
            this.nextPosX = this.posX - 1;
            b = this.hasEdgeOnLocation(this.nextPosX, this.nextPosY, this.posZ);
        }
        return b;
    }

    public int getMetaData() {
        if (this.lookDirection == 0) {
            return 2;
        }
        if (this.lookDirection == 1) {
            return 5;
        }
        if (this.lookDirection == 2) {
            return 3;
        }
        if (this.lookDirection == 3) {
            return 4;
        }
        return 0;
    }

    public static Situation getSituation(EntityPlayer player, int lookdirection) {
        return new Situation(player.field_70165_t, player.field_70163_u, player.field_70161_v, lookdirection, player.field_70170_p);
    }

    private static void addAllClimableBlocks() {
        climbableBlocks = new ArrayList<Block>();
        climbableInside = new ArrayList<Block>();
        climbableBlocks.add((Block)Blocks.field_150362_t);
        climbableBlocks.add(Blocks.field_150367_z);
        climbableBlocks.add(Blocks.field_150323_B);
        climbableBlocks.add(Blocks.field_150324_C);
        climbableBlocks.add((Block)Blocks.field_150373_bw);
        climbableBlocks.add((Block)Blocks.field_150376_bx);
        climbableBlocks.add(Blocks.field_150342_X);
        climbableBlocks.add(Blocks.field_150458_ak);
        climbableBlocks.add(Blocks.field_150474_ac);
        climbableBlocks.add((Block)Blocks.field_150486_ae);
        climbableBlocks.add(Blocks.field_150462_ai);
        climbableBlocks.add(Blocks.field_150460_al);
        climbableBlocks.add(Blocks.field_150470_am);
        climbableBlocks.add(Blocks.field_150444_as);
        climbableBlocks.add(Blocks.field_150472_an);
        climbableBlocks.add(Blocks.field_150466_ao);
        climbableBlocks.add(Blocks.field_150454_av);
        climbableBlocks.add((Block)Blocks.field_150331_J);
        climbableBlocks.add((Block)Blocks.field_150320_F);
        climbableBlocks.add((Block)Blocks.field_150326_M);
        climbableBlocks.add(Blocks.field_150446_ar);
        climbableBlocks.add(Blocks.field_150421_aI);
        climbableBlocks.add(Blocks.field_150423_aK);
        climbableBlocks.add(Blocks.field_150428_aP);
        climbableBlocks.add(Blocks.field_150422_aJ);
        climbableBlocks.add(Blocks.field_150415_aT);
        climbableBlocks.add(Blocks.field_150386_bk);
        climbableBlocks.add(Blocks.field_150387_bl);
        climbableBlocks.add(Blocks.field_150390_bg);
        climbableBlocks.add(Blocks.field_150389_bf);
        climbableBlocks.add(Blocks.field_150396_be);
        climbableBlocks.add(Blocks.field_150447_bR);
        climbableBlocks.add(Blocks.field_150381_bn);
        if (FRCommonProxy.barWood != null) {
            climbableBlocks.add(FRCommonProxy.barWood);
        }
        climbableInside.add(Blocks.field_150430_aB);
        climbableInside.add(Blocks.field_150471_bO);
        climbableInside.add(Blocks.field_150411_aY);
        if (FRCommonProxy.edgeWood != null) {
            climbableInside.add(FRCommonProxy.edgeWood);
        }
        if (FRCommonProxy.edgeStone != null) {
            climbableInside.add(FRCommonProxy.edgeStone);
        }
    }

    static {
        Situation.addAllClimableBlocks();
    }
}

