/*
 * Decompiled with CFR 0.152.
 */
package balkondeuralpha.freerunner.client;

import balkondeuralpha.freerunner.FRCommonProxy;
import balkondeuralpha.freerunner.animations.AnimRoll;
import balkondeuralpha.freerunner.animations.AnimWallrun;
import balkondeuralpha.freerunner.animations.Animation;
import balkondeuralpha.freerunner.blocks.BlockWoodBar;
import balkondeuralpha.freerunner.client.Animator;
import balkondeuralpha.freerunner.client.CustomBlockRenderer;
import balkondeuralpha.freerunner.client.RunnerTickHandler;
import balkondeuralpha.freerunner.moves.Move;
import balkondeuralpha.freerunner.moves.MoveRoll;
import balkondeuralpha.freerunner.moves.MoveWallrun;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;

public class FRClientProxy
extends FRCommonProxy {
    @Override
    public void registerThings(FMLPreInitializationEvent event) {
        super.registerThings(event);
        FMLCommonHandler.instance().bus().register((Object)new RunnerTickHandler());
        if (FRClientProxy.properties.enableBarWood) {
            BlockWoodBar.barWoodModel = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new CustomBlockRenderer());
        }
        if (FRClientProxy.properties.enableAnimations) {
            MinecraftForge.EVENT_BUS.register((Object)new Animator());
        }
    }

    @Override
    public EntityPlayer getPlayer(MessageContext context) {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    public void setAnimation(Move move) {
        if (move instanceof MoveRoll) {
            move.setAnimation(new AnimRoll(move.getPlayer()));
        } else if (move instanceof MoveWallrun) {
            move.setAnimation(new AnimWallrun());
        }
    }

    @Override
    public void startAnimation(Move move) {
        Animation anim = move.getAnimation();
        if (anim != null) {
            anim.set(move);
        }
    }
}

