/*
 * Decompiled with CFR 0.152.
 */
package balkondeuralpha.freerunner.moves;

import balkondeuralpha.freerunner.FreerunPlayer;
import balkondeuralpha.freerunner.Situation;
import balkondeuralpha.freerunner.animations.Animation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;

public abstract class Move {
    public double startPosX;
    public double startPosY;
    public double startPosZ;
    @SideOnly(value=Side.CLIENT)
    protected Animation animation;
    public float animProgress;
    public float prevAnimProgress;
    protected int lookDirection;
    protected FreerunPlayer freerunEngine;
    protected double nextMotionX;
    protected double nextMotionY;
    protected double nextMotionZ;
    protected int blockings;
    protected double[] deltaPos;
    protected double[] prevDeltaPos;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_LEFT = 3;
    public static final int DIRECTION_RIGHT = 4;

    protected Move(FreerunPlayer freerunhandler) {
        this.freerunEngine = freerunhandler;
        this.lookDirection = 0;
        this.blockings = 0;
        this.nextMotionZ = 0.0;
        this.nextMotionY = 0.0;
        this.nextMotionX = 0.0;
        this.prevAnimProgress = 0.0f;
        this.animProgress = 0.0f;
        this.deltaPos = new double[3];
        this.prevDeltaPos = new double[3];
    }

    public double distanceFromStart(double x, double y, double z) {
        double dx = x - this.startPosX;
        double dy = y - this.startPosY;
        double dz = z - this.startPosZ;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @SideOnly(value=Side.CLIENT)
    public final Animation getAnimation() {
        return this.animation;
    }

    @SideOnly(value=Side.CLIENT)
    public final void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public abstract float getAnimationProgress();

    public void moveDone() {
        this.abortMove();
    }

    public boolean canPerform(Situation situation) {
        return false;
    }

    public void performMove(int lookdirection) {
        if (this.freerunEngine.paused) {
            return;
        }
        this.lookDirection = lookdirection;
        this.startPosX = this.getPlayer().field_70165_t;
        this.startPosY = this.getPlayer().field_70163_u;
        this.startPosZ = this.getPlayer().field_70161_v;
        this.freerunEngine.setMove(this);
    }

    public void updateMove() {
        this.prevAnimProgress = this.animProgress;
        this.animProgress = Math.min(Math.max(this.getAnimationProgress(), 0.0f), 1.0f);
    }

    @Deprecated
    protected boolean canMoveFurther(EntityPlayer entityplayer) {
        for (int i = 0; i < 3; ++i) {
            this.prevDeltaPos[i] = this.deltaPos[i];
            this.deltaPos[i] = i == 0 ? entityplayer.field_70165_t - this.startPosX : (i == 1 ? entityplayer.field_70163_u - this.startPosY : entityplayer.field_70161_v - this.startPosZ);
            if (this.deltaPos[i] != this.prevDeltaPos[i]) continue;
            ++this.blockings;
        }
        return this.blockings < 15;
    }

    protected void doMoves() {
        this.getPlayer().field_70159_w = this.nextMotionX;
        this.getPlayer().field_70181_x = this.nextMotionY;
        this.getPlayer().field_70179_y = this.nextMotionZ;
    }

    private void abortMove() {
        this.blockings = 0;
        this.nextMotionX = 0.0;
        this.nextMotionY = 0.0;
        this.nextMotionZ = 0.0;
        if (this.equals(this.freerunEngine.move)) {
            this.freerunEngine.setMove(null);
        }
    }

    public void addMovementPause(int ticks) {
        this.freerunEngine.paused = true;
        this.freerunEngine.pauseTimer = ticks;
    }

    public EntityPlayer getPlayer() {
        return this.freerunEngine.player;
    }
}

