/*
 * Decompiled with CFR 0.152.
 */
package com.pam.bonecraft;

import com.pam.bonecraft.ItemModelList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class ItemModels {
    private static final HashMap<Item, ItemModelList> models = new HashMap();

    public static void preInit() {
        ItemModels.defineItemModels();
        ItemModels.prepareModels();
    }

    public static void init() {
        ItemModels.registerModels();
    }

    private static void defineItemModels() {
    }

    private static void registerItemModels(Item item, ItemModelList list) {
        models.put(item, list);
    }

    private static void prepareModels() {
        for (Map.Entry<Item, ItemModelList> entry : models.entrySet()) {
            Item item = entry.getKey();
            Collection<String> registrations = entry.getValue().getRegistrations().values();
            for (String registration : registrations) {
                if (item == null || registration == null) continue;
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(registration)});
            }
        }
    }

    private static void registerModels() {
        for (Map.Entry<Item, ItemModelList> entry : models.entrySet()) {
            Item item = entry.getKey();
            HashMap<Integer, String> registrations = entry.getValue().getRegistrations();
            for (Map.Entry<Integer, String> registration : registrations.entrySet()) {
                int meta = registration.getKey();
                String path = registration.getValue();
                ModelResourceLocation resource = new ModelResourceLocation(path, "inventory");
                Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, resource);
            }
        }
    }

    private static Item getItem(Block block) {
        return Item.func_150898_a((Block)block);
    }
}

