/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.gates;

import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionProvider;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.transport.IPipeTile;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;

public final class ActionManager {
    public static Map<String, ITrigger> triggers = new HashMap<String, ITrigger>();
    public static Map<String, IAction> actions = new HashMap<String, IAction>();
    private static List<ITriggerProvider> triggerProviders = new LinkedList<ITriggerProvider>();
    private static List<IActionProvider> actionProviders = new LinkedList<IActionProvider>();

    private ActionManager() {
    }

    public static void registerTriggerProvider(ITriggerProvider provider) {
        if (provider != null && !triggerProviders.contains(provider)) {
            triggerProviders.add(provider);
        }
    }

    public static void registerTrigger(ITrigger trigger) {
        triggers.put(trigger.getUniqueTag(), trigger);
    }

    public static void registerAction(IAction action) {
        actions.put(action.getUniqueTag(), action);
    }

    public static List<ITrigger> getNeighborTriggers(Block block, TileEntity entity) {
        LinkedList<ITrigger> result = new LinkedList<ITrigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList<ITrigger> toAdd = provider.getNeighborTriggers(block, entity);
            if (toAdd == null) continue;
            for (ITrigger t : toAdd) {
                if (result.contains(t)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public static void registerActionProvider(IActionProvider provider) {
        if (provider != null && !actionProviders.contains(provider)) {
            actionProviders.add(provider);
        }
    }

    public static List<IAction> getNeighborActions(Block block, TileEntity entity) {
        LinkedList<IAction> result = new LinkedList<IAction>();
        for (IActionProvider provider : actionProviders) {
            LinkedList<IAction> toAdd = provider.getNeighborActions(block, entity);
            if (toAdd == null) continue;
            for (IAction t : toAdd) {
                if (result.contains(t)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public static List<ITrigger> getPipeTriggers(IPipeTile pipe) {
        LinkedList<ITrigger> result = new LinkedList<ITrigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList<ITrigger> toAdd = provider.getPipeTriggers(pipe);
            if (toAdd == null) continue;
            for (ITrigger t : toAdd) {
                if (result.contains(t)) continue;
                result.add(t);
            }
        }
        return result;
    }
}

