/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.blueprints.ITileBuilder;
import buildcraft.api.core.NetworkData;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.mj.MjBattery;
import buildcraft.builders.BuildingItem;
import buildcraft.core.IBoxProvider;
import buildcraft.core.LaserData;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCMessageInfo;
import buildcraft.core.network.RPCSide;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileAbstractBuilder
extends TileBuildCraft
implements ITileBuilder,
IInventory,
IBoxProvider {
    private static final double FULL_CHEST_ENERGY = 35560.0;
    @NetworkData
    public LinkedList<LaserData> pathLasers = new LinkedList();
    public ArrayList<BuildingItem> buildersInAction = new ArrayList();
    protected SafeTimeTracker buildTracker = new SafeTimeTracker(5L);
    @MjBattery(maxReceivedPerCycle=100.0, maxCapacity=35560.0, minimumConsumption=1.0)
    protected double mjStored = 0.0;
    private double mjPrev = 0.0;
    private int mjUnchangedCycles = 0;

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_145850_b.field_72995_K) {
            RPCHandler.rpcServer(this, "uploadBuildersInAction", new Object[0]);
        }
    }

    @RPC(value=RPCSide.SERVER)
    private void uploadBuildersInAction(RPCMessageInfo info) {
        for (BuildingItem i : this.buildersInAction) {
            RPCHandler.rpcPlayer(this, "launchItem", info.sender, i);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.mjPrev != this.mjStored) {
            this.mjPrev = this.mjStored;
            this.mjUnchangedCycles = 0;
        }
        BuildingItem toRemove = null;
        for (BuildingItem i : this.buildersInAction) {
            i.update();
            if (!i.isDone) continue;
            toRemove = i;
        }
        if (toRemove != null) {
            this.buildersInAction.remove(toRemove);
        }
        if (this.mjPrev != this.mjStored) {
            this.mjPrev = this.mjStored;
            this.mjUnchangedCycles = 0;
        }
        ++this.mjUnchangedCycles;
        if (this.mjUnchangedCycles > 100) {
            this.mjStored -= 100.0;
            if (this.mjStored < 0.0) {
                this.mjStored = 0.0;
            }
            this.mjPrev = this.mjStored;
        }
    }

    public ArrayList<BuildingItem> getBuilders() {
        return this.buildersInAction;
    }

    public LinkedList<LaserData> getPathLaser() {
        return this.pathLasers;
    }

    @RPC(value=RPCSide.CLIENT)
    public void launchItem(BuildingItem item) {
        this.buildersInAction.add(item);
    }

    public void addBuildingItem(BuildingItem item) {
        this.buildersInAction.add(item);
        RPCHandler.rpcBroadcastPlayers(this, "launchItem", item);
    }

    public final double energyAvailable() {
        return this.mjStored;
    }

    public final void consumeEnergy(double quantity) {
        this.mjStored -= quantity;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("mjStored", this.mjStored);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.mjPrev = this.mjStored = nbttagcompound.func_74769_h("mjStored");
        this.mjUnchangedCycles = 0;
    }
}

