/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.NetworkData;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.core.BlockIndex;
import buildcraft.core.BlockScanner;
import buildcraft.core.Box;
import buildcraft.core.IBoxProvider;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BlueprintReadConfiguration;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.Template;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCSide;
import buildcraft.core.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileArchitect
extends TileBuildCraft
implements IInventory,
IBoxProvider {
    private static final int SCANNER_ITERATION = 100;
    public int computingTime = 0;
    public String currentAuthorName = "";
    @NetworkData
    public Box box = new Box();
    @NetworkData
    public String name = "";
    @NetworkData
    public BlueprintReadConfiguration readConfiguration = new BlueprintReadConfiguration();
    private SimpleInventory inv = new SimpleInventory(2, "Architect", 1);
    private BlueprintBase writingBlueprint;
    private BptContext writingContext;
    private BlockScanner blockScanner;

    public TileArchitect() {
        this.box.kind = Box.Kind.STRIPES;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.blockScanner != null) {
            if (this.blockScanner.blocksLeft() != 0) {
                for (BlockIndex index : this.blockScanner) {
                    this.writingBlueprint.readFromWorld(this.writingContext, this, index.x, index.y, index.z);
                }
                this.computingTime = (int)((1.0f - (float)this.blockScanner.blocksLeft() / (float)this.blockScanner.totalBlocks()) * 100.0f);
                if (this.blockScanner.blocksLeft() == 0) {
                    this.writingBlueprint.readEntitiesFromWorld(this.writingContext, this);
                    Translation transform = new Translation();
                    transform.x = -this.writingContext.surroundingBox().pMin().x;
                    transform.y = -this.writingContext.surroundingBox().pMin().y;
                    transform.z = -this.writingContext.surroundingBox().pMin().z;
                    this.writingBlueprint.translateToBlueprint(transform);
                    ForgeDirection o = ForgeDirection.values()[this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)].getOpposite();
                    this.writingBlueprint.rotate = this.readConfiguration.rotate;
                    this.writingBlueprint.excavate = this.readConfiguration.excavate;
                    if (this.writingBlueprint.rotate && o != ForgeDirection.EAST) {
                        if (o == ForgeDirection.SOUTH) {
                            this.writingBlueprint.rotateLeft(this.writingContext);
                            this.writingBlueprint.rotateLeft(this.writingContext);
                            this.writingBlueprint.rotateLeft(this.writingContext);
                        } else if (o == ForgeDirection.WEST) {
                            this.writingBlueprint.rotateLeft(this.writingContext);
                            this.writingBlueprint.rotateLeft(this.writingContext);
                        } else if (o == ForgeDirection.NORTH) {
                            this.writingBlueprint.rotateLeft(this.writingContext);
                        }
                    }
                }
            } else if (this.writingBlueprint.getData() != null) {
                this.createBlueprint();
                this.computingTime = 0;
            }
        }
    }

    @Override
    public void initialize() {
        IAreaProvider a;
        super.initialize();
        if (!this.field_145850_b.field_72995_K && !this.box.isInitialized() && (a = Utils.getNearbyAreaProvider(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) != null) {
            this.box.initialize(a);
            a.removeFromWorld();
            this.sendNetworkUpdate();
        }
    }

    public void createBlueprint() {
        this.writingBlueprint.id.name = this.name;
        BuildCraftBuilders.serverDB.add(this.writingBlueprint);
        this.func_70299_a(1, this.writingBlueprint.getStack());
        this.func_70299_a(0, null);
        this.writingBlueprint = null;
        this.writingContext = null;
        this.blockScanner = null;
    }

    @RPC(value=RPCSide.SERVER)
    public void handleClientSetName(String nameSet) {
        this.name = nameSet;
        RPCHandler.rpcBroadcastPlayers(this, "setName", this.name);
    }

    @RPC
    public void setName(String name) {
        this.name = name;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result = this.inv.func_70298_a(i, j);
        if (i == 0) {
            this.initializeComputing();
        }
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        if (i == 0) {
            this.initializeComputing();
        }
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "Template";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
        }
        this.inv.readFromNBT(nbttagcompound);
        this.name = nbttagcompound.func_74779_i("name");
        this.currentAuthorName = nbttagcompound.func_74779_i("lastAuthor");
        if (nbttagcompound.func_74764_b("readConfiguration")) {
            this.readConfiguration.readFromNBT(nbttagcompound.func_74775_l("readConfiguration"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbttagcompound.func_74782_a("box", (NBTBase)boxStore);
        }
        this.inv.writeToNBT(nbttagcompound);
        nbttagcompound.func_74778_a("name", this.name);
        nbttagcompound.func_74778_a("lastAuthor", this.currentAuthorName);
        NBTTagCompound readConf = new NBTTagCompound();
        this.readConfiguration.writeToNBT(readConf);
        nbttagcompound.func_74782_a("readConfiguration", (NBTBase)readConf);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    private void initializeComputing() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (!this.box.isInitialized()) {
            return;
        }
        if (this.blockScanner == null) {
            if (this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemBlueprint && this.func_70301_a(1) == null) {
                if (!this.box.isInitialized() || this.func_70301_a(1) != null) {
                    return;
                }
                this.blockScanner = new BlockScanner(this.box, this.getWorld(), 100);
                if (this.func_70301_a(0).func_77973_b() instanceof ItemBlueprintStandard) {
                    this.writingBlueprint = new Blueprint(this.box.sizeX(), this.box.sizeY(), this.box.sizeZ());
                } else if (this.func_70301_a(0).func_77973_b() instanceof ItemBlueprintTemplate) {
                    this.writingBlueprint = new Template(this.box.sizeX(), this.box.sizeY(), this.box.sizeZ());
                }
                this.writingContext = this.writingBlueprint.getContext(this.field_145850_b, this.box);
                this.writingContext.readConfiguration = this.readConfiguration;
                this.writingBlueprint.id.name = this.name;
                this.writingBlueprint.author = this.currentAuthorName;
                this.writingBlueprint.anchorX = this.field_145851_c - this.box.xMin;
                this.writingBlueprint.anchorY = this.field_145848_d - this.box.yMin;
                this.writingBlueprint.anchorZ = this.field_145849_e - this.box.zMin;
            }
        } else {
            this.blockScanner = null;
            this.writingBlueprint = null;
            this.writingContext = null;
        }
    }

    public int getComputingProgressScaled(int scale) {
        return (int)((float)this.computingTime / 100.0f * (float)scale);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return false;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Box(this).extendToEncompass(this.box).getBoundingBox();
    }

    @RPC(value=RPCSide.SERVER)
    private void setReadConfiguration(BlueprintReadConfiguration conf) {
        this.readConfiguration = conf;
        this.sendNetworkUpdate();
    }

    public void rpcSetConfiguration(BlueprintReadConfiguration conf) {
        this.readConfiguration = conf;
        RPCHandler.rpcServer(this, "setReadConfiguration", conf);
    }
}

