/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.core.BlockBuildCraft;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.render.IconFlipped;
import buildcraft.core.render.RenderBlockMultiTexture;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockMultiTexture
extends BlockBuildCraft {
    private static Map<String, IIcon> iconMap = new HashMap<String, IIcon>();

    public BlockMultiTexture(Material material, CreativeTabBuildCraft tab) {
        super(material, tab);
    }

    public static int getUVTopForFront(int front) {
        switch (front) {
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
        }
        return 0;
    }

    public abstract int getFrontSide(IBlockAccess var1, int var2, int var3, int var4);

    public abstract String getIconPrefix();

    public boolean shouldFlipU(IBlockAccess world, int x, int y, int z, int side) {
        int front = this.getFrontSide(world, x, y, z);
        return front == 4 && side == 2 || front == 5 && side == 5 || front == 5 && side == 2 || front == 2 && side == 5 || front == 2 && side == 2 || front == 3 && side == 5 || this.shouldFlipU(side, this.getFrontSide(world, x, y, z));
    }

    public boolean shouldFlipV(IBlockAccess world, int x, int y, int z, int side) {
        return this.shouldFlipV(side, this.getFrontSide(world, x, y, z));
    }

    public boolean shouldFlipU(int side, int front) {
        return front == 3;
    }

    public boolean shouldFlipV(int side, int front) {
        return false;
    }

    public String getIconPostfix(IBlockAccess world, int x, int y, int z, int side) {
        return this.getIconPostfix(side, this.getFrontSide(world, x, y, z));
    }

    public String getIconPostfix(int side, int front) {
        ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
        ForgeDirection forgeFront = ForgeDirection.getOrientation((int)front);
        ForgeDirection forgeBack = forgeFront.getOpposite();
        ForgeDirection forgeLeft = forgeFront.getRotation(ForgeDirection.UP).getOpposite();
        ForgeDirection forgeRight = forgeFront.getRotation(ForgeDirection.UP);
        if (forgeSide == forgeFront) {
            return "front";
        }
        if (forgeSide == forgeLeft) {
            return "leftSide";
        }
        if (forgeSide == forgeRight) {
            return "rightSide";
        }
        if (forgeSide == forgeBack) {
            return "back";
        }
        if (forgeSide == ForgeDirection.UP) {
            return "top";
        }
        if (forgeSide == ForgeDirection.DOWN) {
            return "bottom";
        }
        return "front";
    }

    private String getIconName(int side) {
        return this.getIconName(side, ForgeDirection.WEST.ordinal());
    }

    private String getIconName(int side, int front) {
        return this.getIconPrefix() + this.getIconPostfix(side, front);
    }

    public int func_149645_b() {
        return RenderBlockMultiTexture.renderID;
    }

    public void func_149651_a(IIconRegister register) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String name = this.getIconName(i);
            iconMap.put(name, register.func_94245_a("buildcraft:" + name));
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        IconFlipped icon = new IconFlipped(iconMap.get(this.getIconName(side, ForgeDirection.SOUTH.ordinal())));
        icon.flipU(this.shouldFlipU(side, ForgeDirection.SOUTH.ordinal()));
        icon.flipV(this.shouldFlipV(side, ForgeDirection.SOUTH.ordinal()));
        return icon;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        IconFlipped icon = new IconFlipped(iconMap.get(this.getIconName(side, this.getFrontSide(world, x, y, z))));
        icon.flipU(this.shouldFlipU(world, x, y, z, side));
        icon.flipV(this.shouldFlipV(world, x, y, z, side));
        return icon;
    }
}

