/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.SchematicRegistry;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.Position;
import buildcraft.builders.BuildingItem;
import buildcraft.builders.TileAbstractBuilder;
import buildcraft.core.BlockIndex;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BuildingSlot;
import buildcraft.core.blueprints.BuildingSlotBlock;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class BptBuilderBase
implements IAreaProvider {
    public BlueprintBase blueprint;
    public BptContext context;
    protected boolean done;
    protected TreeSet<BlockIndex> clearedLocations = new TreeSet();
    protected TreeSet<BlockIndex> builtLocations = new TreeSet();
    protected int x;
    protected int y;
    protected int z;
    protected boolean initialized = false;

    public BptBuilderBase(BlueprintBase bluePrint, World world, int x, int y, int z) {
        this.blueprint = bluePrint;
        this.x = x;
        this.y = y;
        this.z = z;
        this.done = false;
        Box box = new Box();
        box.initialize(this);
        this.context = bluePrint.getContext(world, box);
    }

    protected abstract void initialize();

    public abstract BuildingSlot getNextBlock(World var1, TileAbstractBuilder var2);

    public boolean buildNextSlot(World world, TileAbstractBuilder builder, int x, int y, int z) {
        BuildingSlot slot;
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if ((slot = this.getNextBlock(world, builder)) != null) {
            BuildingItem i = new BuildingItem();
            i.origin = new Position((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            i.destination = slot.getDestination();
            i.slotToBuild = slot;
            i.context = this.getContext();
            i.setStacksToDisplay(slot.getStacksToDisplay());
            builder.addBuildingItem(i);
            return true;
        }
        return false;
    }

    @Override
    public int xMin() {
        return this.x - this.blueprint.anchorX;
    }

    @Override
    public int yMin() {
        return this.y - this.blueprint.anchorY;
    }

    @Override
    public int zMin() {
        return this.z - this.blueprint.anchorZ;
    }

    @Override
    public int xMax() {
        return this.x + this.blueprint.sizeX - this.blueprint.anchorX - 1;
    }

    @Override
    public int yMax() {
        return this.y + this.blueprint.sizeY - this.blueprint.anchorY - 1;
    }

    @Override
    public int zMax() {
        return this.z + this.blueprint.sizeZ - this.blueprint.anchorZ - 1;
    }

    @Override
    public void removeFromWorld() {
    }

    public AxisAlignedBB getBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.xMin(), (double)this.yMin(), (double)this.zMin(), (double)this.xMax(), (double)this.yMax(), (double)this.zMax());
    }

    public void postProcessing(World world) {
    }

    public BptContext getContext() {
        return this.context;
    }

    public void removeDoneBuilders(TileAbstractBuilder builder) {
        ArrayList<BuildingItem> items = builder.getBuilders();
        for (int i = items.size() - 1; i >= 0; --i) {
            if (!items.get(i).isDone()) continue;
            items.remove(i);
        }
    }

    public boolean isDone(TileAbstractBuilder builder) {
        return this.done && builder.getBuilders().size() == 0;
    }

    protected boolean setupForDestroy(TileAbstractBuilder builder, IBuilderContext context, BuildingSlotBlock slot) {
        LinkedList result = new LinkedList();
        int hardness = (int)context.world().func_147439_a(slot.x, slot.y, slot.z).func_149712_f(context.world(), slot.x, slot.y, slot.z) + 1;
        hardness *= 2;
        if (builder.energyAvailable() < (double)hardness * SchematicRegistry.BREAK_ENERGY) {
            return false;
        }
        builder.consumeEnergy((double)hardness * SchematicRegistry.BREAK_ENERGY);
        for (int i = 0; i < hardness; ++i) {
            slot.addStackConsumed(new ItemStack((Block)BuildCraftBuilders.buildToolBlock));
        }
        return true;
    }

    public void saveBuildStateToNBT(NBTTagCompound nbt, TileAbstractBuilder builder) {
        NBTTagList clearList = new NBTTagList();
        for (BlockIndex loc : this.clearedLocations) {
            NBTTagCompound cpt = new NBTTagCompound();
            loc.writeTo(cpt);
            clearList.func_74742_a((NBTBase)cpt);
        }
        nbt.func_74782_a("clearList", (NBTBase)clearList);
        NBTTagList builtList = new NBTTagList();
        for (BlockIndex loc : this.builtLocations) {
            NBTTagCompound cpt = new NBTTagCompound();
            loc.writeTo(cpt);
            builtList.func_74742_a((NBTBase)cpt);
        }
        nbt.func_74782_a("builtList", (NBTBase)builtList);
        NBTTagList buildingList = new NBTTagList();
        for (BuildingItem item : builder.buildersInAction) {
            NBTTagCompound sub = new NBTTagCompound();
            item.writeToNBT(sub);
            buildingList.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("buildersInAction", (NBTBase)buildingList);
    }

    public void loadBuildStateToNBT(NBTTagCompound nbt, TileAbstractBuilder builder) {
        NBTTagList clearList = nbt.func_150295_c("clearList", 10);
        for (int i = 0; i < clearList.func_74745_c(); ++i) {
            NBTTagCompound cpt = clearList.func_150305_b(i);
            this.clearedLocations.add(new BlockIndex(cpt));
        }
        NBTTagList builtList = nbt.func_150295_c("builtList", 10);
        for (int i = 0; i < builtList.func_74745_c(); ++i) {
            NBTTagCompound cpt = builtList.func_150305_b(i);
            this.builtLocations.add(new BlockIndex(cpt));
        }
        NBTTagList buildingList = nbt.func_150295_c("buildersInAction", 10);
        for (int i = 0; i < buildingList.func_74745_c(); ++i) {
            BuildingItem item = new BuildingItem();
            try {
                item.readFromNBT(buildingList.func_150305_b(i));
                item.context = this.getContext();
                builder.buildersInAction.add(item);
                continue;
            }
            catch (MappingNotFoundException e) {
                BCLog.logger.log(Level.WARNING, "can't load building item", e);
            }
        }
    }
}

