/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.render.FluidRenderer;
import buildcraft.core.render.RenderUtils;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public abstract class GuiAdvancedInterface
extends GuiBuildCraft {
    public AdvancedSlot[] slots;

    public GuiAdvancedInterface(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super(container, inventory, texture);
    }

    public int getSlotAtLocation(int i, int j) {
        for (int position = 0; position < this.slots.length; ++position) {
            AdvancedSlot s = this.slots[position];
            if (i < s.x || i > s.x + 16 || j < s.y || j > s.y + 16) continue;
            return position;
        }
        return -1;
    }

    protected void drawBackgroundSlots() {
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        int i1 = 240;
        int k1 = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)i1 / 1.0f), (float)((float)k1 / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (AdvancedSlot slot : this.slots) {
            if (slot == null) continue;
            slot.drawSprite(cornerX, cornerY);
        }
        GL11.glPopMatrix();
    }

    protected void drawForegroundSelection(int mouseX, int mouseY) {
        AdvancedSlot slot;
        String s = "";
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        int position = this.getSlotAtLocation(mouseX - cornerX, mouseY - cornerY);
        if (position != -1 && (slot = this.slots[position]) != null) {
            s = slot.getDescription();
        }
        if (s.length() > 0) {
            int i2 = mouseX - cornerX;
            int k2 = mouseY - cornerY;
            this.func_146279_a(s, i2, k2);
            RenderHelper.func_74520_c();
        }
    }

    public static RenderItem getItemRenderer() {
        return field_146296_j;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    public class FluidSlot
    extends AdvancedSlot {
        public Fluid fluid;
        public int colorRenderCache;

        public FluidSlot(int x, int y) {
            super(GuiAdvancedInterface.this, x, y);
        }

        @Override
        public void drawSprite(int cornerX, int cornerY) {
            if (this.fluid != null) {
                RenderUtils.setGLColorFromInt(this.colorRenderCache);
            }
            super.drawSprite(cornerX, cornerY);
        }

        @Override
        public IIcon getIcon() {
            return FluidRenderer.getFluidTexture(this.fluid, false);
        }

        @Override
        public ResourceLocation getTexture() {
            return FluidRenderer.getFluidSheet(this.fluid);
        }
    }

    public class IInventorySlot
    extends AdvancedSlot {
        private IInventory tile;
        private int slot;

        public IInventorySlot(int x, int y, IInventory tile, int slot) {
            super(GuiAdvancedInterface.this, x, y);
            this.tile = tile;
            this.slot = slot;
        }

        @Override
        public ItemStack getItemStack() {
            return this.tile.func_70301_a(this.slot);
        }
    }

    public class ItemSlot
    extends AdvancedSlot {
        public ItemStack stack;

        public ItemSlot(int x, int y) {
            super(GuiAdvancedInterface.this, x, y);
        }

        @Override
        public ItemStack getItemStack() {
            return this.stack;
        }
    }
}

