/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCMessageInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.ArrayUtils;

public class PacketRPCTile
extends BuildCraftPacket {
    public static int GLOBAL_ID = new Random(new Date().getTime()).nextInt();
    public static HashMap<Integer, ByteBuf> bufferedPackets = new HashMap();
    public TileEntity tile;
    byte[] contents;
    int id;
    boolean moreDataToCome = false;
    int dimId;
    int x;
    int y;
    int z;

    public PacketRPCTile() {
        this.id = GLOBAL_ID++;
    }

    public PacketRPCTile(TileEntity tile, byte[] bytes) {
        this.tile = tile;
        this.contents = bytes;
    }

    public void setTile(TileEntity aTile) {
        this.tile = aTile;
    }

    @Override
    public int getID() {
        return 110;
    }

    @Override
    public void readData(ByteBuf data) {
        this.dimId = data.readShort();
        this.x = data.readInt();
        this.y = data.readInt();
        this.z = data.readInt();
        this.id = data.readInt();
        this.moreDataToCome = data.readBoolean();
        this.contents = new byte[data.readableBytes()];
        data.readBytes(this.contents);
    }

    public void call(EntityPlayer sender) {
        ByteBuf completeData;
        World world = null;
        if (!sender.field_70170_p.field_72995_K) {
            world = DimensionManager.getProvider((int)this.dimId).field_76579_a;
        } else if (sender.field_70170_p.field_73011_w.field_76574_g == this.dimId) {
            world = sender.field_70170_p;
        }
        TileEntity localTile = world.func_147438_o(this.x, this.y, this.z);
        this.setTile(localTile);
        RPCMessageInfo info = new RPCMessageInfo();
        info.sender = sender;
        ByteBuf previousData = bufferedPackets.get(this.id);
        bufferedPackets.remove(this.id);
        if (previousData != null) {
            completeData = previousData.writeBytes(this.contents);
        } else {
            completeData = Unpooled.buffer();
            completeData.writeBytes(this.contents);
        }
        if (!this.moreDataToCome) {
            RPCHandler.receiveRPC(localTile, info, completeData);
        } else {
            bufferedPackets.put(this.id, completeData);
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeShort(this.tile.func_145831_w().field_73011_w.field_76574_g);
        data.writeInt(this.tile.field_145851_c);
        data.writeInt(this.tile.field_145848_d);
        data.writeInt(this.tile.field_145849_e);
        data.writeInt(this.id);
        data.writeBoolean(this.moreDataToCome);
        data.writeBytes(this.contents);
    }

    public ArrayList<PacketRPCTile> breakIntoSmallerPackets(int maxSize) {
        ArrayList<PacketRPCTile> messages = new ArrayList<PacketRPCTile>();
        if (this.contents.length < maxSize) {
            messages.add(this);
            return messages;
        }
        int start = 0;
        while (true) {
            byte[] subContents = ArrayUtils.subarray((byte[])this.contents, (int)start, (int)(start + maxSize));
            PacketRPCTile subPacket = new PacketRPCTile();
            subPacket.id = this.id;
            subPacket.contents = subContents;
            subPacket.tile = this.tile;
            messages.add(subPacket);
            if ((start += maxSize) >= this.contents.length) break;
            subPacket.moreDataToCome = true;
        }
        subPacket.moreDataToCome = false;
        return messages;
    }
}

